/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.vfs;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.platform.UnsupportedFileOperationException;
import com.sshtools.daemon.vfs.VFSMount;
import com.sshtools.daemon.vfs.VFSPermission;
import com.sshtools.daemon.vfs.VFSPermissionHandler;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualFileSystem
extends NativeFileSystemProvider {
    private static String USER_HOME = "/home/";
    private static Map vfsmounts;
    private static VFSMount vfsroot;
    private static Log log;
    private static VFSPermissionHandler permissionHandler;
    private Map openFiles = new HashMap();
    static /* synthetic */ Class class$com$sshtools$daemon$vfs$VirtualFileSystem;
    static /* synthetic */ Class class$com$sshtools$daemon$configuration$PlatformConfiguration;

    public VirtualFileSystem() throws IOException {
        if (!ConfigurationLoader.isConfigurationAvailable((Class)(class$com$sshtools$daemon$configuration$PlatformConfiguration == null ? (class$com$sshtools$daemon$configuration$PlatformConfiguration = VirtualFileSystem.class$("com.sshtools.daemon.configuration.PlatformConfiguration")) : class$com$sshtools$daemon$configuration$PlatformConfiguration))) {
            throw new IOException("No valid platform configuration available");
        }
    }

    public static void setPermissionHandler(VFSPermissionHandler vFSPermissionHandler) {
        permissionHandler = vFSPermissionHandler;
    }

    private static String getVFSHomeDirectory(String string) throws FileNotFoundException {
        if (permissionHandler != null) {
            return permissionHandler.getVFSHomeDirectory(string);
        }
        return USER_HOME + string;
    }

    private static String getNFSHomeDirectory() throws FileNotFoundException {
        try {
            if (Thread.currentThread() instanceof SshThread && SshThread.hasUserContext()) {
                NativeAuthenticationProvider nativeAuthenticationProvider = NativeAuthenticationProvider.getInstance();
                return nativeAuthenticationProvider.getHomeDirectory(SshThread.getCurrentThreadUser());
            }
            throw new FileNotFoundException("There is no user logged in");
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.substring(0, string2.length() > string.length() ? string.length() : string2.length()).equalsIgnoreCase(string2);
    }

    public static String translateNFSPath(String string) throws FileNotFoundException {
        if ((string = string.replace('\\', '/')).startsWith("./")) {
            string = string.substring(2);
        }
        try {
            String string2 = VirtualFileSystem.getNFSHomeDirectory().replace('\\', '/');
            string2 = VirtualFileSystem.translateCanonicalPath(string2, string2);
            String string3 = VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser());
            log.debug((Object)("NFSPath=" + string));
            log.debug((Object)("NFSHome=" + string2));
            string = VirtualFileSystem.translateCanonicalPath(string, string2);
            int n = string.indexOf(string2);
            return string3 + string.substring(string2.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4;
            Iterator iterator = vfsmounts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string5 = (String)entry.getKey();
                VFSMount vFSMount = (VFSMount)entry.getValue();
                string4 = vFSMount.getPath();
                log.debug((Object)(vFSMount.getMount() + "=" + vFSMount.getPath()));
                try {
                    string = VirtualFileSystem.translateCanonicalPath(string, string4);
                    int n = string.indexOf(string4);
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer = stringBuffer.replace(n, n + string4.length(), string5);
                    return stringBuffer.toString();
                }
                catch (FileNotFoundException fileNotFoundException2) {
                }
            }
            log.debug((Object)("VFSRoot=" + vfsroot.getPath()));
            string = VirtualFileSystem.translateCanonicalPath(string, vfsroot.getPath());
            string4 = string.substring(vfsroot.getPath().length());
            return string4.startsWith("/") ? string4 : "/" + string4;
        }
    }

    private static VFSMount getMount(String string) throws FileNotFoundException, IOException {
        String string2 = VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser());
        if (string.startsWith("/")) {
            if (string.startsWith(string2)) {
                VFSMount vFSMount = new VFSMount(string2, VirtualFileSystem.getNFSHomeDirectory());
                vFSMount.setPermissions(new VFSPermission(SshThread.getCurrentThreadUser(), "rwx"));
                return vFSMount;
            }
            Iterator iterator = vfsmounts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                if (!string.startsWith(string3)) continue;
                return (VFSMount)entry.getValue();
            }
            if (vfsroot != null) {
                return vfsroot;
            }
            throw new FileNotFoundException("The path was not found");
        }
        VFSMount vFSMount = new VFSMount(string2, VirtualFileSystem.getNFSHomeDirectory());
        vFSMount.setPermissions(new VFSPermission(string2.substring(string2.lastIndexOf("/")), "rwx"));
        return vFSMount;
    }

    public static String translateVFSPath(String string) throws FileNotFoundException {
        return VirtualFileSystem.translateVFSPath(string, null);
    }

    public static String translateVFSPath(String string, String string2) throws FileNotFoundException {
        String string3;
        Object object;
        Object object2;
        string = string.replace('\\', '/').trim();
        try {
            if (!string.startsWith("/")) {
                object2 = string2 == null || string2.trim().equals("") ? VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser()) : string2;
                string = (String)object2 + (((String)object2).endsWith("/") ? "" : "/") + string;
            }
            object2 = VirtualFileSystem.getNFSHomeDirectory().replace('\\', '/');
            object = VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser());
            if (string.startsWith((String)object)) {
                if (string.length() > ((String)object).length()) {
                    return VirtualFileSystem.translateCanonicalPath((String)object2 + (((String)object2).endsWith("/") ? "" : "/") + string.substring(((String)object).length() + 1), (String)object2);
                }
                return VirtualFileSystem.translateCanonicalPath((String)object2, (String)object2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        object2 = vfsmounts.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            String string4 = (String)object.getKey();
            VFSMount vFSMount = (VFSMount)object.getValue();
            string3 = vFSMount.getPath();
            if (!string.startsWith(string4)) continue;
            String string5 = string3 + string.substring(string4.length());
            return VirtualFileSystem.translateCanonicalPath(string5, string3);
        }
        if (vfsroot != null) {
            string3 = vfsroot.getPath() + (vfsroot.getPath().endsWith("/") ? string.substring(1) : string);
            return VirtualFileSystem.translateCanonicalPath(string3, vfsroot.getPath());
        }
        throw new FileNotFoundException("The file could not be found");
    }

    public static String translateCanonicalPath(String string, String string2) throws FileNotFoundException {
        try {
            log.debug((Object)("Translating for canonical path " + string + " against secure mount " + string2));
            File file = new File(string);
            String string3 = file.getCanonicalPath().replace('\\', '/');
            File file2 = new File(string2);
            String string4 = file2.getCanonicalPath().replace('\\', '/');
            if (string3.startsWith(string4)) {
                return string3;
            }
            throw new FileNotFoundException(string + " could not be found");
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " could not be found");
        }
    }

    public boolean makeDirectory(String string) throws PermissionDeniedException, FileNotFoundException, IOException {
        string = VirtualFileSystem.translateVFSPath(string);
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "rw");
        log.debug((Object)("Creating directory " + file.getAbsolutePath()));
        return file.mkdir();
    }

    public VFSPermission getVFSPermission(String string) throws FileNotFoundException, IOException {
        VFSMount vFSMount = VirtualFileSystem.getMount(VirtualFileSystem.translateNFSPath(string));
        if (vFSMount.getPermissions().containsKey(SshThread.getCurrentThreadUser())) {
            return (VFSPermission)vFSMount.getPermissions().get(SshThread.getCurrentThreadUser());
        }
        return (VFSPermission)vFSMount.getPermissions().get("default");
    }

    public FileAttributes getFileAttributes(byte[] byArray) throws IOException, InvalidHandleException {
        String string = new String(byArray);
        if (this.openFiles.containsKey(string)) {
            File file;
            Object v = this.openFiles.get(string);
            if (v instanceof OpenFile) {
                file = ((OpenFile)v).getFile();
            } else if (v instanceof OpenDirectory) {
                file = ((OpenDirectory)v).getFile();
            } else {
                throw new IOException("Unexpected open file handle");
            }
            VFSPermission vFSPermission = this.getVFSPermission(file.getAbsolutePath());
            if (vFSPermission == null) {
                throw new IOException("No default permissions set");
            }
            FileAttributes fileAttributes = new FileAttributes();
            fileAttributes.setSize(new UnsignedInteger64(String.valueOf(file.length())));
            fileAttributes.setTimes(new UnsignedInteger32(file.lastModified() / 1000L), new UnsignedInteger32(file.lastModified() / 1000L));
            boolean bl = true;
            try {
                if (System.getSecurityManager() != null) {
                    System.getSecurityManager().checkExec(file.getCanonicalPath());
                }
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            fileAttributes.setPermissions((file.canRead() && vFSPermission.canRead() ? "r" : "-") + (file.canWrite() && vFSPermission.canWrite() ? "w" : "-") + (bl && vFSPermission.canExecute() ? "x" : "-"));
            fileAttributes.setPermissions(new UnsignedInteger32(fileAttributes.getPermissions().longValue() | (long)(file.isDirectory() ? 16384 : 32768)));
            return fileAttributes;
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    public FileAttributes getFileAttributes(String string) throws IOException, FileNotFoundException {
        log.debug((Object)("Getting file attributes for " + string));
        string = VirtualFileSystem.translateVFSPath(string);
        File file = new File(string);
        string = file.getCanonicalPath();
        if (!file.exists()) {
            throw new FileNotFoundException(string + " doesn't exist");
        }
        VFSPermission vFSPermission = this.getVFSPermission(string);
        if (vFSPermission == null) {
            throw new IOException("No default permissions set");
        }
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setSize(new UnsignedInteger64(String.valueOf(file.length())));
        fileAttributes.setTimes(new UnsignedInteger32(file.lastModified() / 1000L), new UnsignedInteger32(file.lastModified() / 1000L));
        boolean bl = true;
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkExec(file.getCanonicalPath());
            }
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        fileAttributes.setPermissions((file.canRead() && vFSPermission.canRead() ? "r" : "-") + (file.canWrite() && vFSPermission.canWrite() ? "w" : "-") + (bl && vFSPermission.canExecute() ? "x" : "-"));
        fileAttributes.setPermissions(new UnsignedInteger32(fileAttributes.getPermissions().longValue() | (long)(file.isDirectory() ? 16384 : 32768)));
        return fileAttributes;
    }

    public byte[] openDirectory(String string) throws PermissionDeniedException, FileNotFoundException, IOException {
        String string2 = string;
        string = VirtualFileSystem.translateVFSPath(string);
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "r");
        if (file.exists()) {
            if (file.isDirectory()) {
                this.openFiles.put(file.toString(), new OpenDirectory(string2, string, file));
                return file.toString().getBytes("US-ASCII");
            }
            throw new IOException(VirtualFileSystem.translateNFSPath(string) + " is not a directory");
        }
        throw new FileNotFoundException(VirtualFileSystem.translateNFSPath(string) + " does not exist");
    }

    public SftpFile[] readDirectory(byte[] byArray) throws InvalidHandleException, EOFException, IOException {
        String string = new String(byArray);
        if (this.openFiles.containsKey(string)) {
            Object v = this.openFiles.get(string);
            if (v instanceof OpenDirectory) {
                int n;
                OpenDirectory openDirectory = (OpenDirectory)v;
                int n2 = openDirectory.getPosition();
                File[] fileArray = openDirectory.getChildren();
                if (fileArray == null) {
                    throw new IOException("Permission denined.");
                }
                int n3 = n = fileArray.length - n2 < 100 ? fileArray.length - n2 : 100;
                if (n > 0) {
                    SftpFile[] sftpFileArray = new SftpFile[n];
                    for (int i = 0; i < sftpFileArray.length; ++i) {
                        SftpFile sftpFile;
                        File file = fileArray[n2 + i];
                        String string2 = openDirectory.realPath + "/" + file.getName();
                        sftpFileArray[i] = sftpFile = new SftpFile(file.getName(), this.getFileAttributes(string2));
                    }
                    openDirectory.readpos = n2 + sftpFileArray.length;
                    return sftpFileArray;
                }
                throw new EOFException("There are no more files");
            }
            throw new InvalidHandleException("Handle is not an open directory");
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] openFile(String string, UnsignedInteger32 unsignedInteger32, FileAttributes fileAttributes) throws PermissionDeniedException, FileNotFoundException, IOException {
        string = VirtualFileSystem.translateVFSPath(string);
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "r");
        if (!file.exists()) {
            if ((unsignedInteger32.intValue() & 8) != 8) throw new FileNotFoundException(VirtualFileSystem.translateNFSPath(string) + " does not exist");
            if (!file.createNewFile()) {
                throw new IOException(VirtualFileSystem.translateNFSPath(string) + " could not be created");
            }
        } else if ((unsignedInteger32.intValue() & 8) == 8 && (unsignedInteger32.intValue() & 0x20) == 32) {
            throw new IOException(VirtualFileSystem.translateNFSPath(string) + " already exists");
        }
        String string2 = "r" + ((unsignedInteger32.intValue() & 2) == 2 ? "ws" : "");
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, string2);
        if ((unsignedInteger32.intValue() & 8) == 8 && (unsignedInteger32.intValue() & 0x10) == 16) {
            randomAccessFile.setLength(0L);
        }
        this.openFiles.put(randomAccessFile.toString(), new OpenFile(file, randomAccessFile, unsignedInteger32));
        return randomAccessFile.toString().getBytes("US-ASCII");
    }

    public byte[] readFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, UnsignedInteger32 unsignedInteger32) throws InvalidHandleException, EOFException, IOException {
        String string = new String(byArray);
        if (this.openFiles.containsKey(string)) {
            Object v = this.openFiles.get(string);
            if (v instanceof OpenFile) {
                OpenFile openFile = (OpenFile)v;
                if ((openFile.getFlags().intValue() & 1) == 1) {
                    int n;
                    byte[] byArray2 = new byte[unsignedInteger32.intValue()];
                    if (openFile.getRandomAccessFile().getFilePointer() != unsignedInteger64.longValue()) {
                        openFile.getRandomAccessFile().seek(unsignedInteger64.longValue());
                    }
                    if ((n = openFile.getRandomAccessFile().read(byArray2)) >= 0) {
                        if (n == byArray2.length) {
                            return byArray2;
                        }
                        byte[] byArray3 = new byte[n];
                        System.arraycopy(byArray2, 0, byArray3, 0, n);
                        return byArray3;
                    }
                    throw new EOFException("The file is EOF");
                }
                throw new InvalidHandleException("The file handle was not opened for reading");
            }
            throw new InvalidHandleException("Handle is not an open file");
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) throws InvalidHandleException, IOException {
        String string = new String(byArray);
        if (!this.openFiles.containsKey(string)) throw new InvalidHandleException("The handle is invalid");
        Object v = this.openFiles.get(string);
        if (!(v instanceof OpenFile)) throw new InvalidHandleException("Handle is not an open file");
        OpenFile openFile = (OpenFile)v;
        if ((openFile.getFlags().intValue() & 2) != 2) throw new InvalidHandleException("The file was not opened for writing");
        if ((openFile.getFlags().intValue() & 4) == 4) {
            openFile.getRandomAccessFile().seek(openFile.getRandomAccessFile().length());
        } else if (openFile.getRandomAccessFile().getFilePointer() != unsignedInteger64.longValue()) {
            openFile.getRandomAccessFile().seek(unsignedInteger64.longValue());
        }
        openFile.getRandomAccessFile().write(byArray2, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeFile(byte[] byArray) throws InvalidHandleException, IOException {
        String string = new String(byArray);
        if (!this.openFiles.containsKey(string)) throw new InvalidHandleException("The handle is invalid");
        Object v = this.openFiles.get(string);
        if (v instanceof OpenDirectory) {
            this.openFiles.remove(string);
            return;
        } else {
            if (!(v instanceof OpenFile)) throw new InvalidHandleException("Internal server error");
            ((OpenFile)v).getRandomAccessFile().close();
            this.openFiles.remove(string);
        }
    }

    public void removeFile(String string) throws PermissionDeniedException, IOException, FileNotFoundException {
        block5: {
            File file = new File(string = VirtualFileSystem.translateVFSPath(string));
            if (file.exists()) {
                try {
                    if (file.isFile()) {
                        if (!file.delete()) {
                            throw new IOException("Failed to delete " + VirtualFileSystem.translateNFSPath(string));
                        }
                        break block5;
                    }
                    throw new IOException(VirtualFileSystem.translateNFSPath(string) + " is a directory, use remove directory command to remove");
                }
                catch (SecurityException securityException) {
                    throw new PermissionDeniedException("Permission denied");
                }
            }
            throw new FileNotFoundException(VirtualFileSystem.translateNFSPath(string) + " does not exist");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameFile(String string, String string2) throws PermissionDeniedException, FileNotFoundException, IOException {
        string = VirtualFileSystem.translateVFSPath(string);
        string2 = VirtualFileSystem.translateVFSPath(string2);
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "rw");
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string2, "rw");
        if (!file.exists()) throw new FileNotFoundException(VirtualFileSystem.translateNFSPath(string) + " does not exist");
        File file2 = new File(string2);
        if (file2.exists()) throw new IOException(VirtualFileSystem.translateNFSPath(string2) + " already exists");
        if (file.renameTo(file2)) return;
        throw new IOException("Failed to rename file " + VirtualFileSystem.translateNFSPath(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeDirectory(String string) throws PermissionDeniedException, FileNotFoundException, IOException {
        string = VirtualFileSystem.translateVFSPath(string);
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "rw");
        if (!file.isDirectory()) throw new IOException(VirtualFileSystem.translateNFSPath(string) + " is not a directory");
        if (!file.exists()) throw new FileNotFoundException(VirtualFileSystem.translateNFSPath(string) + " does not exist");
        if (file.listFiles().length != 0) throw new IOException(VirtualFileSystem.translateNFSPath(string) + " is not an empty directory");
        if (file.delete()) return;
        throw new IOException("Failed to remove directory " + VirtualFileSystem.translateNFSPath(string));
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws PermissionDeniedException, IOException, FileNotFoundException {
    }

    public void setFileAttributes(byte[] byArray, FileAttributes fileAttributes) throws PermissionDeniedException, IOException, InvalidHandleException {
    }

    public SftpFile readSymbolicLink(String string) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
    }

    public void createSymbolicLink(String string, String string2) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
    }

    public boolean fileExists(String string) throws IOException {
        File file = new File(VirtualFileSystem.translateVFSPath(string));
        return file.exists();
    }

    public String getDefaultPath(String string) throws FileNotFoundException {
        return VirtualFileSystem.getVFSHomeDirectory(string);
    }

    public String getCanonicalPath(String string) throws IOException, FileNotFoundException {
        File file = new File(VirtualFileSystem.translateVFSPath(string));
        return file.getCanonicalPath();
    }

    public String getRealPath(String string) throws FileNotFoundException {
        log.debug((Object)("Get real path for '" + string + "'"));
        string = VirtualFileSystem.translateVFSPath(string);
        log.debug((Object)("Translated VFS is '" + string + "'"));
        string = VirtualFileSystem.translateNFSPath(string);
        log.debug((Object)("Translated NFS is '" + string + "'"));
        return string;
    }

    public void verifyPermissions(String string, String string2, String string3) throws PermissionDeniedException, FileNotFoundException, IOException {
        String string4 = VirtualFileSystem.translateNFSPath(string2);
        if (permissionHandler == null) {
            VFSPermission vFSPermission;
            VFSMount vFSMount = VirtualFileSystem.getMount(string4);
            if (vFSMount.getPermissions().containsKey(SshThread.getCurrentThreadUser())) {
                vFSPermission = (VFSPermission)vFSMount.getPermissions().get(SshThread.getCurrentThreadUser());
            } else if (vFSMount.getPermissions().containsKey("default")) {
                vFSPermission = (VFSPermission)vFSMount.getPermissions().get("default");
            } else {
                throw new PermissionDeniedException("No permissions set for mount");
            }
            if (!vFSPermission.verifyPermissions(string3)) {
                throw new PermissionDeniedException("Permission denied for " + VirtualFileSystem.translateNFSPath(string2));
            }
        } else {
            permissionHandler.verifyPermissions(string, string2, string3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$com$sshtools$daemon$vfs$VirtualFileSystem == null ? (class$com$sshtools$daemon$vfs$VirtualFileSystem = VirtualFileSystem.class$("com.sshtools.daemon.vfs.VirtualFileSystem")) : class$com$sshtools$daemon$vfs$VirtualFileSystem));
        permissionHandler = null;
        try {
            vfsmounts = ((PlatformConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$PlatformConfiguration == null ? (class$com$sshtools$daemon$configuration$PlatformConfiguration = VirtualFileSystem.class$("com.sshtools.daemon.configuration.PlatformConfiguration")) : class$com$sshtools$daemon$configuration$PlatformConfiguration))).getVFSMounts();
            vfsroot = ((PlatformConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$PlatformConfiguration == null ? (class$com$sshtools$daemon$configuration$PlatformConfiguration = VirtualFileSystem.class$("com.sshtools.daemon.configuration.PlatformConfiguration")) : class$com$sshtools$daemon$configuration$PlatformConfiguration))).getVFSRoot();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)"Failed to initialize the Virtual File System", (Throwable)configurationException);
        }
    }

    class OpenDirectory {
        File f;
        File[] children;
        int readpos = 0;
        String path;
        String realPath;

        public OpenDirectory(String string, String string2, File file) {
            this.path = string2;
            this.realPath = string;
            this.f = file;
            this.children = file.listFiles();
        }

        public File getFile() {
            return this.f;
        }

        public File[] getChildren() {
            return this.children;
        }

        public int getPosition() {
            return this.readpos;
        }

        public void setPosition(int n) {
            this.readpos = n;
        }
    }

    class OpenFile {
        File f;
        RandomAccessFile raf;
        UnsignedInteger32 flags;

        public OpenFile(File file, RandomAccessFile randomAccessFile, UnsignedInteger32 unsignedInteger32) {
            this.f = file;
            this.raf = randomAccessFile;
            this.flags = unsignedInteger32;
        }

        public File getFile() {
            return this.f;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.raf;
        }

        public UnsignedInteger32 getFlags() {
            return this.flags;
        }
    }
}

