/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.XMLCatalog;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsImport2
extends MatchingTask {
    private final CommandlineJava cmd = new CommandlineJava();
    private File destDir = null;
    private final Commandline xjcCmdLine = new Commandline();
    private boolean xdebug = false;
    private boolean xnocompile = false;
    private boolean xadditionalHeaders = false;
    private String wsdlLocation;
    private XMLCatalog xmlCatalog;
    private String pkg;
    private boolean failonerror = true;
    protected boolean extension;
    protected boolean xNoAddressingDatabinding;
    private boolean keep = false;
    private boolean quiet = false;
    private String target;
    private boolean fork = false;
    private boolean optimize = false;
    private File sourcedestdir;
    protected boolean verbose = false;
    private boolean debug = false;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;
    private final ArrayList<File> dependsSet = new ArrayList();
    private final ArrayList<File> producesSet = new ArrayList();
    private boolean producesSpecified = false;
    private File catalog;
    private String wsdl;
    private File xauthfile;
    private Set<File> bindingFiles = new HashSet<File>();

    public boolean isXdebug() {
        return this.xdebug;
    }

    public void setXdebug(boolean xdebug) {
        this.xdebug = xdebug;
    }

    public boolean isXnocompile() {
        return this.xnocompile;
    }

    public void setXnocompile(boolean xnocompile) {
        this.xnocompile = xnocompile;
    }

    public Commandline.Argument createArg() {
        return this.cmd.createArgument();
    }

    public boolean isXadditionalHeaders() {
        return this.xadditionalHeaders;
    }

    public void setXadditionalHeaders(boolean xadditionalHeaders) {
        this.xadditionalHeaders = xadditionalHeaders;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File base) {
        this.destDir = base;
    }

    public String getWsdllocation() {
        return this.wsdlLocation;
    }

    public void setWsdllocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void addConfiguredXMLCatalog(XMLCatalog entityResolver) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(entityResolver);
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getPackage() {
        return this.pkg;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    public Commandline.Argument createXjcarg() {
        return this.xjcCmdLine.createArgument();
    }

    public void setFailonerror(boolean value) {
        this.failonerror = value;
    }

    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean getxNoAddressingDatabinding() {
        return this.xNoAddressingDatabinding;
    }

    public void setxNoAddressingDatabinding(boolean xNoAddressingDatabinding) {
        this.xNoAddressingDatabinding = xNoAddressingDatabinding;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setTarget(String version) {
        Options.Target targetVersion = Options.Target.parse(version);
        if (targetVersion == null) {
            throw new BuildException(version + " is not a valid version number");
        }
        this.target = targetVersion.getVersion();
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setSourcedestdir(File sourceBase) {
        this.keep = true;
        this.sourcedestdir = sourceBase;
    }

    public File getSourcedestdir() {
        return this.sourcedestdir;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void addConfiguredDepends(FileSet fs) {
        this.addIndividualFilesTo(fs, this.dependsSet);
    }

    public void addConfiguredProduces(FileSet fs) {
        this.producesSpecified = true;
        if (!fs.getDir(this.getProject()).exists()) {
            this.log(fs.getDir(this.getProject()).getAbsolutePath() + " is not found and thus excluded from the dependency check", 2);
        } else {
            this.addIndividualFilesTo(fs, this.producesSet);
        }
    }

    private void addIndividualFilesTo(FileSet fs, List<File> lst) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            lst.add(new File(baseDir, value));
        }
    }

    private long computeTimestampFor(List<File> files, boolean findNewest) {
        long lastModified = findNewest ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (File file : files) {
            this.log("Checking timestamp of " + file.toString(), 3);
            if (findNewest) {
                lastModified = Math.max(lastModified, file.lastModified());
                continue;
            }
            lastModified = Math.min(lastModified, file.lastModified());
        }
        if (lastModified == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (lastModified == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return lastModified;
    }

    public void setBinding(String binding) {
        File f = new File(binding);
        this.bindingFiles.add(f);
        this.dependsSet.add(f);
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public File getCatalog() {
        return this.catalog;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
        this.dependsSet.add(new File(wsdl));
    }

    public File getXauthfile() {
        return this.xauthfile;
    }

    public void setXauthfile(File xauthfile) {
        this.xauthfile = xauthfile;
    }

    public void addConfiguredBinding(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String includedFile : includedFiles) {
            this.bindingFiles.add(new File(baseDir, includedFile));
        }
        this.addIndividualFilesTo(fs, this.dependsSet);
    }

    private void setupWsimportForkCommand() {
        ClassLoader loader;
        for (loader = ((Object)((Object)this)).getClass().getClassLoader(); loader != null && !(loader instanceof AntClassLoader); loader = loader.getParent()) {
        }
        if (loader != null) {
            Path classpath = new Path(this.project, ((AntClassLoader)loader).getClasspath());
            this.cmd.createClasspath(this.getProject()).append(classpath);
        }
        this.cmd.setClassname("com.sun.tools.ws.WsImport");
    }

    private void setupWsimportArgs() {
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.getDestdir());
        }
        if (this.getExtension()) {
            this.cmd.createArgument().setValue("-extension");
        }
        if (this.getxNoAddressingDatabinding()) {
            this.cmd.createArgument().setValue("-Xno-addressing-databinding");
        }
        if (this.getDebug()) {
            this.cmd.createArgument().setValue("-g");
        }
        if (this.isXdebug()) {
            this.cmd.createArgument().setValue("-Xdebug");
        }
        if (this.isXnocompile()) {
            this.cmd.createArgument().setValue("-Xnocompile");
        }
        if (this.isXadditionalHeaders()) {
            this.cmd.createArgument().setValue("-XadditionalHeaders");
        }
        if (this.getKeep()) {
            this.cmd.createArgument().setValue("-keep");
        }
        if (this.getOptimize()) {
            this.cmd.createArgument().setValue("-O");
        }
        if (null != this.getSourcedestdir() && !this.getSourcedestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-s");
            this.cmd.createArgument().setFile(this.getSourcedestdir());
        }
        if (this.getCatalog() != null && this.getCatalog().getName().length() > 0) {
            this.cmd.createArgument().setValue("-catalog");
            this.cmd.createArgument().setFile(this.getCatalog());
        }
        if (this.getVerbose()) {
            this.cmd.createArgument().setValue("-verbose");
        }
        if (this.quiet) {
            this.cmd.createArgument().setValue("-quiet");
        }
        if (this.target != null) {
            this.cmd.createArgument().setValue("-target");
            this.cmd.createArgument().setValue(this.target);
        }
        if (this.getWsdl() != null) {
            this.cmd.createArgument().setValue(this.getWsdl());
        }
        if (this.getXauthfile() != null) {
            this.cmd.createArgument().setValue("-Xauthfile");
            this.cmd.createArgument().setFile(this.getXauthfile());
        }
        if (this.getPackage() != null && this.getPackage().length() > 0) {
            this.cmd.createArgument().setValue("-p");
            this.cmd.createArgument().setValue(this.getPackage());
        }
        for (String a : this.xjcCmdLine.getArguments()) {
            if (a.startsWith("-")) {
                this.cmd.createArgument().setValue("-B" + a);
                continue;
            }
            this.cmd.createArgument().setValue(a);
        }
        if (!this.bindingFiles.isEmpty()) {
            for (File binding : this.bindingFiles) {
                this.cmd.createArgument().setValue("-b");
                this.cmd.createArgument().setFile(binding);
            }
        }
        if (this.wsdlLocation != null && this.wsdlLocation.length() != 0) {
            this.cmd.createArgument().setValue("-wsdllocation");
            this.cmd.createArgument().setValue(this.wsdlLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        LogOutputStream logstr = null;
        boolean ok = false;
        try {
            if (!this.producesSpecified) {
                this.log("Consider using <depends>/<produces> so that wsimport won't do unnecessary compilation", 2);
            }
            long srcTime = this.computeTimestampFor(this.dependsSet, true);
            long dstTime = this.computeTimestampFor(this.producesSet, false);
            this.log("the last modified time of the inputs is  " + srcTime, 3);
            this.log("the last modified time of the outputs is " + dstTime, 3);
            if (srcTime < dstTime) {
                this.log("files are up to date");
                return;
            }
            if (this.fork) {
                this.setupWsimportForkCommand();
            } else if (this.cmd.getVmCommand().size() > 1) {
                this.log("JVM args ignored when same JVM is used.", 1);
            }
            this.setupWsimportArgs();
            if (this.fork) {
                int status;
                if (this.verbose) {
                    this.log("command line: wsimport " + this.cmd.toString());
                }
                ok = (status = this.run(this.cmd.getCommandline())) == 0;
            } else {
                if (this.verbose) {
                    this.log("command line: wsimport " + this.cmd.getJavaCommand().toString());
                }
                logstr = new LogOutputStream((Task)this, 1);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
                String sysPath = System.getProperty("java.class.path");
                try {
                    WsimportTool compTool = new WsimportTool((OutputStream)logstr);
                    if (this.xmlCatalog != null) {
                        compTool.setEntityResolver((EntityResolver)this.xmlCatalog);
                    }
                    if (loader instanceof AntClassLoader) {
                        System.setProperty("java.class.path", ((AntClassLoader)loader).getClasspath());
                    }
                    ok = compTool.run(this.cmd.getJavaCommand().getArguments());
                }
                finally {
                    if (sysPath != null) {
                        System.setProperty("java.class.path", sysPath);
                    }
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            if (!ok) {
                if (!this.verbose) {
                    this.log("Command invoked: wsimport " + this.cmd.toString());
                }
                throw new BuildException("wsimport failed", this.location);
            }
        }
        catch (Exception ex) {
            if (this.failonerror) {
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException("Error starting wsimport: ", (Throwable)ex, this.getLocation());
            }
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.getProject().log(sw.toString(), 1);
        }
        finally {
            try {
                if (logstr != null) {
                    logstr.close();
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private int run(String[] command) throws BuildException {
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.project);
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

