/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import org.opends.messages.Message;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;

public class QuickSetupCli {
    protected Launcher launcher;
    private CliApplication cliApp;
    private UserData userData;

    public QuickSetupCli(CliApplication cliApp, Launcher launcher) {
        this.cliApp = cliApp;
        this.launcher = launcher;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public ReturnCode run() {
        ReturnCode returnValue;
        try {
            PlainTextProgressMessageFormatter formatter = new PlainTextProgressMessageFormatter();
            this.cliApp.setProgressMessageFormatter(formatter);
            this.userData = this.cliApp.createUserData(this.launcher);
            if (this.userData != null) {
                this.cliApp.setUserData(this.userData);
                if (!this.userData.isQuiet()) {
                    this.cliApp.addProgressUpdateListener(new ProgressUpdateListener(){

                        public void progressUpdate(ProgressUpdateEvent ev) {
                            Message newLogs = ev.getNewLogs();
                            if (newLogs != null) {
                                System.out.print(StaticUtils.wrapText(newLogs, Utils.getCommandLineMaxLineWidth()));
                            }
                        }
                    });
                }
                Thread appThread = new Thread((Runnable)this.cliApp, "CLI Application");
                appThread.start();
                while (!Thread.State.TERMINATED.equals((Object)appThread.getState())) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                returnValue = this.cliApp.getReturnCode();
                if (returnValue == null) {
                    ApplicationException ue = this.cliApp.getRunError();
                    returnValue = ue != null ? ue.getType() : ReturnCode.SUCCESSFUL;
                }
            } else {
                returnValue = ReturnCode.CANCELLED;
            }
        }
        catch (UserDataException uude) {
            System.err.println();
            System.err.println(StaticUtils.wrapText(uude.getLocalizedMessage(), Utils.getCommandLineMaxLineWidth()));
            System.err.println();
            returnValue = uude.getCause() instanceof CLIException ? ReturnCode.USER_INPUT_ERROR : ReturnCode.USER_DATA_ERROR;
        }
        catch (ApplicationException ae) {
            System.err.println();
            System.err.println(ae.getLocalizedMessage());
            System.err.println();
            returnValue = ae.getType();
        }
        return returnValue;
    }
}

