/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ADSContextHelper;
import org.opends.messages.AdminMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsFrameworkCliAds
implements DsFrameworkCliSubCommandGroup {
    DsFrameworkCliParser argParser;
    public SubCommand createAdsSubCmd;
    private StringArgument createAdsBackendNameArg;
    private SubCommand deleteAdsSubCmd;
    private StringArgument deleteAdsBackendNameArg;
    private HashSet<SubCommand> subCommands = new HashSet();
    private boolean isHidden;
    private String groupName;

    @Override
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void initializeCliGroup(DsFrameworkCliParser argParser, BooleanArgument verboseArg) throws ArgumentException {
        this.isHidden = true;
        this.groupName = "ads";
        this.argParser = argParser;
        this.createAdsSubCmd = new SubCommand(argParser, SubCommandNameEnum.CREATE_ADS.toString(), AdminMessages.INFO_ADMIN_SUBCMD_CREATE_ADS_DESCRIPTION.get());
        this.createAdsSubCmd.setHidden(true);
        this.subCommands.add(this.createAdsSubCmd);
        this.createAdsBackendNameArg = new StringArgument("backendName", Character.valueOf('b'), "backendName", false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_BACKENDNAME_DESCRIPTION.get());
        this.createAdsSubCmd.addArgument(this.createAdsBackendNameArg);
        this.deleteAdsSubCmd = new SubCommand(argParser, SubCommandNameEnum.DELETE_ADS.toString(), AdminMessages.INFO_ADMIN_SUBCMD_DELETE_ADS_DESCRIPTION.get());
        this.deleteAdsSubCmd.setHidden(true);
        this.subCommands.add(this.deleteAdsSubCmd);
        this.deleteAdsBackendNameArg = new StringArgument("backendName", Character.valueOf('b'), "backendName", true, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_BACKENDNAME_DESCRIPTION.get());
        this.deleteAdsSubCmd.addArgument(this.deleteAdsBackendNameArg);
    }

    @Override
    public boolean isSubCommand(SubCommand subCmd) {
        return SubCommandNameEnum.isSubCommand(subCmd.getName());
    }

    @Override
    public DsFrameworkCliReturnCode performSubCommand(SubCommand subCmd, OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        ADSContext adsCtx = null;
        InitialContext ctx = null;
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
        try {
            if (subCmd.getName().equals(this.createAdsSubCmd.getName())) {
                String backendName = null;
                if (this.createAdsBackendNameArg.isPresent()) {
                    backendName = this.createAdsBackendNameArg.getValue();
                }
                if ((ctx = this.argParser.getContext(outStream, errStream)) == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                adsCtx.createAdminData(backendName);
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
            } else if (subCmd.getName().equals(this.deleteAdsSubCmd.getName())) {
                String backendName = this.deleteAdsBackendNameArg.getValue();
                ADSContextHelper helper = new ADSContextHelper();
                ctx = this.argParser.getContext(outStream, errStream);
                if (ctx == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                helper.removeAdministrationSuffix(adsCtx.getDirContext(), backendName);
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
            } else {
                returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            }
        }
        catch (ADSContextException e) {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException x) {
                    // empty catch block
                }
            }
            throw e;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException x) {
                // empty catch block
            }
        }
        return returnCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubCommandNameEnum {
        CREATE_ADS("create-ads"),
        DELETE_ADS("delete-ads");

        private final String name;
        private static final List<String> nameToSubCmdName;

        private SubCommandNameEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isSubCommand(String name) {
            return nameToSubCmdName.contains(name);
        }

        static {
            nameToSubCmdName = new ArrayList<String>();
            for (SubCommandNameEnum subCmd : SubCommandNameEnum.values()) {
                nameToSubCmdName.add(subCmd.toString());
            }
        }
    }
}

