/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DefinitionResolver;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.Reference;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.client.ldap.LDAPConnection;
import org.opends.server.admin.client.ldap.LDAPManagedObject;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.client.ldap.LDAPNameBuilder;
import org.opends.server.admin.client.spi.Driver;
import org.opends.server.admin.client.spi.PropertySet;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.RootCfgDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LDAPDriver
extends Driver {
    private final LDAPConnection connection;
    private final LDAPManagementContext context;
    private final LDAPProfile profile;

    public LDAPDriver(LDAPManagementContext context, LDAPConnection connection, LDAPProfile profile) {
        this.context = context;
        this.connection = connection;
        this.profile = profile;
    }

    @Override
    public void close() {
        this.connection.unbind();
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getManagedObject(ManagedObjectPath<C, S> path) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        if (!this.managedObjectExists(path)) {
            throw new ManagedObjectNotFoundException();
        }
        try {
            LdapName dn = LDAPNameBuilder.create(path, this.profile);
            AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
            ManagedObjectDefinition<C, S> mod = this.getEntryDefinition(d, dn);
            ArrayList<String> attrIds = new ArrayList<String>();
            for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
                String attrId = this.profile.getAttributeName(mod, pd);
                attrIds.add(attrId);
            }
            Attributes attributes = this.connection.readEntry(dn, attrIds);
            LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
            PropertySet newProperties = new PropertySet();
            for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
                String attrID = this.profile.getAttributeName(mod, pd);
                Attribute attribute = attributes.get(attrID);
                try {
                    this.decodeProperty(newProperties, path, pd, attribute);
                }
                catch (PropertyException e) {
                    exceptions.add(e);
                }
            }
            ManagedObject<C> mo = this.createExistingManagedObject(mod, path, newProperties);
            if (exceptions.isEmpty()) {
                return mo;
            }
            throw new ManagedObjectDecodingException(mo, exceptions);
        }
        catch (NameNotFoundException e) {
            throw new ManagedObjectNotFoundException();
        }
        catch (NoPermissionException e) {
            throw new AuthorizationException(e);
        }
        catch (NamingException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration, PD> SortedSet<PD> getPropertyValues(ManagedObjectPath<C, S> path, PropertyDefinition<PD> pd) throws IllegalArgumentException, DefinitionDecodingException, AuthorizationException, ManagedObjectNotFoundException, CommunicationException, PropertyException {
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        PropertyDefinition<?> tmp = d.getPropertyDefinition(pd.getName());
        if (tmp != pd) {
            throw new IllegalArgumentException("The property " + pd.getName() + " is not associated with a " + d.getName());
        }
        if (!this.managedObjectExists(path)) {
            throw new ManagedObjectNotFoundException();
        }
        try {
            LdapName dn = LDAPNameBuilder.create(path, this.profile);
            ManagedObjectDefinition<C, S> mod = this.getEntryDefinition(d, dn);
            pd = mod.getPropertyDefinition(pd.getName());
            String attrID = this.profile.getAttributeName(mod, pd);
            Attributes attributes = this.connection.readEntry(dn, Collections.singleton(attrID));
            Attribute attribute = attributes.get(attrID);
            TreeSet<PD> values = new TreeSet<PD>(pd);
            if (attribute != null) {
                NamingEnumeration<?> ldapValues = attribute.getAll();
                while (ldapValues.hasMore()) {
                    Object obj = ldapValues.next();
                    if (obj == null) continue;
                    Object value = ValueDecoder.decode(pd, obj);
                    values.add(value);
                }
            }
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                throw new PropertyIsSingleValuedException(pd);
            }
            if (values.isEmpty() && pd.hasOption(PropertyOption.MANDATORY)) {
                throw new PropertyIsMandatoryException(pd);
            }
            if (values.isEmpty()) {
                values.addAll(this.findDefaultValues(path.asSubType(mod), pd, false));
            }
            return values;
        }
        catch (NameNotFoundException e) {
            throw new ManagedObjectNotFoundException();
        }
        catch (NoPermissionException e) {
            throw new AuthorizationException(e);
        }
        catch (NamingException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public ManagedObject<RootCfgClient> getRootConfigurationManagedObject() {
        return new LDAPManagedObject<RootCfgClient>(this, RootCfgDefn.getInstance(), ManagedObjectPath.emptyPath(), new PropertySet(), true, null);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws IllegalArgumentException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(parent, rd);
        if (!this.managedObjectExists(parent)) {
            throw new ManagedObjectNotFoundException();
        }
        LdapName dn = LDAPNameBuilder.create(parent, rd, this.profile);
        StringBuilder builder = new StringBuilder();
        builder.append("(objectclass=");
        builder.append(this.profile.getObjectClass(d));
        builder.append(')');
        String filter = builder.toString();
        ArrayList<String> children = new ArrayList<String>();
        try {
            for (LdapName child : this.connection.listEntries(dn, filter)) {
                children.add(child.getRdn(child.size() - 1).getValue().toString());
            }
        }
        catch (NameNotFoundException e) {
        }
        catch (NamingException e) {
            this.adaptNamingException(e);
        }
        return children.toArray(new String[children.size()]);
    }

    @Override
    public boolean managedObjectExists(ManagedObjectPath<?, ?> path) throws ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        if (path.isEmpty()) {
            return true;
        }
        ManagedObjectPath<?, ?> parent = path.parent();
        LdapName dn = LDAPNameBuilder.create(parent, this.profile);
        if (!this.entryExists(dn)) {
            throw new ManagedObjectNotFoundException();
        }
        dn = LDAPNameBuilder.create(path, this.profile);
        return this.entryExists(dn);
    }

    @Override
    protected <C extends ConfigurationClient, S extends Configuration> void deleteManagedObject(ManagedObjectPath<C, S> path) throws OperationRejectedException, AuthorizationException, CommunicationException {
        LdapName dn = LDAPNameBuilder.create(path, this.profile);
        try {
            this.connection.deleteSubtree(dn);
        }
        catch (OperationNotSupportedException e) {
            AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
            if (e.getMessage() == null) {
                throw new OperationRejectedException(OperationRejectedException.OperationType.DELETE, d.getUserFriendlyName());
            }
            Message m = Message.raw("%s", e.getMessage());
            throw new OperationRejectedException(OperationRejectedException.OperationType.DELETE, d.getUserFriendlyName(), m);
        }
        catch (NamingException e) {
            this.adaptNamingException(e);
        }
    }

    @Override
    protected LDAPManagementContext getManagementContext() {
        return this.context;
    }

    void adaptNamingException(NamingException ne) throws CommunicationException, AuthorizationException {
        try {
            throw ne;
        }
        catch (javax.naming.CommunicationException e) {
            throw new CommunicationException(e);
        }
        catch (ServiceUnavailableException e) {
            throw new CommunicationException(e);
        }
        catch (NoPermissionException e) {
            throw new AuthorizationException(e);
        }
        catch (NamingException e) {
            throw new CommunicationException(e);
        }
    }

    boolean entryExists(LdapName dn) throws CommunicationException, AuthorizationException {
        try {
            return this.connection.entryExists(dn);
        }
        catch (NamingException e) {
            this.adaptNamingException(e);
            return false;
        }
    }

    LDAPConnection getLDAPConnection() {
        return this.connection;
    }

    LDAPProfile getLDAPProfile() {
        return this.profile;
    }

    private <M extends ConfigurationClient, N extends Configuration> ManagedObject<M> createExistingManagedObject(ManagedObjectDefinition<M, N> d, ManagedObjectPath<? super M, ? super N> p, PropertySet properties) {
        RelationDefinition<? super M, ? super N> rd = p.getRelationDefinition();
        PropertyDefinition<?> pd = null;
        if (rd instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition ird = (InstantiableRelationDefinition)rd;
            pd = ird.getNamingPropertyDefinition();
        }
        return new LDAPManagedObject<M>(this, d, p.asSubType(d), properties, true, pd);
    }

    private <PD> void decodeProperty(PropertySet newProperties, ManagedObjectPath<?, ?> p, PropertyDefinition<PD> pd, Attribute attribute) throws PropertyException, NamingException {
        Collection<Object> defaultValues;
        PropertyException exception = null;
        TreeSet<PD> activeValues = new TreeSet<PD>(pd);
        if (attribute != null) {
            NamingEnumeration<?> ldapValues = attribute.getAll();
            while (ldapValues.hasMore()) {
                Object obj = ldapValues.next();
                if (obj == null) continue;
                PD value = ValueDecoder.decode(pd, obj);
                activeValues.add(value);
            }
        }
        if (activeValues.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
            exception = new PropertyIsSingleValuedException(pd);
            Object value = activeValues.first();
            activeValues.clear();
            activeValues.add(value);
        }
        if (activeValues.isEmpty() && pd.hasOption(PropertyOption.MANDATORY) && exception == null) {
            exception = new PropertyIsMandatoryException(pd);
        }
        try {
            defaultValues = this.findDefaultValues(p, pd, false);
        }
        catch (DefaultBehaviorException e) {
            defaultValues = Collections.emptySet();
            exception = e;
        }
        newProperties.addProperty(pd, defaultValues, activeValues);
        if (exception != null) {
            throw exception;
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> ManagedObjectDefinition<? extends C, ? extends S> getEntryDefinition(AbstractManagedObjectDefinition<C, S> d, LdapName dn) throws NamingException, DefinitionDecodingException {
        Attributes attributes = this.connection.readEntry(dn, Collections.singleton("objectclass"));
        Attribute oc = attributes.get("objectclass");
        if (oc == null) {
            throw new DefinitionDecodingException(d, DefinitionDecodingException.Reason.NO_TYPE_INFORMATION);
        }
        final HashSet<String> objectClasses = new HashSet<String>();
        NamingEnumeration<?> values = oc.getAll();
        while (values.hasMore()) {
            Object value = values.next();
            if (value == null) continue;
            objectClasses.add(value.toString().toLowerCase().trim());
        }
        if (objectClasses.isEmpty()) {
            throw new DefinitionDecodingException(d, DefinitionDecodingException.Reason.NO_TYPE_INFORMATION);
        }
        DefinitionResolver resolver = new DefinitionResolver(){

            @Override
            public boolean matches(AbstractManagedObjectDefinition<?, ?> d) {
                String objectClass = LDAPDriver.this.profile.getObjectClass(d);
                return objectClasses.contains(objectClass);
            }
        };
        return d.resolveManagedObjectDefinition(resolver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueDecoder
    extends PropertyDefinitionVisitor<Object, String> {
        public static <PD> PD decode(PropertyDefinition<PD> pd, Object value) throws IllegalPropertyValueStringException {
            String s = String.valueOf(value);
            return pd.castValue(pd.accept(new ValueDecoder(), s));
        }

        private ValueDecoder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Object visitAggregation(AggregationPropertyDefinition<C, S> d, String p) {
            try {
                Reference<C, S> reference = Reference.parseDN(d.getParentPath(), d.getRelationDefinition(), p);
                return reference.getName();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalPropertyValueStringException(d, p);
            }
        }

        @Override
        public <T> Object visitUnknown(PropertyDefinition<T> d, String p) throws UnknownPropertyDefinitionException {
            return d.decodeValue(p);
        }
    }
}

