/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.DebugTargetCfgClient;
import org.opends.server.admin.std.server.DebugTargetCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugTargetCfgDefn
extends ManagedObjectDefinition<DebugTargetCfgClient, DebugTargetCfg> {
    private static final DebugTargetCfgDefn INSTANCE = new DebugTargetCfgDefn();
    private static final EnumPropertyDefinition<DebugCategory> PD_DEBUG_CATEGORY;
    private static final EnumPropertyDefinition<DebugLevel> PD_DEBUG_LEVEL;
    private static final StringPropertyDefinition PD_DEBUG_SCOPE;
    private static final BooleanPropertyDefinition PD_INCLUDE_THROWABLE_CAUSE;
    private static final BooleanPropertyDefinition PD_OMIT_METHOD_ENTRY_ARGUMENTS;
    private static final BooleanPropertyDefinition PD_OMIT_METHOD_RETURN_VALUE;
    private static final IntegerPropertyDefinition PD_THROWABLE_STACK_FRAMES;

    public static DebugTargetCfgDefn getInstance() {
        return INSTANCE;
    }

    private DebugTargetCfgDefn() {
        super("debug-target", TopCfgDefn.getInstance());
    }

    @Override
    public DebugTargetCfgClient createClientConfiguration(ManagedObject<? extends DebugTargetCfgClient> impl) {
        return new DebugTargetCfgClientImpl(impl);
    }

    @Override
    public DebugTargetCfg createServerConfiguration(ServerManagedObject<? extends DebugTargetCfg> impl) {
        return new DebugTargetCfgServerImpl(impl);
    }

    @Override
    public Class<DebugTargetCfg> getServerConfigurationClass() {
        return DebugTargetCfg.class;
    }

    public EnumPropertyDefinition<DebugCategory> getDebugCategoryPropertyDefinition() {
        return PD_DEBUG_CATEGORY;
    }

    public EnumPropertyDefinition<DebugLevel> getDebugLevelPropertyDefinition() {
        return PD_DEBUG_LEVEL;
    }

    public StringPropertyDefinition getDebugScopePropertyDefinition() {
        return PD_DEBUG_SCOPE;
    }

    public BooleanPropertyDefinition getIncludeThrowableCausePropertyDefinition() {
        return PD_INCLUDE_THROWABLE_CAUSE;
    }

    public BooleanPropertyDefinition getOmitMethodEntryArgumentsPropertyDefinition() {
        return PD_OMIT_METHOD_ENTRY_ARGUMENTS;
    }

    public BooleanPropertyDefinition getOmitMethodReturnValuePropertyDefinition() {
        return PD_OMIT_METHOD_RETURN_VALUE;
    }

    public IntegerPropertyDefinition getThrowableStackFramesPropertyDefinition() {
        return PD_THROWABLE_STACK_FRAMES;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = EnumPropertyDefinition.createBuilder(INSTANCE, "debug-category");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "debug-category"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "debug-category"));
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(DebugCategory.class);
        PD_DEBUG_CATEGORY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEBUG_CATEGORY);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "debug-level");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "debug-level"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(DebugLevel.class);
        PD_DEBUG_LEVEL = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEBUG_LEVEL);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "debug-scope");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "debug-scope"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^([A-Za-z][A-Za-z0-9_]*\\.)*[A-Za-z][A-Za-z0-9_]*(#[A-Za-z][A-Za-z0-9_]*)?$", "STRING");
        PD_DEBUG_SCOPE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEBUG_SCOPE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "include-throwable-cause");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "include-throwable-cause"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_INCLUDE_THROWABLE_CAUSE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INCLUDE_THROWABLE_CAUSE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "omit-method-entry-arguments");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "omit-method-entry-arguments"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_OMIT_METHOD_ENTRY_ARGUMENTS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_OMIT_METHOD_ENTRY_ARGUMENTS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "omit-method-return-value");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "omit-method-return-value"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_OMIT_METHOD_RETURN_VALUE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_OMIT_METHOD_RETURN_VALUE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "throwable-stack-frames");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "throwable-stack-frames"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_THROWABLE_STACK_FRAMES = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_THROWABLE_STACK_FRAMES);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DebugTargetCfgServerImpl
    implements DebugTargetCfg {
        private ServerManagedObject<? extends DebugTargetCfg> impl;
        private final SortedSet<DebugCategory> pDebugCategory;
        private final DebugLevel pDebugLevel;
        private final String pDebugScope;
        private final boolean pIncludeThrowableCause;
        private final boolean pOmitMethodEntryArguments;
        private final boolean pOmitMethodReturnValue;
        private final int pThrowableStackFrames;

        private DebugTargetCfgServerImpl(ServerManagedObject<? extends DebugTargetCfg> impl) {
            this.impl = impl;
            this.pDebugCategory = impl.getPropertyValues(INSTANCE.getDebugCategoryPropertyDefinition());
            this.pDebugLevel = impl.getPropertyValue(INSTANCE.getDebugLevelPropertyDefinition());
            this.pDebugScope = impl.getPropertyValue(INSTANCE.getDebugScopePropertyDefinition());
            this.pIncludeThrowableCause = impl.getPropertyValue(INSTANCE.getIncludeThrowableCausePropertyDefinition());
            this.pOmitMethodEntryArguments = impl.getPropertyValue(INSTANCE.getOmitMethodEntryArgumentsPropertyDefinition());
            this.pOmitMethodReturnValue = impl.getPropertyValue(INSTANCE.getOmitMethodReturnValuePropertyDefinition());
            this.pThrowableStackFrames = impl.getPropertyValue(INSTANCE.getThrowableStackFramesPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<DebugTargetCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<DebugTargetCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DebugCategory> getDebugCategory() {
            return this.pDebugCategory;
        }

        @Override
        public DebugLevel getDebugLevel() {
            return this.pDebugLevel;
        }

        @Override
        public String getDebugScope() {
            return this.pDebugScope;
        }

        @Override
        public boolean isIncludeThrowableCause() {
            return this.pIncludeThrowableCause;
        }

        @Override
        public boolean isOmitMethodEntryArguments() {
            return this.pOmitMethodEntryArguments;
        }

        @Override
        public boolean isOmitMethodReturnValue() {
            return this.pOmitMethodReturnValue;
        }

        @Override
        public int getThrowableStackFrames() {
            return this.pThrowableStackFrames;
        }

        @Override
        public Class<? extends DebugTargetCfg> configurationClass() {
            return DebugTargetCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DebugTargetCfgClientImpl
    implements DebugTargetCfgClient {
        private ManagedObject<? extends DebugTargetCfgClient> impl;

        private DebugTargetCfgClientImpl(ManagedObject<? extends DebugTargetCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DebugCategory> getDebugCategory() {
            return this.impl.getPropertyValues(INSTANCE.getDebugCategoryPropertyDefinition());
        }

        @Override
        public void setDebugCategory(Collection<DebugCategory> values) {
            this.impl.setPropertyValues(INSTANCE.getDebugCategoryPropertyDefinition(), values);
        }

        @Override
        public DebugLevel getDebugLevel() {
            return this.impl.getPropertyValue(INSTANCE.getDebugLevelPropertyDefinition());
        }

        @Override
        public void setDebugLevel(DebugLevel value) {
            this.impl.setPropertyValue(INSTANCE.getDebugLevelPropertyDefinition(), value);
        }

        @Override
        public String getDebugScope() {
            return this.impl.getPropertyValue(INSTANCE.getDebugScopePropertyDefinition());
        }

        @Override
        public void setDebugScope(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getDebugScopePropertyDefinition(), value);
        }

        @Override
        public boolean isIncludeThrowableCause() {
            return this.impl.getPropertyValue(INSTANCE.getIncludeThrowableCausePropertyDefinition());
        }

        @Override
        public void setIncludeThrowableCause(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIncludeThrowableCausePropertyDefinition(), value);
        }

        @Override
        public boolean isOmitMethodEntryArguments() {
            return this.impl.getPropertyValue(INSTANCE.getOmitMethodEntryArgumentsPropertyDefinition());
        }

        @Override
        public void setOmitMethodEntryArguments(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getOmitMethodEntryArgumentsPropertyDefinition(), value);
        }

        @Override
        public boolean isOmitMethodReturnValue() {
            return this.impl.getPropertyValue(INSTANCE.getOmitMethodReturnValuePropertyDefinition());
        }

        @Override
        public void setOmitMethodReturnValue(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getOmitMethodReturnValuePropertyDefinition(), value);
        }

        @Override
        public int getThrowableStackFrames() {
            return this.impl.getPropertyValue(INSTANCE.getThrowableStackFramesPropertyDefinition());
        }

        @Override
        public void setThrowableStackFrames(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getThrowableStackFramesPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends DebugTargetCfgClient, ? extends DebugTargetCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugLevel {
        ALL("all"),
        DISABLED("disabled"),
        ERROR("error"),
        INFO("info"),
        VERBOSE("verbose"),
        WARNING("warning");

        private final String name;

        private DebugLevel(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugCategory {
        CAUGHT("caught"),
        CONSTRUCTOR("constructor"),
        DATA("data"),
        DATABASE_ACCESS("database-access"),
        ENTER("enter"),
        EXIT("exit"),
        MESSAGE("message"),
        PROTOCOL("protocol"),
        THROWN("thrown");

        private final String name;

        private DebugCategory(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

