/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.TrustManagerProviderCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.TrustManagerProviderCfg;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustManagerProviderConfigManager
implements ConfigurationChangeListener<TrustManagerProviderCfg>,
ConfigurationAddListener<TrustManagerProviderCfg>,
ConfigurationDeleteListener<TrustManagerProviderCfg> {
    private ConcurrentHashMap<DN, TrustManagerProvider> providers = new ConcurrentHashMap();

    public void initializeTrustManagerProviders() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addTrustManagerProviderAddListener(this);
        rootConfiguration.addTrustManagerProviderDeleteListener(this);
        for (String name : rootConfiguration.listTrustManagerProviders()) {
            TrustManagerProviderCfg providerConfig = rootConfiguration.getTrustManagerProvider(name);
            providerConfig.addChangeListener(this);
            if (!providerConfig.isEnabled()) continue;
            String className = providerConfig.getJavaClass();
            try {
                TrustManagerProvider provider = this.loadProvider(className, providerConfig, true);
                this.providers.put(providerConfig.dn(), provider);
                DirectoryServer.registerTrustManagerProvider(providerConfig.dn(), provider);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(TrustManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(TrustManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        TrustManagerProvider provider = null;
        String className = configuration.getJavaClass();
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerTrustManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(TrustManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(TrustManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServer.deregisterTrustManagerProvider(configuration.dn());
        TrustManagerProvider provider = this.providers.remove(configuration.dn());
        if (provider != null) {
            provider.finalizeTrustManagerProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TrustManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TrustManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        TrustManagerProvider existingProvider = this.providers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingProvider != null) {
                DirectoryServer.deregisterTrustManagerProvider(configuration.dn());
                TrustManagerProvider provider = this.providers.remove(configuration.dn());
                if (provider != null) {
                    provider.finalizeTrustManagerProvider();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingProvider != null) {
            if (!className.equals(existingProvider.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        TrustManagerProvider provider = null;
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerTrustManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private TrustManagerProvider loadProvider(String className, TrustManagerProviderCfg configuration, boolean initialize) throws InitializationException {
        try {
            TrustManagerProviderCfgDefn definition = TrustManagerProviderCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<TrustManagerProvider> providerClass = propertyDefinition.loadClass(className, TrustManagerProvider.class);
            TrustManagerProvider provider = providerClass.newInstance();
            if (initialize) {
                Method method = provider.getClass().getMethod("initializeTrustManagerProvider", configuration.configurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", TrustManagerProviderCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_TRUSTMANAGER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return provider;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_TRUSTMANAGER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

