/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.NetworkGroup;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowConfigManager
implements ConfigurationChangeListener<WorkflowCfg>,
ConfigurationAddListener<WorkflowCfg>,
ConfigurationDeleteListener<WorkflowCfg> {
    private ConcurrentHashMap<DN, WorkflowImpl> workflows = new ConcurrentHashMap();

    public void initializeWorkflows() throws ConfigException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addWorkflowAddListener(this);
        rootConfiguration.addWorkflowDeleteListener(this);
        for (String workflowName : rootConfiguration.listWorkflows()) {
            WorkflowCfg workflowConfiguration = rootConfiguration.getWorkflow(workflowName);
            workflowConfiguration.addChangeListener(this);
            if (!workflowConfiguration.isEnabled()) continue;
            try {
                this.createAndRegisterWorkflow(workflowConfiguration);
            }
            catch (DirectoryException de) {
                throw new ConfigException(de.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(WorkflowCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(WorkflowCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                this.createAndRegisterWorkflow(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(de.getMessageObject());
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(WorkflowCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(WorkflowCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        WorkflowImpl workflow = this.workflows.remove(configuration.dn());
        if (workflow != null) {
            workflow.deregister();
            workflow.finalizeWorkflow();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(WorkflowCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(WorkflowCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        WorkflowImpl existingWorkflow = this.workflows.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingWorkflow != null) {
                this.workflows.remove(configuration.dn());
                existingWorkflow.deregister();
                existingWorkflow.finalizeWorkflow();
            }
            return configChangeResult;
        }
        if (existingWorkflow == null) {
            try {
                this.createAndRegisterWorkflow(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(de.getMessageObject());
            }
        }
        return configChangeResult;
    }

    private void createAndRegisterWorkflow(WorkflowCfg workflowCfg) throws DirectoryException {
        String workflowId = workflowCfg.getWorkflowId();
        String rootWorkflowElementID = workflowCfg.getWorkflowElement();
        WorkflowElement rootWorkflowElement = DirectoryServer.getWorkflowElement(rootWorkflowElementID);
        DN baseDN = workflowCfg.getBaseDN();
        WorkflowImpl workflowImpl = new WorkflowImpl(workflowId, baseDN, rootWorkflowElement);
        this.workflows.put(workflowCfg.dn(), workflowImpl);
        workflowImpl.register();
        NetworkGroup.getDefaultNetworkGroup().registerWorkflow(workflowImpl);
    }
}

