/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.LinkedHashSet;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.DynamicGroupMemberList;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.MembershipException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;

public class DynamicGroupSearchThread
extends DirectoryThread
implements InternalSearchListener {
    private final DN[] baseDNs;
    private final DynamicGroupMemberList memberList;
    private int searchCounter;
    private final LDAPURL[][] memberURLs;
    private final SearchFilter[] searchFilters;

    public DynamicGroupSearchThread(DynamicGroupMemberList memberList, DN[] baseDNs, SearchFilter[] filters, LDAPURL[][] memberURLs) {
        super("Dynamic Group Search Thread " + memberList.getDynamicGroupDN());
        this.memberList = memberList;
        this.baseDNs = baseDNs;
        this.searchFilters = filters;
        this.memberURLs = memberURLs;
        this.searchCounter = 0;
    }

    public void run() {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(0);
        this.searchCounter = 0;
        while (this.searchCounter < this.baseDNs.length) {
            InternalSearchOperation searchOperation = conn.processSearch(this.baseDNs[this.searchCounter], SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, this.searchFilters[this.searchCounter], attributes, (InternalSearchListener)this);
            ResultCode resultCode = searchOperation.getResultCode();
            if (resultCode != ResultCode.SUCCESS) {
                Message message;
                if (resultCode == ResultCode.NO_SUCH_OBJECT) {
                    message = ExtensionMessages.WARN_DYNAMICGROUP_NONEXISTENT_BASE_DN.get(String.valueOf(this.baseDNs[this.searchCounter]), String.valueOf(this.memberList.getDynamicGroupDN()));
                    ErrorLogger.logError(message);
                } else {
                    message = ExtensionMessages.ERR_DYNAMICGROUP_INTERNAL_SEARCH_FAILED.get(String.valueOf(this.baseDNs[this.searchCounter]), String.valueOf(this.searchFilters[this.searchCounter]), String.valueOf(this.memberList.getDynamicGroupDN()), String.valueOf((Object)resultCode), String.valueOf(searchOperation.getErrorMessage()));
                    if (!this.memberList.addResult(new MembershipException(message, true))) {
                        this.memberList.setSearchesCompleted();
                        return;
                    }
                }
            }
            ++this.searchCounter;
        }
        this.memberList.setSearchesCompleted();
    }

    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
        for (LDAPURL url : this.memberURLs[this.searchCounter]) {
            if (!url.matchesEntry(searchEntry)) continue;
            if (!this.memberList.addResult(searchEntry)) {
                Message message = ExtensionMessages.ERR_DYNAMICGROUP_CANNOT_RETURN_ENTRY.get(String.valueOf(searchEntry.getDN()), String.valueOf(this.memberList.getDynamicGroupDN()));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            return;
        }
    }

    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) {
    }
}

