/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.IdentityMapperCfg;
import org.opends.server.admin.std.server.RegularExpressionIdentityMapperCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularExpressionIdentityMapper
extends IdentityMapper<RegularExpressionIdentityMapperCfg>
implements ConfigurationChangeListener<RegularExpressionIdentityMapperCfg> {
    private AttributeType[] attributeTypes;
    private DN configEntryDN;
    private LinkedHashSet<String> requestedAttributes;
    private Pattern matchPattern;
    private RegularExpressionIdentityMapperCfg currentConfig;
    private String replacePattern;

    @Override
    public void initializeIdentityMapper(RegularExpressionIdentityMapperCfg configuration) throws ConfigException, InitializationException {
        configuration.addRegularExpressionChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = this.currentConfig.dn();
        try {
            this.matchPattern = Pattern.compile(this.currentConfig.getMatchPattern());
        }
        catch (PatternSyntaxException pse) {
            Message message = ExtensionMessages.ERR_REGEXMAP_INVALID_MATCH_PATTERN.get(this.currentConfig.getMatchPattern(), pse.getMessage());
            throw new ConfigException(message, (Throwable)pse);
        }
        this.replacePattern = this.currentConfig.getReplacePattern();
        if (this.replacePattern == null) {
            this.replacePattern = "";
        }
        this.attributeTypes = this.currentConfig.getMatchAttribute().toArray(new AttributeType[0]);
        Set<DN> cfgBaseDNs = configuration.getMatchBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (AttributeType t : this.attributeTypes) {
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
                throw new ConfigException(ExtensionMessages.ERR_REGEXMAP_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID()));
            }
        }
        this.requestedAttributes = new LinkedHashSet(2);
        this.requestedAttributes.add("*");
        this.requestedAttributes.add("+");
    }

    @Override
    public void finalizeIdentityMapper() {
        this.currentConfig.removeRegularExpressionChangeListener(this);
    }

    @Override
    public Entry getEntryForID(String id) throws DirectoryException {
        SearchFilter filter;
        RegularExpressionIdentityMapperCfg config = this.currentConfig;
        AttributeType[] attributeTypes = this.attributeTypes;
        Matcher matcher = this.matchPattern.matcher(id);
        String processedID = matcher.replaceAll(this.replacePattern);
        if (attributeTypes.length == 1) {
            AttributeValue value = new AttributeValue(attributeTypes[0], processedID);
            filter = SearchFilter.createEqualityFilter(attributeTypes[0], value);
        } else {
            ArrayList<SearchFilter> filterComps = new ArrayList<SearchFilter>(attributeTypes.length);
            for (AttributeType t : attributeTypes) {
                AttributeValue value = new AttributeValue(t, processedID);
                filterComps.add(SearchFilter.createEqualityFilter(t, value));
            }
            filter = SearchFilter.createORFilter(filterComps);
        }
        Set<DN> baseDNs = config.getMatchBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SearchResultEntry matchingEntry = null;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        for (DN baseDN : baseDNs) {
            LinkedList<SearchResultEntry> searchEntries;
            InternalSearchOperation internalSearch = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 10, false, filter, this.requestedAttributes);
            switch (internalSearch.getResultCode()) {
                case SUCCESS: {
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case SIZE_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_REGEXMAP_MULTIPLE_MATCHING_ENTRIES.get(String.valueOf(processedID));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                case TIME_LIMIT_EXCEEDED: 
                case ADMIN_LIMIT_EXCEEDED: {
                    Message message = ExtensionMessages.ERR_REGEXMAP_INEFFICIENT_SEARCH.get(String.valueOf(processedID), String.valueOf(internalSearch.getErrorMessage()));
                    throw new DirectoryException(internalSearch.getResultCode(), message);
                }
                default: {
                    Message message = ExtensionMessages.ERR_REGEXMAP_SEARCH_FAILED.get(String.valueOf(processedID), String.valueOf(internalSearch.getErrorMessage()));
                    throw new DirectoryException(internalSearch.getResultCode(), message);
                }
            }
            if ((searchEntries = internalSearch.getSearchEntries()) == null || searchEntries.isEmpty()) continue;
            if (matchingEntry == null) {
                Iterator iterator = searchEntries.iterator();
                matchingEntry = (SearchResultEntry)iterator.next();
                if (!iterator.hasNext()) continue;
                Message message = ExtensionMessages.ERR_REGEXMAP_MULTIPLE_MATCHING_ENTRIES.get(String.valueOf(processedID));
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            Message message = ExtensionMessages.ERR_REGEXMAP_MULTIPLE_MATCHING_ENTRIES.get(String.valueOf(processedID));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (matchingEntry == null) {
            return null;
        }
        return matchingEntry;
    }

    @Override
    public boolean isConfigurationAcceptable(IdentityMapperCfg configuration, List<Message> unacceptableReasons) {
        RegularExpressionIdentityMapperCfg config = (RegularExpressionIdentityMapperCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(RegularExpressionIdentityMapperCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        Set<DN> cfgBaseDNs = configuration.getMatchBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (AttributeType t : configuration.getMatchAttribute()) {
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
                unacceptableReasons.add(ExtensionMessages.ERR_REGEXMAP_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID()));
                configAcceptable = false;
            }
        }
        try {
            Pattern.compile(configuration.getMatchPattern());
        }
        catch (PatternSyntaxException pse) {
            Message message = ExtensionMessages.ERR_REGEXMAP_INVALID_MATCH_PATTERN.get(configuration.getMatchPattern(), pse.getMessage());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(RegularExpressionIdentityMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        Pattern newMatchPattern = null;
        try {
            newMatchPattern = Pattern.compile(configuration.getMatchPattern());
        }
        catch (PatternSyntaxException pse) {
            Message message = ExtensionMessages.ERR_REGEXMAP_INVALID_MATCH_PATTERN.get(configuration.getMatchPattern(), pse.getMessage());
            messages.add(message);
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
        }
        String newReplacePattern = configuration.getReplacePattern();
        if (newReplacePattern == null) {
            newReplacePattern = "";
        }
        AttributeType[] newAttributeTypes = configuration.getMatchAttribute().toArray(new AttributeType[0]);
        if (resultCode == ResultCode.SUCCESS) {
            this.attributeTypes = newAttributeTypes;
            this.currentConfig = configuration;
            this.matchPattern = newMatchPattern;
            this.replacePattern = newReplacePattern;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

