/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.NullConnectionSecurityProvider;
import org.opends.server.extensions.NullKeyManagerProvider;
import org.opends.server.extensions.NullTrustManagerProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.StaticUtils;

public class TLSConnectionSecurityProvider
extends ConnectionSecurityProvider {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String SSL_CONTEXT_INSTANCE_NAME = "TLS";
    private ByteBuffer clearInBuffer;
    private ByteBuffer clearOutBuffer;
    private ByteBuffer sslInBuffer;
    private ByteBuffer sslOutBuffer;
    private ClientConnection clientConnection;
    private int clearBufferSize;
    private int sslBufferSize;
    private SocketChannel socketChannel;
    private SSLClientAuthPolicy sslClientAuthPolicy;
    private SSLContext sslContext;
    private SSLEngine sslEngine;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public TLSConnectionSecurityProvider() {
    }

    private TLSConnectionSecurityProvider(ClientConnection clientConnection, SocketChannel socketChannel, TLSConnectionSecurityProvider parentProvider) throws DirectoryException {
        TrustManagerProvider trustManagerProvider;
        this.clientConnection = clientConnection;
        this.socketChannel = socketChannel;
        Socket socket = socketChannel.socket();
        InetAddress inetAddress = socketChannel.socket().getInetAddress();
        KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider(clientConnection.getKeyManagerProviderDN());
        if (keyManagerProvider == null) {
            keyManagerProvider = new NullKeyManagerProvider();
        }
        if ((trustManagerProvider = DirectoryServer.getTrustManagerProvider(clientConnection.getTrustManagerProviderDN())) == null) {
            trustManagerProvider = new NullTrustManagerProvider();
        }
        try {
            this.sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE_NAME);
            String alias = clientConnection.getCertificateAlias();
            if (alias == null) {
                this.sslContext.init(keyManagerProvider.getKeyManagers(), trustManagerProvider.getTrustManagers(), null);
            } else {
                this.sslContext.init(SelectableCertificateKeyManager.wrap(keyManagerProvider.getKeyManagers(), alias), trustManagerProvider.getTrustManagers(), null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        this.sslEngine = this.sslContext.createSSLEngine(inetAddress.getHostName(), socket.getPort());
        this.sslEngine.setUseClientMode(false);
        this.enabledProtocols = parentProvider.enabledProtocols;
        if (this.enabledProtocols != null) {
            this.sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        this.enabledCipherSuites = parentProvider.enabledCipherSuites;
        if (this.enabledCipherSuites != null) {
            this.sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        this.sslClientAuthPolicy = parentProvider.sslClientAuthPolicy;
        if (this.sslClientAuthPolicy == null) {
            this.sslClientAuthPolicy = SSLClientAuthPolicy.OPTIONAL;
        }
        switch (this.sslClientAuthPolicy) {
            case REQUIRED: {
                this.sslEngine.setWantClientAuth(true);
                this.sslEngine.setNeedClientAuth(true);
                break;
            }
            case DISABLED: {
                this.sslEngine.setNeedClientAuth(false);
                this.sslEngine.setWantClientAuth(false);
                break;
            }
            default: {
                this.sslEngine.setNeedClientAuth(false);
                this.sslEngine.setWantClientAuth(true);
            }
        }
        SSLSession sslSession = this.sslEngine.getSession();
        this.clearBufferSize = sslSession.getApplicationBufferSize();
        this.clearInBuffer = ByteBuffer.allocate(this.clearBufferSize);
        this.clearOutBuffer = ByteBuffer.allocate(this.clearBufferSize);
        this.sslBufferSize = sslSession.getPacketBufferSize();
        this.sslInBuffer = ByteBuffer.allocate(this.sslBufferSize);
        this.sslOutBuffer = ByteBuffer.allocate(this.sslBufferSize);
    }

    public void initializeConnectionSecurityProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        this.clientConnection = null;
        this.socketChannel = null;
        this.clearInBuffer = null;
        this.clearOutBuffer = null;
        this.sslInBuffer = null;
        this.sslOutBuffer = null;
        this.clearBufferSize = -1;
        this.sslBufferSize = -1;
        this.sslEngine = null;
        this.enabledProtocols = null;
        this.enabledCipherSuites = null;
        this.sslClientAuthPolicy = SSLClientAuthPolicy.OPTIONAL;
    }

    public void finalizeConnectionSecurityProvider() {
    }

    public String getSecurityMechanismName() {
        return SSL_CONTEXT_INSTANCE_NAME;
    }

    public boolean isSecure() {
        return true;
    }

    public ConnectionSecurityProvider newInstance(ClientConnection clientConnection, SocketChannel socketChannel) throws DirectoryException {
        return new TLSConnectionSecurityProvider(clientConnection, socketChannel, this);
    }

    public void disconnect(boolean connectionValid) {
        block13: {
            if (connectionValid) {
                try {
                    this.sslEngine.closeInbound();
                    this.sslEngine.closeOutbound();
                    block8: while (true) {
                        switch (this.sslEngine.getHandshakeStatus()) {
                            case FINISHED: 
                            case NOT_HANDSHAKING: {
                                return;
                            }
                            case NEED_TASK: {
                                Runnable task = this.sslEngine.getDelegatedTask();
                                task.run();
                                break;
                            }
                            case NEED_WRAP: {
                                this.clearOutBuffer.clear();
                                this.sslOutBuffer.clear();
                                this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                                this.sslOutBuffer.flip();
                                while (this.sslOutBuffer.hasRemaining()) {
                                    this.socketChannel.write(this.sslOutBuffer);
                                }
                                continue block8;
                            }
                            case NEED_UNWRAP: {
                                if (this.sslInBuffer.hasRemaining()) {
                                    this.clearInBuffer.clear();
                                    this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                                    this.clearInBuffer.flip();
                                    break;
                                }
                                this.sslInBuffer.clear();
                                this.clearInBuffer.clear();
                                int bytesRead = this.socketChannel.read(this.sslInBuffer);
                                if (bytesRead <= 0) {
                                    return;
                                }
                                this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                                this.clearInBuffer.flip();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block13;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    public int getClearBufferSize() {
        return this.clearBufferSize;
    }

    public int getEncodedBufferSize() {
        return this.sslBufferSize;
    }

    /*
     * Unable to fully structure code
     */
    public boolean readData() {
        try {
            block15: while (true) {
                this.sslInBuffer.clear();
                bytesRead = this.socketChannel.read(this.sslInBuffer);
                this.sslInBuffer.flip();
                if (bytesRead < 0) {
                    this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                }
                block16: while (true) {
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this.sslEngine.getHandshakeStatus().ordinal()]) {
                        case 3: {
                            task = this.sslEngine.getDelegatedTask();
                            task.run();
                            continue block16;
                        }
                        case 4: {
                            this.clearOutBuffer.clear();
                            this.sslOutBuffer.clear();
                            this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                            this.sslOutBuffer.flip();
                            do {
                                if (this.sslOutBuffer.hasRemaining()) ** break;
                                continue block16;
                            } while ((bytesWritten = this.socketChannel.write(this.sslOutBuffer)) >= 0);
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                            return false;
                        }
                    }
                    break;
                }
                if (bytesRead == 0) {
                    return true;
                }
                do {
                    if (!this.sslInBuffer.hasRemaining()) continue block15;
                    this.clearInBuffer.clear();
                    unwrapResult = this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                    this.clearInBuffer.flip();
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[unwrapResult.getStatus().ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                            return false;
                        }
                        default: {
                            this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_UNEXPECTED_UNWRAP_STATUS.get(String.valueOf((Object)unwrapResult.getStatus())));
                            return false;
                        }
                    }
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[unwrapResult.getHandshakeStatus().ordinal()]) {
                        case 3: {
                            task = this.sslEngine.getDelegatedTask();
                            task.run();
                            break;
                        }
                        case 4: {
                            this.clearOutBuffer.clear();
                            this.sslOutBuffer.clear();
                            this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                            this.sslOutBuffer.flip();
                            while (this.sslOutBuffer.hasRemaining()) {
                                bytesWritten = this.socketChannel.write(this.sslOutBuffer);
                                if (bytesWritten >= 0) continue;
                                this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                                return false;
                            }
                            break block9;
                        }
                    }
                } while (this.clientConnection.processDataRead(this.clearInBuffer));
                break;
            }
            return false;
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TLSConnectionSecurityProvider.TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TLSConnectionSecurityProvider.TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_READ_ERROR.get(StaticUtils.getExceptionMessage(e)));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeData(ByteBuffer clearData) {
        int originalPosition = clearData.position();
        int originalLimit = clearData.limit();
        int length = originalLimit - originalPosition;
        try {
            if (length > this.clearBufferSize) {
                int pos = originalPosition;
                int lim = originalPosition + this.clearBufferSize;
                while (pos < originalLimit) {
                    clearData.position(pos);
                    clearData.limit(lim);
                    if (!this.writeInternal(clearData)) {
                        boolean bl = false;
                        return bl;
                    }
                    pos = lim;
                    lim = Math.min(originalLimit, pos + this.clearBufferSize);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = this.writeInternal(clearData);
            return bl;
        }
        finally {
            clearData.position(originalPosition);
            clearData.limit(originalLimit);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeInternal(ByteBuffer clearData) {
        try {
            block17: while (true) {
                switch (this.sslEngine.getHandshakeStatus()) {
                    case NEED_TASK: {
                        Runnable task = this.sslEngine.getDelegatedTask();
                        task.run();
                        continue block17;
                    }
                    case NEED_WRAP: {
                        int bytesWritten;
                        this.clearOutBuffer.clear();
                        this.sslOutBuffer.clear();
                        this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                        this.sslOutBuffer.flip();
                        do {
                            if (!this.sslOutBuffer.hasRemaining()) continue block17;
                            bytesWritten = this.socketChannel.write(this.sslOutBuffer);
                            if (bytesWritten >= 0) continue;
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                            return false;
                        } while (bytesWritten != 0);
                        return NullConnectionSecurityProvider.writeWithTimeout(this.clientConnection, this.socketChannel, this.sslOutBuffer);
                    }
                    case NEED_UNWRAP: {
                        this.sslInBuffer.clear();
                        this.clearInBuffer.clear();
                        int bytesRead = this.socketChannel.read(this.sslInBuffer);
                        if (bytesRead < 0) {
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                            return false;
                        }
                        if (bytesRead == 0) {
                            this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_WRITE_NEEDS_UNWRAP.get());
                            return false;
                        }
                        this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                        this.clearInBuffer.flip();
                        continue block17;
                    }
                }
                break;
            }
            block19: while (true) {
                int bytesWritten;
                if (!clearData.hasRemaining()) {
                    return true;
                }
                this.sslOutBuffer.clear();
                SSLEngineResult wrapResult = this.sslEngine.wrap(clearData, this.sslOutBuffer);
                this.sslOutBuffer.flip();
                switch (wrapResult.getStatus()) {
                    case OK: {
                        break;
                    }
                    case CLOSED: {
                        this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                        return false;
                    }
                    default: {
                        this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_UNEXPECTED_WRAP_STATUS.get(String.valueOf((Object)wrapResult.getStatus())));
                        return false;
                    }
                }
                switch (wrapResult.getHandshakeStatus()) {
                    case NEED_TASK: {
                        Runnable task = this.sslEngine.getDelegatedTask();
                        task.run();
                        break;
                    }
                    case NEED_WRAP: {
                        this.clearOutBuffer.clear();
                        this.sslOutBuffer.clear();
                        this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                        this.sslOutBuffer.flip();
                        while (this.sslOutBuffer.hasRemaining()) {
                            int bytesWritten2 = this.socketChannel.write(this.sslOutBuffer);
                            if (bytesWritten2 < 0) {
                                this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                                return false;
                            }
                            if (bytesWritten2 != 0) continue;
                            return NullConnectionSecurityProvider.writeWithTimeout(this.clientConnection, this.socketChannel, this.sslOutBuffer);
                        }
                        break;
                    }
                    case NEED_UNWRAP: {
                        this.sslInBuffer.clear();
                        this.clearInBuffer.clear();
                        int bytesRead = this.socketChannel.read(this.sslInBuffer);
                        if (bytesRead < 0) {
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                            return false;
                        }
                        if (bytesRead == 0) {
                            this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_WRITE_NEEDS_UNWRAP.get());
                            return false;
                        }
                        this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                        this.clearInBuffer.flip();
                        break;
                    }
                }
                do {
                    if (!this.sslOutBuffer.hasRemaining()) continue block19;
                    bytesWritten = this.socketChannel.write(this.sslOutBuffer);
                    if (bytesWritten >= 0) continue;
                    this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                } while (bytesWritten != 0);
                break;
            }
            return NullConnectionSecurityProvider.writeWithTimeout(this.clientConnection, this.socketChannel, this.sslOutBuffer);
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, ExtensionMessages.ERR_TLS_SECURITY_PROVIDER_WRITE_ERROR.get(StaticUtils.getExceptionMessage(e)));
            return false;
        }
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public SSLClientAuthPolicy getSSLClientAuthPolicy() {
        return this.sslClientAuthPolicy;
    }

    public void setSSLClientAuthPolicy(SSLClientAuthPolicy sslClientAuthPolicy) {
        this.sslClientAuthPolicy = sslClientAuthPolicy;
    }

    public SSLSession getSSLSession() {
        return this.sslEngine.getSession();
    }

    public Certificate[] getClientCertificateChain() {
        try {
            return this.sslEngine.getSession().getPeerCertificates();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }
    }
}

