/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FixedTimeLogRotationPolicyCfg;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedTimeRotationPolicy
implements RotationPolicy<FixedTimeLogRotationPolicyCfg>,
ConfigurationChangeListener<FixedTimeLogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long MS_IN_DAY = 86400000L;
    private int[] rotationTimes;

    @Override
    public void initializeLogRotationPolicy(FixedTimeLogRotationPolicyCfg config) {
        this.rotationTimes = new int[config.getTimeOfDay().size()];
        int i = 0;
        for (String time : config.getTimeOfDay()) {
            this.rotationTimes[i++] = Integer.valueOf(time);
        }
        Arrays.sort(this.rotationTimes);
        config.addFixedTimeChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FixedTimeLogRotationPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FixedTimeLogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.rotationTimes = new int[config.getTimeOfDay().size()];
        int i = 0;
        for (String time : config.getTimeOfDay()) {
            this.rotationTimes[i++] = Integer.valueOf(time);
        }
        Arrays.sort(this.rotationTimes);
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean rotateFile(MultifileTextWriter writer) {
        Calendar lastRotationTime = writer.getLastRotationTime();
        Calendar nextRotationTime = (Calendar)lastRotationTime.clone();
        int i = 0;
        nextRotationTime.set(11, this.rotationTimes[i] / 100);
        nextRotationTime.set(12, this.rotationTimes[i] % 100);
        nextRotationTime.set(13, 0);
        while (lastRotationTime.after(nextRotationTime)) {
            if (i == this.rotationTimes.length - 1) {
                nextRotationTime.add(5, 1);
                i = 0;
            } else {
                ++i;
            }
            nextRotationTime.set(11, this.rotationTimes[i] / 100);
            nextRotationTime.set(12, this.rotationTimes[i] % 100);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("The next fixed rotation time is %s", this.rotationTimes[i]);
        }
        return TimeThread.getCalendar().after(nextRotationTime);
    }
}

