/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalLDAPInputStream;
import org.opends.server.protocols.internal.InternalLDAPOutputStream;
import org.opends.server.types.DN;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class InternalLDAPSocket
extends Socket {
    private boolean closed = false;
    private boolean keepAlive = true;
    private boolean oobInline = true;
    private boolean reuseAddress = true;
    private boolean tcpNoDelay = true;
    private int lingerDuration = 0;
    private int receiveBufferSize = 1024;
    private int sendBufferSize = 1024;
    private int timeout = 0;
    private int trafficClass = 0;
    private InternalClientConnection conn = null;
    private InternalLDAPInputStream inputStream = new InternalLDAPInputStream(this);
    private InternalLDAPOutputStream outputStream = new InternalLDAPOutputStream(this);

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    synchronized InternalClientConnection getConnection() throws IOException {
        if (this.conn == null) {
            try {
                this.conn = new InternalClientConnection(DN.nullDN());
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        return this.conn;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    synchronized void setConnection(InternalClientConnection conn) {
        this.conn = conn;
    }

    public void bind(SocketAddress bindpoint) {
    }

    public synchronized void close() {
        try {
            this.inputStream.closeInternal();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.outputStream.closeInternal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
        this.inputStream = null;
        this.outputStream = null;
    }

    public synchronized void connect(SocketAddress endpoint) {
        this.closed = false;
        this.inputStream = new InternalLDAPInputStream(this);
        this.outputStream = new InternalLDAPOutputStream(this);
    }

    public void connect(SocketAddress endpoint, int timeout) {
        this.closed = false;
        this.inputStream = new InternalLDAPInputStream(this);
        this.outputStream = new InternalLDAPOutputStream(this);
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    public InternalLDAPInputStream getInputStream() {
        return this.inputStream;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getLocalPort() {
        return 389;
    }

    public SocketAddress getLocalSocketAddress() {
        try {
            return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getOOBInline() {
        return this.oobInline;
    }

    public InternalLDAPOutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getPort() {
        return 389;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public SocketAddress getRemoteSocketAddress() {
        try {
            return new InetSocketAddress(this.getInetAddress(), this.getPort());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getSoLinger() {
        return this.lingerDuration;
    }

    public int getSoTimeout() {
        return this.timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        return !this.closed;
    }

    public boolean isInputShutdown() {
        return this.closed;
    }

    public boolean isOutputShutdown() {
        return this.closed;
    }

    public void sendUrgentData(int data) throws IOException {
        this.getOutputStream().write(data);
    }

    public void setKeepAlive(boolean on) {
        this.keepAlive = on;
    }

    public void setOOBInline(boolean on) {
        this.oobInline = on;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public void setReuseAddress(boolean on) {
        this.reuseAddress = on;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public void setSoLinger(boolean on, int linger) {
        this.lingerDuration = linger;
    }

    public void setSoTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
    }

    public void setTrafficClass(int tc) {
        this.trafficClass = tc;
    }

    public void shutdownInput() {
        this.close();
    }

    public void shutdownOutput() {
        this.close();
    }

    public String toString() {
        return "InternalLDAPSocket";
    }
}

