/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.FakeOperationComparator;
import org.opends.server.replication.plugin.HeartbeatMonitor;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartMessage;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMessage;
import org.opends.server.replication.protocol.ServerStartMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.protocol.WindowMessage;
import org.opends.server.replication.protocol.WindowProbe;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationBroker
implements InternalSearchListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean shutdown = false;
    private Collection<String> servers;
    private boolean connected = false;
    private String replicationServer = "Not connected";
    private TreeSet<FakeOperation> replayOperations;
    private ProtocolSession session = null;
    private final ServerState state;
    private final DN baseDn;
    private final short serverID;
    private int maxSendDelay;
    private int maxReceiveDelay;
    private int maxSendQueue;
    private int maxReceiveQueue;
    private Semaphore sendWindow;
    private int maxSendWindow;
    private int rcvWindow;
    private int halfRcvWindow;
    private int maxRcvWindow;
    private int timeout = 0;
    private short protocolVersion;
    private long generationId = -1L;
    private ReplSessionSecurity replSessionSecurity;
    private String tmpReadableServerName = null;
    private long heartbeatInterval = 0L;
    private HeartbeatMonitor heartbeatMonitor = null;
    private int numLostConnections = 0;
    private boolean connectionError = false;
    private final Object connectPhaseLock = new Object();

    public ReplicationBroker(ServerState state, DN baseDn, short serverID, int maxReceiveQueue, int maxReceiveDelay, int maxSendQueue, int maxSendDelay, int window, long heartbeatInterval, long generationId, ReplSessionSecurity replSessionSecurity) {
        this.baseDn = baseDn;
        this.serverID = serverID;
        this.maxReceiveDelay = maxReceiveDelay;
        this.maxSendDelay = maxSendDelay;
        this.maxReceiveQueue = maxReceiveQueue;
        this.maxSendQueue = maxSendQueue;
        this.state = state;
        this.replayOperations = new TreeSet<FakeOperation>(new FakeOperationComparator());
        this.rcvWindow = window;
        this.maxRcvWindow = window;
        this.halfRcvWindow = window / 2;
        this.heartbeatInterval = heartbeatInterval;
        this.protocolVersion = ProtocolVersion.currentVersion();
        this.generationId = generationId;
        this.replSessionSecurity = replSessionSecurity;
    }

    public void start(Collection<String> servers) {
        this.shutdown = false;
        this.servers = servers;
        if (servers.size() < 1) {
            Message message = ReplicationMessages.NOTE_NEED_MORE_THAN_ONE_CHANGELOG_SERVER.get();
            ErrorLogger.logError(message);
        }
        this.rcvWindow = this.maxRcvWindow;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        HashMap<String, ServerState> rsStates = new HashMap<String, ServerState>();
        this.stopHeartBeat();
        Object object = this.connectPhaseLock;
        synchronized (object) {
            Message message;
            String bestServer;
            for (String server : this.servers) {
                ReplServerStartMessage replServerStartMsg = this.performHandshake(server, false);
                this.tmpReadableServerName = null;
                if (replServerStartMsg == null) continue;
                ServerState rsState = replServerStartMsg.getServerState();
                rsStates.put(server, rsState);
            }
            ReplServerStartMessage replServerStartMsg = null;
            if (rsStates.size() > 0 && (replServerStartMsg = this.performHandshake(bestServer = ReplicationBroker.computeBestReplicationServer(this.state, rsStates, this.serverID, this.baseDn), true)) != null) {
                Message message2;
                try {
                    ChangeNumber ourMaxChangeNumber;
                    ChangeNumber replServerMaxChangeNumber = replServerStartMsg.getServerState().getMaxChangeNumber(this.serverID);
                    if (replServerMaxChangeNumber == null) {
                        replServerMaxChangeNumber = new ChangeNumber(0L, 0, this.serverID);
                    }
                    if ((ourMaxChangeNumber = this.state.getMaxChangeNumber(this.serverID)) != null && !ourMaxChangeNumber.olderOrEqual(replServerMaxChangeNumber).booleanValue()) {
                        this.replayOperations.clear();
                        Message message3 = ReplicationMessages.DEBUG_GOING_TO_SEARCH_FOR_CHANGES.get();
                        ErrorLogger.logError(message3);
                        InternalSearchOperation op = ReplicationBroker.searchForChangedEntries(this.baseDn, replServerMaxChangeNumber, this);
                        if (op.getResultCode() != ResultCode.SUCCESS) {
                            message3 = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(this.baseDn.toNormalizedString());
                            ErrorLogger.logError(message3);
                        } else {
                            for (FakeOperation replayOp : this.replayOperations) {
                                message3 = ReplicationMessages.DEBUG_SENDING_CHANGE.get(replayOp.getChangeNumber().toString());
                                ErrorLogger.logError(message3);
                                this.session.publish(replayOp.generateMessage());
                            }
                            message3 = ReplicationMessages.DEBUG_CHANGES_SENT.get();
                            ErrorLogger.logError(message3);
                        }
                        this.replayOperations.clear();
                    }
                    this.replicationServer = this.tmpReadableServerName;
                    this.maxSendWindow = replServerStartMsg.getWindowSize();
                    this.connected = true;
                    this.startHeartBeat();
                }
                catch (IOException e) {
                    message2 = ReplicationMessages.ERR_PUBLISHING_FAKE_OPS.get(this.baseDn.toNormalizedString(), bestServer, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message2);
                }
                catch (Exception e) {
                    message2 = ReplicationMessages.ERR_COMPUTING_FAKE_OPS.get(this.baseDn.toNormalizedString(), bestServer, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message2);
                }
                finally {
                    if (!this.connected && this.session != null) {
                        try {
                            this.session.close();
                        }
                        catch (IOException e) {}
                        this.session = null;
                    }
                }
            }
            if (this.connected) {
                this.connectionError = false;
                if (this.sendWindow != null) {
                    this.sendWindow.release(Integer.MAX_VALUE);
                }
                this.sendWindow = new Semaphore(this.maxSendWindow);
                this.connectPhaseLock.notify();
                if (replServerStartMsg.getGenerationId() == this.generationId || replServerStartMsg.getGenerationId() == -1L) {
                    message = ReplicationMessages.NOTE_NOW_FOUND_SAME_GENERATION_CHANGELOG.get(this.baseDn.toString(), this.replicationServer, Long.toString(this.generationId));
                    ErrorLogger.logError(message);
                } else {
                    message = ReplicationMessages.NOTE_NOW_FOUND_BAD_GENERATION_CHANGELOG.get(this.baseDn.toString(), this.replicationServer, Long.toString(this.generationId), Long.toString(replServerStartMsg.getGenerationId()));
                    ErrorLogger.logError(message);
                }
            } else if (!this.connectionError) {
                this.connectionError = true;
                this.connectPhaseLock.notify();
                message = ReplicationMessages.NOTE_COULD_NOT_FIND_CHANGELOG.get(this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        }
    }

    public ReplServerStartMessage performHandshake(String server, boolean keepConnection) {
        ReplServerStartMessage replServerStartMsg = null;
        int separator = server.lastIndexOf(58);
        String port = server.substring(separator + 1);
        String hostname = server.substring(0, separator);
        boolean error = false;
        try {
            int intPort = Integer.parseInt(port);
            InetSocketAddress serverAddr = new InetSocketAddress(InetAddress.getByName(hostname), intPort);
            this.tmpReadableServerName = serverAddr.toString();
            Socket socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.setTcpNoDelay(true);
            socket.connect(serverAddr, 500);
            this.session = this.replSessionSecurity.createClientSession(server, socket);
            boolean isSslEncryption = this.replSessionSecurity.isSslEncryption(server);
            ServerStartMessage msg = new ServerStartMessage(this.serverID, this.baseDn, this.maxReceiveDelay, this.maxReceiveQueue, this.maxSendDelay, this.maxSendQueue, this.halfRcvWindow * 2, this.heartbeatInterval, this.state, this.protocolVersion, this.generationId, isSslEncryption, !keepConnection);
            this.session.publish(msg);
            this.session.setSoTimeout(1000);
            replServerStartMsg = (ReplServerStartMessage)this.session.receive();
            this.protocolVersion = ProtocolVersion.minWithCurrent(replServerStartMsg.getVersion());
            this.session.setSoTimeout(this.timeout);
            if (!isSslEncryption) {
                this.session.stopEncryption();
            }
        }
        catch (ConnectException e) {
            if (!this.connectionError) {
                Message message = ReplicationMessages.NOTE_NO_CHANGELOG_SERVER_LISTENING.get(server);
                ErrorLogger.logError(message);
            }
            error = true;
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION.get(this.baseDn.toNormalizedString(), server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            error = true;
        }
        if (!keepConnection || error) {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.session = null;
            }
            if (error) {
                replServerStartMsg = null;
            }
        }
        return replServerStartMsg;
    }

    public static String computeBestReplicationServer(ServerState myState, HashMap<String, ServerState> rsStates, short serverId, DN baseDn) {
        Message message;
        if (myState == null || rsStates == null || rsStates.size() < 1 || baseDn == null) {
            return null;
        }
        String bestServer = null;
        HashMap<String, ServerState> upToDateServers = new HashMap<String, ServerState>();
        HashMap<String, ServerState> lateOnes = new HashMap<String, ServerState>();
        ChangeNumber myChangeNumber = myState.getMaxChangeNumber(serverId);
        if (myChangeNumber == null) {
            myChangeNumber = new ChangeNumber(0L, 0, serverId);
        }
        for (String repServer : rsStates.keySet()) {
            ServerState rsState = rsStates.get(repServer);
            ChangeNumber rsChangeNumber = rsState.getMaxChangeNumber(serverId);
            if (rsChangeNumber == null) {
                rsChangeNumber = new ChangeNumber(0L, 0, serverId);
            }
            if (myChangeNumber.olderOrEqual(rsChangeNumber).booleanValue()) {
                upToDateServers.put(repServer, rsState);
                continue;
            }
            lateOnes.put(repServer, rsState);
        }
        if (upToDateServers.size() > 0) {
            message = ReplicationMessages.NOTE_FOUND_CHANGELOGS_WITH_MY_CHANGES.get(upToDateServers.size(), baseDn.toNormalizedString());
            ErrorLogger.logError(message);
            ServerState topoState = new ServerState();
            for (ServerState curState : upToDateServers.values()) {
                for (Short sId : curState) {
                    ChangeNumber curSidCn = curState.getMaxChangeNumber(sId);
                    if (curSidCn == null) {
                        curSidCn = new ChangeNumber(0L, 0, sId);
                    }
                    topoState.update(curSidCn);
                }
            }
            long minShift = -1L;
            for (String upServer : upToDateServers.keySet()) {
                long shift = -1L;
                ServerState curState = (ServerState)upToDateServers.get(upServer);
                for (Short sId : curState) {
                    ChangeNumber topoCurSidCn;
                    long tmpShift;
                    ChangeNumber curSidCn = curState.getMaxChangeNumber(sId);
                    if (curSidCn == null) {
                        curSidCn = new ChangeNumber(0L, 0, sId);
                    }
                    if ((tmpShift = (topoCurSidCn = topoState.getMaxChangeNumber(sId)).getTime() - curSidCn.getTime()) <= shift) continue;
                    shift = tmpShift;
                }
                if (minShift >= 0L && shift >= minShift) continue;
                bestServer = upServer;
                minShift = shift;
            }
        } else {
            message = ReplicationMessages.NOTE_COULD_NOT_FIND_CHANGELOG_WITH_MY_CHANGES.get(baseDn.toNormalizedString(), lateOnes.size());
            ErrorLogger.logError(message);
            long minShift = -1L;
            for (String lateServer : lateOnes.keySet()) {
                ServerState curState = (ServerState)lateOnes.get(lateServer);
                ChangeNumber ourSidCn = curState.getMaxChangeNumber(serverId);
                if (ourSidCn == null) {
                    ourSidCn = new ChangeNumber(0L, 0, serverId);
                }
                long tmpShift = myChangeNumber.getTime() - ourSidCn.getTime();
                if (minShift >= 0L && tmpShift >= minShift) continue;
                bestServer = lateServer;
                minShift = tmpShift;
            }
        }
        return bestServer;
    }

    public static InternalSearchOperation searchForChangedEntries(DN baseDn, ChangeNumber fromChangeNumber, InternalSearchListener resultListener) throws Exception {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LDAPFilter filter = LDAPFilter.decode("(ds-sync-hist>=dummy:" + fromChangeNumber + ")");
        LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
        attrs.add("ds-sync-hist");
        attrs.add("entryuuid");
        return conn.processSearch(new ASN1OctetString(baseDn.toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attrs, resultListener);
    }

    private void startHeartBeat() {
        if (this.heartbeatInterval > 0L) {
            this.heartbeatMonitor = new HeartbeatMonitor("Replication Heartbeat Monitor on " + this.baseDn + " with " + this.getReplicationServer(), this.session, this.heartbeatInterval);
            this.heartbeatMonitor.start();
        }
    }

    void stopHeartBeat() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.shutdown();
            this.heartbeatMonitor = null;
        }
    }

    public void reStart() {
        this.reStart(this.session);
    }

    public void reStart(ProtocolSession failingSession) {
        try {
            if (failingSession != null) {
                failingSession.close();
                ++this.numLostConnections;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (failingSession == this.session) {
            this.connected = false;
        }
        while (!this.connected && !this.shutdown) {
            try {
                this.connect();
            }
            catch (Exception e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.NOTE_EXCEPTION_RESTARTING_SESSION.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
            }
            if (this.connected || this.shutdown) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ReplicationMessage msg) {
        boolean done = false;
        while (!done && !this.shutdown) {
            if (this.connectionError) {
                if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo("ReplicationBroker.publish() Publishing a  message is not possible due to existing connection error.");
                }
                return;
            }
            try {
                Semaphore currentWindowSemaphore;
                ProtocolSession current_session;
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    current_session = this.session;
                    currentWindowSemaphore = this.sendWindow;
                }
                boolean credit = msg instanceof UpdateMessage ? currentWindowSemaphore.tryAcquire(500L, TimeUnit.MILLISECONDS) : true;
                if (credit) {
                    object = this.connectPhaseLock;
                    synchronized (object) {
                        if (this.session == current_session) {
                            this.session.publish(msg);
                            done = true;
                        }
                    }
                }
                if (credit) continue;
                this.session.publish(new WindowProbe());
            }
            catch (IOException e) {
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    block19: {
                        try {
                            this.connectPhaseLock.wait(100L);
                        }
                        catch (InterruptedException e1) {
                            if (!this.debugEnabled()) break block19;
                            ReplicationBroker.debugInfo("ReplicationBroker.publish() IO exception raised : " + e.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (!this.debugEnabled()) continue;
                ReplicationBroker.debugInfo("ReplicationBroker.publish() Interrupted exception raised." + e.getLocalizedMessage());
            }
        }
    }

    public ReplicationMessage receive() throws SocketTimeoutException {
        while (!this.shutdown) {
            if (!this.connected) {
                this.reStart(null);
            }
            ProtocolSession failingSession = this.session;
            try {
                ReplicationMessage msg = this.session.receive();
                if (msg instanceof WindowMessage) {
                    WindowMessage windowMsg = (WindowMessage)msg;
                    this.sendWindow.release(windowMsg.getNumAck());
                    continue;
                }
                return msg;
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                Message message = ReplicationMessages.NOTE_DISCONNECTED_FROM_CHANGELOG.get(this.replicationServer);
                ErrorLogger.logError(message);
                ReplicationBroker.debugInfo("ReplicationBroker.receive() " + this.baseDn + " Exception raised." + e + e.getLocalizedMessage());
                this.reStart(failingSession);
            }
        }
        return null;
    }

    public synchronized void updateWindowAfterReplay() {
        try {
            --this.rcvWindow;
            if (this.rcvWindow < this.halfRcvWindow) {
                this.session.publish(new WindowMessage(this.halfRcvWindow));
                this.rcvWindow += this.halfRcvWindow;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stop() {
        this.replicationServer = "stopped";
        this.shutdown = true;
        this.connected = false;
        try {
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("ReplicationBroker is stopping. and will close the connection");
            }
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.session != null) {
            this.session.setSoTimeout(timeout);
        }
    }

    public void setGenerationId(long generationId) {
        this.generationId = generationId;
    }

    public String getReplicationServer() {
        return this.replicationServer;
    }

    @Override
    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) {
        Iterable<FakeOperation> updates = Historical.generateFakeOperations(searchEntry);
        for (FakeOperation op : updates) {
            this.replayOperations.add(op);
        }
    }

    @Override
    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) {
    }

    public int getMaxRcvWindow() {
        return this.maxRcvWindow;
    }

    public int getCurrentRcvWindow() {
        return this.rcvWindow;
    }

    public int getMaxSendWindow() {
        return this.maxSendWindow;
    }

    public int getCurrentSendWindow() {
        if (this.connected) {
            return this.sendWindow.availablePermits();
        }
        return 0;
    }

    public int getNumLostConnections() {
        return this.numLostConnections;
    }

    public void changeConfig(Collection<String> replicationServers, int maxReceiveQueue, int maxReceiveDelay, int maxSendQueue, int maxSendDelay, int window, long heartbeatInterval) {
        this.servers = replicationServers;
        this.maxRcvWindow = window;
        this.heartbeatInterval = heartbeatInterval;
        this.maxReceiveDelay = maxReceiveDelay;
        this.maxReceiveQueue = maxReceiveQueue;
        this.maxSendDelay = maxSendDelay;
        this.maxSendQueue = maxSendQueue;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isConnected() {
        return !this.connectionError;
    }

    private boolean debugEnabled() {
        return true;
    }

    private static final void debugInfo(String s) {
        ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, s, new Object[0]));
        TRACER.debugInfo(s);
    }

    public boolean isSessionEncrypted() {
        boolean isEncrypted = false;
        if (this.session != null) {
            return this.session.isEncrypted();
        }
        return isEncrypted;
    }
}

