/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.TaskState;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.tasks.TaskClientException;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskClient {
    protected LDAPConnection connection;
    private AtomicInteger nextMessageID = new AtomicInteger(0);

    public TaskClient(LDAPConnection conn) {
        this.connection = conn;
    }

    public synchronized TaskEntry schedule(TaskScheduleInformation information) throws LDAPException, IOException, ASN1Exception, TaskClientException {
        List<String> errNotifEmailAddresss;
        List<String> compNotifEmailAddresss;
        List<String> dependencyIds;
        LDAPReader reader = this.connection.getLDAPReader();
        LDAPWriter writer = this.connection.getLDAPWriter();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssMM");
        String taskID = df.format(new Date());
        ASN1OctetString entryDN = new ASN1OctetString("ds-task-id=" + taskID + "," + "cn=Scheduled Tasks" + "," + "cn=Tasks");
        ArrayList<LDAPControl> controls = new ArrayList<LDAPControl>();
        ArrayList<RawAttribute> attributes = new ArrayList<RawAttribute>();
        ArrayList<ASN1OctetString> ocValues = new ArrayList<ASN1OctetString>(3);
        ocValues.add(new ASN1OctetString("top"));
        ocValues.add(new ASN1OctetString("ds-task"));
        ocValues.add(new ASN1OctetString(information.getTaskObjectclass()));
        attributes.add(new LDAPAttribute("objectClass", ocValues));
        ArrayList<ASN1OctetString> taskIDValues = new ArrayList<ASN1OctetString>(1);
        taskIDValues.add(new ASN1OctetString(taskID));
        attributes.add(new LDAPAttribute("ds-task-id", taskIDValues));
        ArrayList<ASN1OctetString> classValues = new ArrayList<ASN1OctetString>(1);
        classValues.add(new ASN1OctetString(information.getTaskClass().getName()));
        attributes.add(new LDAPAttribute("ds-task-class-name", classValues));
        Date startDate = information.getStartDateTime();
        if (startDate != null) {
            String startTimeString = StaticUtils.formatDateTimeString(startDate);
            ArrayList<ASN1OctetString> startDateValues = new ArrayList<ASN1OctetString>(1);
            startDateValues.add(new ASN1OctetString(startTimeString));
            attributes.add(new LDAPAttribute("ds-task-scheduled-start-time", startDateValues));
        }
        if ((dependencyIds = information.getDependencyIds()) != null && dependencyIds.size() > 0) {
            ArrayList<ASN1OctetString> dependencyIdValues = new ArrayList<ASN1OctetString>(dependencyIds.size());
            for (String dependencyId : dependencyIds) {
                dependencyIdValues.add(new ASN1OctetString(dependencyId));
            }
            attributes.add(new LDAPAttribute("ds-task-dependency-id", dependencyIdValues));
            FailedDependencyAction fda = information.getFailedDependencyAction();
            if (fda == null) {
                fda = FailedDependencyAction.defaultValue();
            }
            ArrayList<ASN1OctetString> fdaValues = new ArrayList<ASN1OctetString>(1);
            fdaValues.add(new ASN1OctetString(fda.name()));
            attributes.add(new LDAPAttribute("ds-task-failed-dependency-action", fdaValues));
        }
        if ((compNotifEmailAddresss = information.getNotifyUponCompletionEmailAddresses()) != null && compNotifEmailAddresss.size() > 0) {
            ArrayList<ASN1OctetString> compNotifEmailAddrValues = new ArrayList<ASN1OctetString>(compNotifEmailAddresss.size());
            for (String emailAddr : compNotifEmailAddresss) {
                compNotifEmailAddrValues.add(new ASN1OctetString(emailAddr));
            }
            attributes.add(new LDAPAttribute("ds-task-notify-on-completion", compNotifEmailAddrValues));
        }
        if ((errNotifEmailAddresss = information.getNotifyUponErrorEmailAddresses()) != null && errNotifEmailAddresss.size() > 0) {
            ArrayList<ASN1OctetString> errNotifEmailAddrValues = new ArrayList<ASN1OctetString>(errNotifEmailAddresss.size());
            for (String emailAddr : errNotifEmailAddresss) {
                errNotifEmailAddrValues.add(new ASN1OctetString(emailAddr));
            }
            attributes.add(new LDAPAttribute("ds-task-notify-on-error", errNotifEmailAddrValues));
        }
        information.addTaskAttributes(attributes);
        AddRequestProtocolOp addRequest = new AddRequestProtocolOp(entryDN, attributes);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), addRequest, controls);
        writer.writeMessage(requestMessage);
        LDAPMessage responseMessage = reader.readMessage();
        if (responseMessage == null) {
            throw new LDAPException(81, ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get());
        }
        if (responseMessage.getProtocolOpType() != 105) {
            throw new LDAPException(82, ToolMessages.ERR_TASK_CLIENT_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName()));
        }
        AddResponseProtocolOp addResponse = responseMessage.getAddResponseProtocolOp();
        Message errorMessage = addResponse.getErrorMessage();
        if (errorMessage != null) {
            throw new LDAPException(82, errorMessage);
        }
        return this.getTaskEntry(taskID);
    }

    public synchronized List<TaskEntry> getTaskEntries() throws LDAPException, IOException, ASN1Exception {
        byte opType;
        ArrayList<SearchResultEntry> entries = new ArrayList<SearchResultEntry>();
        this.writeSearch(new SearchRequestProtocolOp(new ASN1OctetString("cn=Tasks"), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, Integer.MAX_VALUE, Integer.MAX_VALUE, false, LDAPFilter.decode("(objectclass=ds-task)"), new LinkedHashSet<String>()));
        LDAPReader reader = this.connection.getLDAPReader();
        do {
            LDAPMessage responseMessage;
            if ((responseMessage = reader.readMessage()) == null) {
                throw new LDAPException(81, ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get());
            }
            opType = responseMessage.getProtocolOpType();
            if (opType != 100) continue;
            SearchResultEntryProtocolOp searchEntryOp = responseMessage.getSearchResultEntryProtocolOp();
            Entry entry = searchEntryOp.toSearchResultEntry();
            entries.add((SearchResultEntry)entry);
        } while (opType != 101);
        ArrayList<TaskEntry> taskEntries = new ArrayList<TaskEntry>(entries.size());
        for (Entry entry : entries) {
            taskEntries.add(new TaskEntry(entry));
        }
        return Collections.unmodifiableList(taskEntries);
    }

    public synchronized TaskEntry getTaskEntry(String id) throws LDAPException, IOException, ASN1Exception, TaskClientException {
        byte opType;
        SearchResultEntry entry = null;
        this.writeSearch(new SearchRequestProtocolOp(new ASN1OctetString("cn=Tasks"), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, Integer.MAX_VALUE, Integer.MAX_VALUE, false, LDAPFilter.decode("(ds-task-id=" + id + ")"), new LinkedHashSet<String>()));
        LDAPReader reader = this.connection.getLDAPReader();
        do {
            LDAPMessage responseMessage;
            if ((responseMessage = reader.readMessage()) == null) {
                Message message = ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get();
                throw new LDAPException(ResultCode.UNAVAILABLE.getIntValue(), message);
            }
            opType = responseMessage.getProtocolOpType();
            if (opType != 100) continue;
            SearchResultEntryProtocolOp searchEntryOp = responseMessage.getSearchResultEntryProtocolOp();
            entry = searchEntryOp.toSearchResultEntry();
        } while (opType != 101);
        if (entry == null) {
            throw new TaskClientException(ToolMessages.ERR_TASK_CLIENT_UNKNOWN_TASK.get(id));
        }
        return new TaskEntry(entry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized TaskEntry cancelTask(String id) throws TaskClientException, IOException, ASN1Exception, LDAPException {
        LDAPReader reader = this.connection.getLDAPReader();
        LDAPWriter writer = this.connection.getLDAPWriter();
        TaskEntry entry = this.getTaskEntry(id);
        TaskState state = entry.getTaskState();
        if (state == null) throw new TaskClientException(ToolMessages.ERR_TASK_CLIENT_TASK_STATE_UNKNOWN.get(id));
        if (TaskState.isDone(state)) throw new TaskClientException(ToolMessages.ERR_TASK_CLIENT_UNCANCELABLE_TASK.get(id));
        ASN1OctetString dn = new ASN1OctetString(entry.getDN().toString());
        ArrayList<RawModification> mods = new ArrayList<RawModification>();
        ArrayList<ASN1OctetString> values = new ArrayList<ASN1OctetString>();
        String newState = TaskState.isPending(state) ? TaskState.CANCELED_BEFORE_STARTING.name() : TaskState.STOPPED_BY_ADMINISTRATOR.name();
        values.add(new ASN1OctetString(newState));
        LDAPAttribute attr = new LDAPAttribute("ds-task-state", values);
        mods.add(new LDAPModification(ModificationType.REPLACE, attr));
        ModifyRequestProtocolOp modRequest = new ModifyRequestProtocolOp(dn, mods);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), modRequest, null);
        writer.writeMessage(requestMessage);
        LDAPMessage responseMessage = reader.readMessage();
        if (responseMessage == null) {
            Message message = ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get();
            throw new LDAPException(ResultCode.UNAVAILABLE.getIntValue(), message);
        }
        if (responseMessage.getProtocolOpType() != 103) {
            throw new LDAPException(82, ToolMessages.ERR_TASK_CLIENT_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName()));
        }
        ModifyResponseProtocolOp modResponse = responseMessage.getModifyResponseProtocolOp();
        Message errorMessage = modResponse.getErrorMessage();
        if (errorMessage == null) return this.getTaskEntry(id);
        throw new LDAPException(82, errorMessage);
    }

    private void writeSearch(SearchRequestProtocolOp searchRequest) throws IOException {
        LDAPWriter writer = this.connection.getLDAPWriter();
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), searchRequest, new ArrayList<LDAPControl>());
        writer.writeMessage(requestMessage);
    }
}

