/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ExpirationCheckTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;

    public ExpirationCheckTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Date currentDate = new Date();
        for (X509Certificate c : chain) {
            try {
                c.checkValidity(currentDate);
            }
            catch (CertificateExpiredException cee) {
                Message message = UtilityMessages.ERR_EXPCHECK_TRUSTMGR_CLIENT_CERT_EXPIRED.get(c.getSubjectDN().getName(), String.valueOf(c.getNotAfter()));
                ErrorLogger.logError(message);
                throw cee;
            }
            catch (CertificateNotYetValidException cnyve) {
                Message message = UtilityMessages.ERR_EXPCHECK_TRUSTMGR_CLIENT_CERT_NOT_YET_VALID.get(c.getSubjectDN().getName(), String.valueOf(c.getNotBefore()));
                ErrorLogger.logError(message);
                throw cnyve;
            }
        }
        this.trustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Date currentDate = new Date();
        for (X509Certificate c : chain) {
            try {
                c.checkValidity(currentDate);
            }
            catch (CertificateExpiredException cee) {
                Message message = UtilityMessages.ERR_EXPCHECK_TRUSTMGR_SERVER_CERT_EXPIRED.get(c.getSubjectDN().getName(), String.valueOf(c.getNotAfter()));
                ErrorLogger.logError(message);
                throw cee;
            }
            catch (CertificateNotYetValidException cnyve) {
                Message message = UtilityMessages.ERR_EXPCHECK_TRUSTMGR_SERVER_CERT_NOT_YET_VALID.get(c.getSubjectDN().getName(), String.valueOf(c.getNotBefore()));
                ErrorLogger.logError(message);
                throw cnyve;
            }
        }
        this.trustManager.checkServerTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

