/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.table;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TableSerializer;

public final class CSVTablePrinter
extends TablePrinter {
    private boolean displayHeadings = false;
    private PrintWriter writer = null;

    public CSVTablePrinter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public CSVTablePrinter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void setDisplayHeadings(boolean displayHeadings) {
        this.displayHeadings = displayHeadings;
    }

    protected TableSerializer getSerializer() {
        return new Serializer();
    }

    private final class Serializer
    extends TableSerializer {
        private int column = 0;
        private int requiredSeparators = 0;

        private Serializer() {
        }

        public void addCell(String s) {
            if (s.length() == 0) {
                ++this.requiredSeparators;
            } else {
                for (int i = 0; i < this.requiredSeparators; ++i) {
                    CSVTablePrinter.this.writer.print(',');
                }
                this.requiredSeparators = 1;
            }
            boolean needsQuoting = false;
            if (s.contains(",")) {
                needsQuoting = true;
            }
            if (s.contains("\n")) {
                needsQuoting = true;
            }
            if (s.contains("\r")) {
                needsQuoting = true;
            }
            if (s.contains("\"")) {
                needsQuoting = true;
                s = s.replace("\"", "\"\"");
            }
            if (s.startsWith(" ")) {
                needsQuoting = true;
            }
            if (s.endsWith(" ")) {
                needsQuoting = true;
            }
            StringBuilder builder = new StringBuilder();
            if (needsQuoting) {
                builder.append("\"");
            }
            builder.append(s);
            if (needsQuoting) {
                builder.append("\"");
            }
            CSVTablePrinter.this.writer.print(builder.toString());
            ++this.column;
        }

        public void addHeading(String s) {
            if (CSVTablePrinter.this.displayHeadings) {
                this.addCell(s);
            }
        }

        public void endHeader() {
            if (CSVTablePrinter.this.displayHeadings) {
                CSVTablePrinter.this.writer.println();
            }
        }

        public void endRow() {
            CSVTablePrinter.this.writer.println();
        }

        public void endTable() {
            CSVTablePrinter.this.writer.flush();
        }

        public void startHeader() {
            this.column = 0;
            this.requiredSeparators = 0;
        }

        public void startRow() {
            this.column = 0;
            this.requiredSeparators = 0;
        }
    }
}

