/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.util.ArrayList;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.Container";
    private Environment env;
    private String containerName;
    private ArrayList<Database> databases;
    private ArrayList<Cursor> cursors;

    public Container(Environment environment, String string) {
        this.env = environment;
        this.containerName = string;
    }

    public void open() {
        this.databases = new ArrayList();
        this.cursors = new ArrayList();
    }

    public void close() throws DatabaseException {
        for (Cursor cursor : this.cursors) {
            cursor.close();
        }
        for (Database database : this.databases) {
            if (database.getConfig().getDeferredWrite()) {
                database.sync();
            }
            database.close();
        }
    }

    private void buildDatabaseName(StringBuilder stringBuilder, String string) {
        if (this.containerName != null) {
            stringBuilder.append(this.containerName);
            stringBuilder.append('_');
        }
        stringBuilder.append(string);
    }

    public synchronized Database openDatabase(DatabaseConfig databaseConfig, String string) throws DatabaseException {
        Database database;
        StringBuilder stringBuilder = new StringBuilder();
        this.buildDatabaseName(stringBuilder, string);
        String string2 = stringBuilder.toString();
        if (databaseConfig.getTransactional()) {
            Transaction transaction = this.beginTransaction();
            try {
                database = this.env.openDatabase(transaction, string2, databaseConfig);
                assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "openDatabase", "open db=" + database.getDatabaseName() + " txnid=" + transaction.getId()));
                Container.transactionCommit(transaction);
            }
            catch (DatabaseException databaseException) {
                Container.transactionAbort(transaction);
                throw databaseException;
            }
        } else {
            database = this.env.openDatabase(null, string2, databaseConfig);
            assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "openDatabase", "open db=" + database.getDatabaseName() + " txnid=none"));
        }
        this.databases.add(database);
        return database;
    }

    public synchronized void addCursor(Cursor cursor) {
        this.cursors.add(cursor);
    }

    public Transaction beginTransaction() throws DatabaseException {
        Transaction transaction = null;
        TransactionConfig transactionConfig = null;
        Transaction transaction2 = this.env.beginTransaction(transaction, transactionConfig);
        assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "beginTransaction", "begin txnid=" + transaction2.getId()));
        return transaction2;
    }

    public static void transactionCommit(Transaction transaction) throws DatabaseException {
        if (transaction != null) {
            transaction.commit();
            assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "transactionCommit", "commit txnid=" + transaction.getId()));
        }
    }

    public static void transactionAbort(Transaction transaction) throws DatabaseException {
        if (transaction != null) {
            transaction.abort();
            assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "transactionAbort", "abort txnid=" + transaction.getId()));
        }
    }

    private static boolean debugAccess(String string, DebugLogCategory debugLogCategory, OperationStatus operationStatus, Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (operationStatus == OperationStatus.SUCCESS) {
            stringBuilder.append(" (ok)");
        } else {
            stringBuilder.append(" (");
            stringBuilder.append(operationStatus.toString());
            stringBuilder.append(")");
        }
        stringBuilder.append(" db=");
        stringBuilder.append(database.getDatabaseName());
        if (transaction != null) {
            stringBuilder.append(" txnid=");
            stringBuilder.append(transaction.getId());
        } else {
            stringBuilder.append(" txnid=none");
        }
        Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "debugAccess", stringBuilder.toString());
        if (operationStatus == OperationStatus.SUCCESS) {
            stringBuilder.append(" key:");
            stringBuilder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(stringBuilder, databaseEntry.getData(), 0);
            if (databaseEntry2 != null) {
                stringBuilder.append("data(len=");
                stringBuilder.append(databaseEntry2.getSize());
                stringBuilder.append("):");
                stringBuilder.append(ServerConstants.EOL);
                StaticUtils.byteArrayToHexPlusAscii(stringBuilder, databaseEntry2.getData(), 0);
            }
            Debug.debugMessage(debugLogCategory, DebugLogSeverity.VERBOSE, CLASS_NAME, "debugAccess", stringBuilder.toString());
        }
        return true;
    }

    public static OperationStatus insert(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = database.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
        assert (Container.debugAccess("insert", DebugLogCategory.DATABASE_WRITE, operationStatus, database, transaction, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus cursorInsert(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = cursor.putNoOverwrite(databaseEntry, databaseEntry2);
        assert (Container.debugAccess("cursorInsert", DebugLogCategory.DATABASE_WRITE, operationStatus, cursor.getDatabase(), null, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus put(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = database.put(transaction, databaseEntry, databaseEntry2);
        assert (Container.debugAccess("put", DebugLogCategory.DATABASE_WRITE, operationStatus, database, transaction, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus cursorPut(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = cursor.put(databaseEntry, databaseEntry2);
        assert (Container.debugAccess("cursorPut", DebugLogCategory.DATABASE_WRITE, operationStatus, cursor.getDatabase(), null, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus read(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = database.get(transaction, databaseEntry, databaseEntry2, lockMode);
        assert (Container.debugAccess("read", DebugLogCategory.DATABASE_READ, operationStatus, database, transaction, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus cursorRead(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = cursor.getSearchKey(databaseEntry, databaseEntry2, lockMode);
        assert (Container.debugAccess("cursorRead", DebugLogCategory.DATABASE_READ, operationStatus, cursor.getDatabase(), null, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus delete(Database database, Transaction transaction, DatabaseEntry databaseEntry) throws DatabaseException {
        OperationStatus operationStatus = database.delete(transaction, databaseEntry);
        assert (Container.debugAccess("delete", DebugLogCategory.DATABASE_WRITE, operationStatus, database, transaction, databaseEntry, null));
        return operationStatus;
    }

    public void removeDatabase(String string) throws DatabaseException {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildDatabaseName(stringBuilder, string);
        String string2 = stringBuilder.toString();
        this.env.removeDatabase(null, string2);
    }

    public void removeAllDatabases() throws DatabaseException {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildDatabaseName(stringBuilder, "");
        String string = stringBuilder.toString();
        List list = this.env.getDatabaseNames();
        if (list != null) {
            for (Object e : list) {
                String string2 = (String)e;
                if (!string2.startsWith(string)) continue;
                this.env.removeDatabase(null, string2);
            }
        }
    }

    public synchronized ArrayList<Database> getDatabaseList() {
        return new ArrayList<Database>(this.databases);
    }
}

