/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.core.DirectoryException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityIndexer
extends Indexer {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.EqualityIndexer";
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private IndexConfig indexConfig;

    public EqualityIndexer(IndexConfig indexConfig) {
        this.indexConfig = indexConfig;
    }

    public String toString() {
        return this.indexConfig.getAttributeType().getNameOrOID() + ".equality";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction transaction, Entry entry, Set<ASN1OctetString> set) throws DatabaseException {
        List<Attribute> list = entry.getAttribute(this.indexConfig.getAttributeType());
        if (list != null) {
            this.indexAttribute(list, set);
        }
    }

    @Override
    public void replaceEntry(Transaction transaction, Entry entry, Entry entry2, Set<ASN1OctetString> set, Set<ASN1OctetString> set2) throws DatabaseException {
        List<Attribute> list = entry.getAttribute(this.indexConfig.getAttributeType());
        HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(list, hashSet);
        list = entry2.getAttribute(this.indexConfig.getAttributeType());
        HashSet<ASN1OctetString> hashSet2 = new HashSet<ASN1OctetString>();
        this.indexAttribute(list, hashSet2);
        HashSet<ASN1OctetString> hashSet3 = new HashSet<ASN1OctetString>(hashSet);
        hashSet3.removeAll(hashSet2);
        for (ASN1OctetString object2 : hashSet3) {
            set2.add(object2);
        }
        HashSet<ASN1OctetString> hashSet4 = new HashSet<ASN1OctetString>(hashSet2);
        hashSet4.removeAll(hashSet);
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)iterator.next();
            set.add(aSN1OctetString);
        }
    }

    @Override
    public void modifyEntry(Transaction transaction, Entry entry, Entry entry2, List<Modification> list, Set<ASN1OctetString> set, Set<ASN1OctetString> set2) throws DatabaseException {
        List<Attribute> list2 = entry.getAttribute(this.indexConfig.getAttributeType());
        block5: for (Modification modification : list) {
            Attribute attribute = modification.getAttribute();
            AttributeType attributeType = attribute.getAttributeType();
            if (!attributeType.equals(this.indexConfig.getAttributeType())) continue;
            switch (modification.getModificationType()) {
                case REPLACE: 
                case INCREMENT: {
                    if (list2 != null) {
                        for (Attribute attribute2 : list2) {
                            if (!attribute2.hasOptions(attribute.getOptions())) continue;
                            this.indexValues(attribute2.getValues(), set2);
                        }
                    }
                    this.indexValues(attribute.getValues(), set);
                    break;
                }
                case ADD: {
                    this.indexValues(attribute.getValues(), set);
                    break;
                }
                case DELETE: {
                    if (!attribute.hasValue()) {
                        if (list2 == null) break;
                        for (Attribute attribute2 : list2) {
                            if (!attribute2.hasOptions(attribute.getOptions())) continue;
                            this.indexValues(attribute2.getValues(), set2);
                        }
                        continue block5;
                    }
                    this.indexValues(attribute.getValues(), set2);
                }
            }
        }
    }

    private void indexValues(Set<AttributeValue> set, Set<ASN1OctetString> set2) {
        if (set == null) {
            return;
        }
        for (AttributeValue attributeValue : set) {
            try {
                byte[] byArray = attributeValue.getNormalizedValue().value();
                set2.add(new ASN1OctetString(byArray));
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "indexAttribute", directoryException));
            }
        }
    }

    private void indexAttribute(List<Attribute> list, Set<ASN1OctetString> set) {
        if (list == null) {
            return;
        }
        for (Attribute attribute : list) {
            this.indexValues(attribute.getValues(), set);
        }
    }
}

