/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexMod;
import org.opends.server.backends.jeb.IndexModComparator;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Entry;

public class IndexBuilder {
    private ImportContext importContext;
    private Index index;
    private Indexer indexer;
    ArrayList<IndexMod> buffer;
    private int bufferSize;
    private int fileNumber = 0;
    private int entryLimit;
    private String fileNamePrefix;
    private boolean replaceExisting = false;
    private ByteArrayOutputStream addBytesStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream delBytesStream = new ByteArrayOutputStream();
    private DataOutputStream addBytesDataStream;
    private DataOutputStream delBytesDataStream;
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.startsWith(IndexBuilder.this.fileNamePrefix);
        }
    };

    public IndexBuilder(ImportContext importContext, Index index, int n, long l) {
        this.importContext = importContext;
        this.index = index;
        this.indexer = index.indexer;
        this.entryLimit = n;
        this.bufferSize = (int)l / 100;
        long l2 = Thread.currentThread().getId();
        this.fileNamePrefix = importContext.getContainerName() + "_" + this.indexer.toString() + "_" + l2 + "_";
        this.replaceExisting = importContext.getLDIFImportConfig().appendToExistingData() && importContext.getLDIFImportConfig().replaceExistingEntries();
        this.addBytesDataStream = new DataOutputStream(this.addBytesStream);
        this.delBytesDataStream = new DataOutputStream(this.delBytesStream);
    }

    public void startProcessing() {
        File file = new File(this.importContext.getConfig().getImportTempDirectory());
        File[] fileArray = file.listFiles(this.filter);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                file2.delete();
            }
        }
        this.buffer = new ArrayList(this.bufferSize);
    }

    public void processEntry(Entry entry, Entry entry2, EntryID entryID) throws DatabaseException, IOException {
        Transaction transaction = null;
        if (entry != null) {
            HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
            HashSet<ASN1OctetString> hashSet2 = new HashSet<ASN1OctetString>();
            this.indexer.replaceEntry(transaction, entry, entry2, hashSet, hashSet2);
            for (ASN1OctetString aSN1OctetString : hashSet2) {
                this.removeID(aSN1OctetString.value(), entryID);
            }
            for (ASN1OctetString aSN1OctetString : hashSet) {
                this.insertID(aSN1OctetString.value(), entryID);
            }
        } else {
            HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
            this.indexer.indexEntry(transaction, entry2, hashSet);
            for (ASN1OctetString aSN1OctetString : hashSet) {
                this.insertID(aSN1OctetString.value(), entryID);
            }
        }
    }

    public void stopProcessing() throws IOException {
        this.flushBuffer();
    }

    public int getEntryLimitExceededCount() {
        return this.index.getEntryLimitExceededCount();
    }

    private void insertID(byte[] byArray, EntryID entryID) throws IOException {
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
        IndexMod indexMod = new IndexMod(byArray, entryID, false);
        this.buffer.add(indexMod);
    }

    private void removeID(byte[] byArray, EntryID entryID) throws IOException {
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
        IndexMod indexMod = new IndexMod(byArray, entryID, true);
        this.buffer.add(indexMod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        if (this.buffer.size() == 0) {
            return;
        }
        IndexModComparator indexModComparator = this.replaceExisting ? new IndexModComparator(this.indexer.getComparator(), true) : new IndexModComparator(this.indexer.getComparator(), false);
        Collections.sort(this.buffer, indexModComparator);
        ++this.fileNumber;
        String string = this.fileNamePrefix + String.valueOf(this.fileNumber);
        File file = new File(this.importContext.getConfig().getImportTempDirectory(), string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.addBytesStream.reset();
        this.delBytesStream.reset();
        try {
            byte[] byArray = null;
            for (IndexMod indexMod : this.buffer) {
                byte[] byArray2 = indexMod.key;
                if (!Arrays.equals(byArray2, byArray)) {
                    if (byArray != null) {
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        dataOutputStream.writeInt(this.addBytesStream.size());
                        this.addBytesStream.writeTo(dataOutputStream);
                        if (this.replaceExisting) {
                            dataOutputStream.writeInt(this.delBytesStream.size());
                            this.delBytesStream.writeTo(dataOutputStream);
                        }
                    }
                    byArray = byArray2;
                    this.addBytesStream.reset();
                    this.delBytesStream.reset();
                }
                if (indexMod.isDelete) {
                    this.delBytesDataStream.writeLong(indexMod.value.longValue());
                    continue;
                }
                this.addBytesDataStream.writeLong(indexMod.value.longValue());
            }
            if (byArray != null) {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
                dataOutputStream.writeInt(this.addBytesStream.size());
                this.addBytesStream.writeTo(dataOutputStream);
                if (this.replaceExisting) {
                    dataOutputStream.writeInt(this.delBytesStream.size());
                    this.delBytesStream.writeTo(dataOutputStream);
                }
            }
            this.buffer = new ArrayList(this.bufferSize);
        }
        finally {
            dataOutputStream.close();
        }
    }

    public String toString() {
        return this.indexer.toString();
    }
}

