/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.FilterType;
import org.opends.server.types.SearchFilter;

public class IndexFilter {
    public static final int FILTER_CANDIDATE_THRESHOLD = 10;
    private EntryContainer entryContainer;
    private SearchOperation searchOp;
    private StringBuilder buffer;

    public IndexFilter(EntryContainer entryContainer, SearchOperation searchOperation, StringBuilder stringBuilder) {
        this.entryContainer = entryContainer;
        this.searchOp = searchOperation;
        this.buffer = stringBuilder;
    }

    public EntryIDSet evaluate() {
        if (this.buffer != null) {
            this.buffer.append("filter=");
        }
        return this.evaluateFilter(this.searchOp.getFilter());
    }

    private EntryIDSet evaluateFilter(SearchFilter searchFilter) {
        EntryIDSet entryIDSet;
        switch (searchFilter.getFilterType()) {
            case AND: {
                if (this.buffer != null) {
                    this.buffer.append("(&");
                }
                entryIDSet = this.evaluateLogicalAndFilter(searchFilter);
                if (this.buffer == null) break;
                this.buffer.append(")");
                break;
            }
            case OR: {
                if (this.buffer != null) {
                    this.buffer.append("(|");
                }
                entryIDSet = this.evaluateLogicalOrFilter(searchFilter);
                if (this.buffer == null) break;
                this.buffer.append(")");
                break;
            }
            case EQUALITY: {
                if (this.buffer != null) {
                    searchFilter.toString(this.buffer);
                }
                entryIDSet = this.evaluateEqualityFilter(searchFilter);
                break;
            }
            case GREATER_OR_EQUAL: {
                if (this.buffer != null) {
                    searchFilter.toString(this.buffer);
                }
                entryIDSet = this.evaluateGreaterOrEqualFilter(searchFilter);
                break;
            }
            case SUBSTRING: {
                if (this.buffer != null) {
                    searchFilter.toString(this.buffer);
                }
                entryIDSet = this.evaluateSubstringFilter(searchFilter);
                break;
            }
            case LESS_OR_EQUAL: {
                if (this.buffer != null) {
                    searchFilter.toString(this.buffer);
                }
                entryIDSet = this.evaluateLessOrEqualFilter(searchFilter);
                break;
            }
            case PRESENT: {
                if (this.buffer != null) {
                    searchFilter.toString(this.buffer);
                }
                entryIDSet = this.evaluatePresenceFilter(searchFilter);
                break;
            }
            default: {
                if (this.buffer != null) {
                    searchFilter.toString(this.buffer);
                }
                entryIDSet = new EntryIDSet();
            }
        }
        if (this.buffer != null) {
            entryIDSet.toString(this.buffer);
        }
        return entryIDSet;
    }

    private EntryIDSet evaluateLogicalAndFilter(SearchFilter searchFilter) {
        Iterable iterable;
        EntryIDSet entryIDSet = new EntryIDSet();
        ArrayList<SearchFilter> arrayList = new ArrayList<SearchFilter>();
        ArrayList<SearchFilter> arrayList2 = new ArrayList<SearchFilter>();
        HashMap<AttributeType, ArrayList> hashMap = new HashMap<AttributeType, ArrayList>();
        for (SearchFilter object22 : searchFilter.getFilterComponents()) {
            FilterType filterType = object22.getFilterType();
            if (filterType == FilterType.GREATER_OR_EQUAL || filterType == FilterType.LESS_OR_EQUAL) {
                iterable = (ArrayList)hashMap.get(object22.getAttributeType());
                if (iterable == null) {
                    iterable = new ArrayList();
                    hashMap.put(object22.getAttributeType(), (ArrayList)iterable);
                }
                ((ArrayList)iterable).add(object22);
                continue;
            }
            if (filterType == FilterType.EQUALITY || filterType == FilterType.PRESENT || filterType == FilterType.APPROXIMATE_MATCH) {
                arrayList.add(object22);
                continue;
            }
            arrayList2.add(object22);
        }
        for (SearchFilter searchFilter2 : arrayList) {
            EntryIDSet entryIDSet2 = this.evaluateFilter(searchFilter2);
            if (!this.retainAll(entryIDSet, entryIDSet2)) continue;
            return entryIDSet;
        }
        for (SearchFilter searchFilter3 : arrayList2) {
            EntryIDSet entryIDSet3 = this.evaluateFilter(searchFilter3);
            if (!this.retainAll(entryIDSet, entryIDSet3)) continue;
            return entryIDSet;
        }
        if (hashMap.isEmpty()) {
            return entryIDSet;
        }
        ArrayList arrayList3 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            iterable = (ArrayList)entry.getValue();
            if (((ArrayList)iterable).size() == 2) {
                EntryIDSet entryIDSet4;
                SearchFilter searchFilter4 = (SearchFilter)((ArrayList)iterable).get(0);
                SearchFilter searchFilter5 = (SearchFilter)((ArrayList)iterable).get(1);
                AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex((AttributeType)entry.getKey());
                if (attributeIndex == null) continue;
                if (searchFilter4.getFilterType() == FilterType.GREATER_OR_EQUAL && searchFilter5.getFilterType() == FilterType.LESS_OR_EQUAL) {
                    entryIDSet4 = attributeIndex.evaluateBoundedRange(searchFilter4.getAssertionValue(), searchFilter5.getAssertionValue());
                    if (this.buffer != null) {
                        searchFilter4.toString(this.buffer);
                        searchFilter5.toString(this.buffer);
                        entryIDSet4.toString(this.buffer);
                    }
                    if (!this.retainAll(entryIDSet, entryIDSet4)) continue;
                    return entryIDSet;
                }
                if (searchFilter4.getFilterType() == FilterType.LESS_OR_EQUAL && searchFilter5.getFilterType() == FilterType.GREATER_OR_EQUAL) {
                    entryIDSet4 = attributeIndex.evaluateBoundedRange(searchFilter5.getAssertionValue(), searchFilter4.getAssertionValue());
                    if (this.buffer != null) {
                        searchFilter4.toString(this.buffer);
                        searchFilter5.toString(this.buffer);
                        entryIDSet4.toString(this.buffer);
                    }
                    if (!this.retainAll(entryIDSet, entryIDSet4)) continue;
                    return entryIDSet;
                }
            }
            for (SearchFilter searchFilter5 : iterable) {
                arrayList3.add(searchFilter5);
            }
        }
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            SearchFilter searchFilter6 = (SearchFilter)iterator.next();
            iterable = this.evaluateFilter(searchFilter6);
            if (!this.retainAll(entryIDSet, (EntryIDSet)iterable)) continue;
            return entryIDSet;
        }
        return entryIDSet;
    }

    private boolean retainAll(EntryIDSet entryIDSet, EntryIDSet entryIDSet2) {
        entryIDSet.retainAll(entryIDSet2);
        return entryIDSet.isDefined() && entryIDSet.size() <= 10;
    }

    private EntryIDSet evaluateLogicalOrFilter(SearchFilter searchFilter) {
        ArrayList<EntryIDSet> arrayList = new ArrayList<EntryIDSet>(searchFilter.getFilterComponents().size());
        for (SearchFilter searchFilter2 : searchFilter.getFilterComponents()) {
            EntryIDSet entryIDSet = this.evaluateFilter(searchFilter2);
            if (!entryIDSet.isDefined()) {
                return entryIDSet;
            }
            arrayList.add(entryIDSet);
        }
        return EntryIDSet.unionOfSets(arrayList, false);
    }

    private EntryIDSet evaluateEqualityFilter(SearchFilter searchFilter) {
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(searchFilter.getAttributeType());
        EntryIDSet entryIDSet = attributeIndex == null ? new EntryIDSet() : attributeIndex.evaluateEqualityFilter(searchFilter);
        return entryIDSet;
    }

    private EntryIDSet evaluatePresenceFilter(SearchFilter searchFilter) {
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(searchFilter.getAttributeType());
        EntryIDSet entryIDSet = attributeIndex == null ? new EntryIDSet() : attributeIndex.evaluatePresenceFilter(searchFilter);
        return entryIDSet;
    }

    private EntryIDSet evaluateGreaterOrEqualFilter(SearchFilter searchFilter) {
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(searchFilter.getAttributeType());
        EntryIDSet entryIDSet = attributeIndex == null ? new EntryIDSet() : attributeIndex.evaluateGreaterOrEqualFilter(searchFilter);
        return entryIDSet;
    }

    private EntryIDSet evaluateLessOrEqualFilter(SearchFilter searchFilter) {
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(searchFilter.getAttributeType());
        EntryIDSet entryIDSet = attributeIndex == null ? new EntryIDSet() : attributeIndex.evaluateLessOrEqualFilter(searchFilter);
        return entryIDSet;
    }

    private EntryIDSet evaluateSubstringFilter(SearchFilter searchFilter) {
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(searchFilter.getAttributeType());
        EntryIDSet entryIDSet = attributeIndex == null ? new EntryIDSet() : attributeIndex.evaluateSubstringFilter(searchFilter);
        return entryIDSet;
    }
}

