/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.DirectoryThread;
import org.opends.server.changelog.ChangelogCache;
import org.opends.server.changelog.ChangelogDB;
import org.opends.server.changelog.ChangelogDBException;
import org.opends.server.changelog.ServerHandler;
import org.opends.server.changelog.SocketSession;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changelog
implements Runnable,
ConfigurableComponent {
    private static short serverId;
    private static String serverURL;
    private static ServerSocket listenSocket;
    private static Thread myListenThread;
    private static Thread myConnectThread;
    private static boolean runListen;
    private List<String> changelogServers;
    private static HashMap<DN, ChangelogCache> baseDNs;
    private String localhostname = "null";
    private String localURL = "null";
    private static boolean shutdown;
    private short changelogServerId;
    private DN configDn;
    private List<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
    static final String CHANGELOG_SERVER_ATTR = "ds-cfg-changelog-server";
    static final String SERVER_ID_ATTR = "ds-cfg-changelog-server-id";
    static final String CHANGELOG_PORT_ATTR = "ds-cfg-changelog-port";
    static final IntegerConfigAttribute changelogPortStub;
    static final IntegerConfigAttribute serverIdStub;
    static final StringConfigAttribute changelogStub;

    public static boolean checkConfigEntry(ConfigEntry configEntry, StringBuilder stringBuilder) {
        try {
            IntegerConfigAttribute integerConfigAttribute;
            IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(changelogPortStub);
            if (integerConfigAttribute2 == null) {
                stringBuilder.append(MessageHandler.getMessage(16973837, configEntry.getDN().toString()));
            }
            if ((integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(serverIdStub)) == null) {
                stringBuilder.append(MessageHandler.getMessage(0x1030003, configEntry.getDN().toString()));
            }
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    public Changelog(ConfigEntry configEntry) throws ConfigException {
        IntegerConfigAttribute integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(changelogPortStub);
        if (integerConfigAttribute == null) {
            throw new ConfigException(16973837, MessageHandler.getMessage(16973837, configEntry.getDN().toString()));
        }
        int n = integerConfigAttribute.activeIntValue();
        this.configAttributes.add(integerConfigAttribute);
        IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(serverIdStub);
        if (integerConfigAttribute2 == null) {
            throw new ConfigException(0x1030003, MessageHandler.getMessage(0x1030003, configEntry.getDN().toString()));
        }
        this.changelogServerId = (short)integerConfigAttribute2.activeIntValue();
        this.configAttributes.add(integerConfigAttribute2);
        StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(changelogStub);
        this.changelogServers = stringConfigAttribute == null ? new ArrayList<String>() : stringConfigAttribute.activeValues();
        this.configAttributes.add(stringConfigAttribute);
        this.initialize(this.changelogServerId, n, this.changelogServers);
        this.configDn = configEntry.getDN();
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDn;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return this.configAttributes;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        return false;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        return null;
    }

    @Override
    public void run() {
        if (runListen) {
            runListen = false;
            this.runListen();
        } else {
            this.runConnect();
        }
    }

    private void runListen() {
        Socket socket = null;
        while (!shutdown) {
            try {
                socket = listenSocket.accept();
                ServerHandler serverHandler = new ServerHandler(new SocketSession(socket));
                serverHandler.start(null);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConnect() {
        while (!shutdown) {
            for (ChangelogCache changelogCache : baseDNs.values()) {
                Set<String> set = changelogCache.getChangelogs();
                for (String string : this.changelogServers) {
                    if (string.compareTo(this.localURL) == 0 || set.contains(string)) continue;
                    this.connect(string, changelogCache.getBaseDn());
                }
            }
            try {
                Changelog changelog = this;
                synchronized (changelog) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void connect(String string, DN dN) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string2), Integer.parseInt(string3));
            Socket socket = new Socket();
            socket.connect(inetSocketAddress, 500);
            ServerHandler serverHandler = new ServerHandler(new SocketSession(socket));
            serverHandler.start(dN);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initialize(short s, int n, List<String> list) {
        try {
            ChangelogDB.initialize(DirectoryServer.getServerRoot() + File.separator + "changelogDb");
            serverId = s;
            this.localhostname = InetAddress.getLocalHost().getHostName();
            serverURL = this.localhostname + ":" + String.valueOf(n);
            this.localURL = this.localhostname + ":" + String.valueOf(n);
            listenSocket = new ServerSocket(n);
            myListenThread = new DirectoryThread(this, "Changelog Listener");
            myListenThread.start();
            myConnectThread = new DirectoryThread(this, "Changelog Connect");
            myConnectThread.start();
        }
        catch (DatabaseException databaseException) {
            int n2 = 16973834;
            String string = MessageHandler.getMessage(n2, "changelogDb");
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n2);
        }
        catch (ChangelogDBException changelogDBException) {
            int n3 = 16973835;
            String string = MessageHandler.getMessage(n3, "changelogDb");
            string = string + MessageHandler.getMessage(changelogDBException.getMessageID());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n3);
        }
        catch (UnknownHostException unknownHostException) {
            int n4 = 16973829;
            String string = MessageHandler.getMessage(n4);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n4);
        }
        catch (IOException iOException) {
            int n5 = 16973830;
            String string = MessageHandler.getMessage(n5, n, iOException.getMessage());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n5);
        }
    }

    public static short getServerId() {
        return serverId;
    }

    public static String getServerURL() {
        return serverURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChangelogCache getChangelogCache(DN dN) {
        ChangelogCache changelogCache;
        HashMap<DN, ChangelogCache> hashMap = baseDNs;
        synchronized (hashMap) {
            changelogCache = baseDNs.get(dN);
            if (changelogCache == null) {
                changelogCache = new ChangelogCache(dN);
            }
            baseDNs.put(dN, changelogCache);
        }
        return changelogCache;
    }

    public static void shutdown() {
        shutdown = true;
        myConnectThread.interrupt();
        try {
            listenSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ChangelogCache changelogCache : baseDNs.values()) {
            changelogCache.shutdown();
        }
        ChangelogDB.shutdownDbEnvironment();
    }

    static {
        runListen = true;
        baseDNs = new HashMap();
        shutdown = false;
        changelogPortStub = new IntegerConfigAttribute(CHANGELOG_PORT_ATTR, "changelog port", true, false, false, true, 0L, true, 65535L);
        serverIdStub = new IntegerConfigAttribute(SERVER_ID_ATTR, "server ID", true, false, false, true, 0L, true, 65535L);
        changelogStub = new StringConfigAttribute(CHANGELOG_SERVER_ATTR, "changelog server information", true, true, false);
    }
}

