/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.changelog.Changelog;
import org.opends.server.changelog.ChangelogIterator;
import org.opends.server.changelog.DbHandler;
import org.opends.server.changelog.ServerHandler;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.AckMessage;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.ServerState;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelogCache {
    private Object flowControlLock = new Object();
    private DN baseDn = null;
    private Map<Short, ServerHandler> connectedServers = new ConcurrentHashMap<Short, ServerHandler>();
    private Map<Short, ServerHandler> changelogServers = new ConcurrentHashMap<Short, ServerHandler>();
    private Map<Short, DbHandler> sourceDbHandlers = new ConcurrentHashMap<Short, DbHandler>();

    public ChangelogCache(DN dN) {
        this.baseDn = dN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UpdateMessage updateMessage, ServerHandler serverHandler) throws IOException {
        serverHandler.updateServerState(updateMessage);
        serverHandler.incrementInCount();
        if (updateMessage.isAssured()) {
            int n = this.NumServers();
            if (n > 1) {
                if (serverHandler.isChangelogServer()) {
                    ServerHandler.addWaitingAck(updateMessage, serverHandler.getServerId(), this, n - 1);
                } else {
                    serverHandler.addWaitingAck(updateMessage, n - 1);
                }
            } else {
                serverHandler.sendAck(updateMessage.getChangeNumber());
            }
        }
        DbHandler dbHandler = null;
        Object object = this.sourceDbHandlers;
        synchronized (object) {
            short s = updateMessage.getChangeNumber().getServerId();
            dbHandler = this.sourceDbHandlers.get(s);
            if (dbHandler == null) {
                try {
                    dbHandler = new DbHandler(s, this.baseDn);
                }
                catch (DatabaseException databaseException) {
                    int n = 17104922;
                    String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                    Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    Changelog.shutdown();
                    return;
                }
                this.sourceDbHandlers.put(s, dbHandler);
            }
        }
        dbHandler.add(updateMessage);
        object = new HashSet();
        if (!serverHandler.isChangelogServer()) {
            for (ServerHandler object2 : this.changelogServers.values()) {
                object2.add(updateMessage);
                if (!object2.isSaturated(updateMessage.getChangeNumber(), serverHandler)) continue;
                ((HashSet)object).add(object2);
            }
        }
        for (ServerHandler serverHandler2 : this.connectedServers.values()) {
            if (serverHandler2 == serverHandler) continue;
            serverHandler2.add(updateMessage);
            if (!serverHandler2.isSaturated(updateMessage.getChangeNumber(), serverHandler)) continue;
            ((HashSet)object).add(serverHandler2);
        }
        while (!((HashSet)object).isEmpty()) {
            ServerHandler serverHandler3;
            HashSet hashSet = new HashSet();
            Iterator iterator = ((HashSet)object).iterator();
            while (iterator.hasNext()) {
                serverHandler3 = (ServerHandler)iterator.next();
                if (!serverHandler3.restartAfterSaturation(serverHandler)) continue;
                hashSet.add(serverHandler3);
            }
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                serverHandler3 = (ServerHandler)iterator2.next();
                ((HashSet)object).remove(serverHandler3);
            }
            Object object2 = this.flowControlLock;
            synchronized (object2) {
                if (!((HashSet)object).isEmpty()) {
                    try {
                        this.flowControlLock.wait(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(ServerHandler serverHandler) throws Exception {
        Map<Short, ServerHandler> map = this.connectedServers;
        synchronized (map) {
            if (this.connectedServers.containsKey(serverHandler.getServerId())) {
                throw new Exception("serverId already registered");
            }
            this.connectedServers.put(serverHandler.getServerId(), serverHandler);
        }
    }

    public void stopServer(ServerHandler serverHandler) {
        serverHandler.stopHandler();
        if (serverHandler.isChangelogServer()) {
            this.changelogServers.remove(serverHandler.getServerId());
        } else {
            this.connectedServers.remove(serverHandler.getServerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startChangelog(ServerHandler serverHandler) throws Exception {
        Map<Short, ServerHandler> map = this.changelogServers;
        synchronized (map) {
            if (this.changelogServers.containsKey(serverHandler.getServerId())) {
                throw new Exception("changelog Id already registered");
            }
            this.changelogServers.put(serverHandler.getServerId(), serverHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMessage take(ServerHandler serverHandler) {
        UpdateMessage updateMessage = serverHandler.take();
        Object object = this.flowControlLock;
        synchronized (object) {
            if (serverHandler.restartAfterSaturation(null)) {
                this.flowControlLock.notifyAll();
            }
        }
        return updateMessage;
    }

    public Set<String> getChangelogs() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ServerHandler serverHandler : this.changelogServers.values()) {
            linkedHashSet.add(serverHandler.getServerURL());
        }
        return linkedHashSet;
    }

    public Set<Short> getServers() {
        return this.sourceDbHandlers.keySet();
    }

    public ChangelogIterator getChangelogIterator(short s, ChangeNumber changeNumber) {
        DbHandler dbHandler = this.sourceDbHandlers.get(s);
        if (dbHandler == null) {
            return null;
        }
        try {
            return dbHandler.generateIterator(changeNumber);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DN getBaseDn() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDb(short s, DN dN) throws DatabaseException {
        Map<Short, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            this.sourceDbHandlers.put(s, new DbHandler(s, dN));
        }
    }

    private int NumServers() {
        return this.changelogServers.size() + this.connectedServers.size();
    }

    public void ack(AckMessage ackMessage, short s) {
        ServerHandler serverHandler = this.connectedServers.get(ackMessage.getChangeNumber().getServerId());
        if (serverHandler != null) {
            serverHandler.ack(ackMessage, s);
        } else {
            ServerHandler.ackChangelog(ackMessage, s);
        }
    }

    public void sendAck(ChangeNumber changeNumber, boolean bl) {
        short s = changeNumber.getServerId();
        this.sendAck(changeNumber, bl, s);
    }

    public void sendAck(ChangeNumber changeNumber, boolean bl, short s) {
        ServerHandler serverHandler = bl ? this.connectedServers.get(s) : this.changelogServers.get(s);
        try {
            serverHandler.sendAck(changeNumber);
        }
        catch (IOException iOException) {
            int n = 17039393;
            String string = MessageHandler.getMessage(n, this.toString()) + StaticUtils.stackTraceToSingleLineString(iOException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            serverHandler.shutdown();
        }
    }

    public void shutdown() {
        for (ServerHandler runnable : this.changelogServers.values()) {
            runnable.shutdown();
        }
        for (ServerHandler serverHandler : this.connectedServers.values()) {
            serverHandler.shutdown();
        }
        for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
            dbHandler.shutdown();
        }
    }

    public ServerState getDbServerState() {
        ServerState serverState = new ServerState(this.baseDn);
        for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
            serverState.update(dbHandler.getLastChange());
        }
        return serverState;
    }

    public String toString() {
        return "ChangelogCache " + this.baseDn;
    }
}

