/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.ConfigAttribute";
    private boolean hasPendingValues;
    private boolean isMultiValued;
    private boolean isRequired;
    private boolean requiresAdminAction;
    private LinkedHashSet<AttributeValue> activeValues;
    private LinkedHashSet<AttributeValue> pendingValues;
    private String description;
    private String name;

    protected ConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3)));
        this.name = string;
        this.description = string2;
        this.isRequired = bl;
        this.isMultiValued = bl2;
        this.requiresAdminAction = bl3;
        this.hasPendingValues = false;
        this.activeValues = new LinkedHashSet();
        this.pendingValues = this.activeValues;
    }

    protected ConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, LinkedHashSet<AttributeValue> linkedHashSet) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(linkedHashSet)));
        this.name = string;
        this.description = string2;
        this.isRequired = bl;
        this.isMultiValued = bl2;
        this.requiresAdminAction = bl3;
        this.hasPendingValues = false;
        this.activeValues = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
        this.pendingValues = this.activeValues;
    }

    protected ConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, LinkedHashSet<AttributeValue> linkedHashSet, boolean bl4, LinkedHashSet<AttributeValue> linkedHashSet2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(linkedHashSet), String.valueOf(bl4), String.valueOf(linkedHashSet2)));
        this.name = string;
        this.description = string2;
        this.isRequired = bl;
        this.isMultiValued = bl2;
        this.requiresAdminAction = bl3;
        this.hasPendingValues = bl4;
        this.activeValues = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
        this.pendingValues = !bl4 ? this.activeValues : (linkedHashSet2 == null ? new LinkedHashSet() : linkedHashSet2);
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return this.name;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public abstract String getDataType();

    public abstract AttributeSyntax getSyntax();

    public boolean isRequired() {
        assert (Debug.debugEnter(CLASS_NAME, "isRequired", new String[0]));
        return this.isRequired;
    }

    public boolean isMultiValued() {
        assert (Debug.debugEnter(CLASS_NAME, "isMultiValued", new String[0]));
        return this.isMultiValued;
    }

    public boolean requiresAdminAction() {
        assert (Debug.debugEnter(CLASS_NAME, "requiresAdminAction", new String[0]));
        return this.requiresAdminAction;
    }

    public LinkedHashSet<AttributeValue> getActiveValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getActiveValues", new String[0]));
        return this.activeValues;
    }

    public boolean hasPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "hasPendingValues", new String[0]));
        return this.hasPendingValues;
    }

    public LinkedHashSet<AttributeValue> getPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getPendingValues", new String[0]));
        if (this.requiresAdminAction) {
            return this.pendingValues;
        }
        return this.activeValues;
    }

    public abstract boolean valueIsAcceptable(AttributeValue var1, StringBuilder var2);

    protected void setValues(LinkedHashSet<AttributeValue> linkedHashSet) throws ConfigException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "setValues", String.valueOf(linkedHashSet)));
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            if (this.isRequired) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.name);
                throw new ConfigException(n, string);
            }
            if (this.requiresAdminAction) {
                this.pendingValues = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
                this.hasPendingValues = true;
            } else {
                this.activeValues = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
                this.pendingValues = this.activeValues;
                this.hasPendingValues = false;
            }
            return;
        }
        Iterator iterator = linkedHashSet.iterator();
        AttributeValue attributeValue = (AttributeValue)iterator.next();
        if (!this.valueIsAcceptable(attributeValue, stringBuilder = new StringBuilder())) {
            int n = 0x330002;
            String string = MessageHandler.getMessage(n, attributeValue.getStringValue(), this.name, stringBuilder.toString());
            throw new ConfigException(n, string);
        }
        if (!this.isMultiValued && iterator.hasNext()) {
            int n = 0x330003;
            String string = MessageHandler.getMessage(n, this.name);
            throw new ConfigException(n, string);
        }
        while (iterator.hasNext()) {
            attributeValue = (AttributeValue)iterator.next();
            if (this.valueIsAcceptable(attributeValue, stringBuilder)) continue;
            int n = 0x330002;
            String string = MessageHandler.getMessage(n, attributeValue.getStringValue(), this.name, stringBuilder.toString());
            throw new ConfigException(n, string);
        }
        if (this.requiresAdminAction) {
            this.pendingValues = linkedHashSet;
            this.hasPendingValues = true;
        } else {
            this.activeValues = linkedHashSet;
            this.pendingValues = this.activeValues;
            this.hasPendingValues = false;
        }
    }

    protected void setActiveValues(LinkedHashSet<AttributeValue> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "setActiveValues", String.valueOf(linkedHashSet)));
        this.activeValues = linkedHashSet;
    }

    protected void setPendingValues(LinkedHashSet<AttributeValue> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "setPendingValues", String.valueOf(linkedHashSet)));
        this.pendingValues = linkedHashSet;
        this.hasPendingValues = true;
    }

    protected void addValues(List<AttributeValue> list) throws ConfigException {
        LinkedHashSet<AttributeValue> linkedHashSet;
        assert (Debug.debugEnter(CLASS_NAME, "addValues", String.valueOf(list)));
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n == 0) {
            return;
        }
        if (!this.isMultiValued && (n > 1 || this.hasPendingValues && this.pendingValues.size() > 0 || !this.hasPendingValues && this.activeValues.size() > 0)) {
            int n2 = 0x330004;
            String string = MessageHandler.getMessage(n2, this.name);
            throw new ConfigException(n2, string);
        }
        if (this.requiresAdminAction && this.hasPendingValues) {
            linkedHashSet = new LinkedHashSet(this.pendingValues.size() + n);
            linkedHashSet.addAll(this.pendingValues);
        } else {
            linkedHashSet = new LinkedHashSet<AttributeValue>(this.activeValues.size() + n);
            linkedHashSet.addAll(this.activeValues);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (AttributeValue attributeValue : list) {
            if (linkedHashSet.contains(attributeValue)) {
                int n3 = 0x330005;
                String string = MessageHandler.getMessage(n3, this.name, attributeValue.getStringValue());
                throw new ConfigException(n3, string);
            }
            if (this.valueIsAcceptable(attributeValue, stringBuilder)) continue;
            int n4 = 0x330002;
            String string = MessageHandler.getMessage(n4, attributeValue.getStringValue(), this.name, stringBuilder.toString());
            throw new ConfigException(n4, string);
        }
        if (this.requiresAdminAction) {
            this.pendingValues = linkedHashSet;
            this.hasPendingValues = true;
        } else {
            this.activeValues = linkedHashSet;
            this.pendingValues = linkedHashSet;
            this.hasPendingValues = false;
        }
    }

    protected void removeValues(List<AttributeValue> list) throws ConfigException {
        LinkedHashSet<AttributeValue> linkedHashSet;
        assert (Debug.debugEnter(CLASS_NAME, "removeValues", String.valueOf(list)));
        if (this.requiresAdminAction && this.hasPendingValues) {
            linkedHashSet = new LinkedHashSet(this.pendingValues.size());
            linkedHashSet.addAll(this.pendingValues);
        } else {
            linkedHashSet = new LinkedHashSet<AttributeValue>(this.activeValues.size());
            linkedHashSet.addAll(this.activeValues);
        }
        for (AttributeValue object : list) {
            if (linkedHashSet.remove(object)) continue;
            int n = 0x330006;
            String string = MessageHandler.getMessage(n, this.name, object.getStringValue());
            throw new ConfigException(n, string);
        }
        if (this.isRequired && linkedHashSet.isEmpty()) {
            int n = 0x330001;
            String string = MessageHandler.getMessage(n, this.name);
            throw new ConfigException(n, string);
        }
        if (this.requiresAdminAction) {
            this.pendingValues = linkedHashSet;
            this.hasPendingValues = true;
        } else {
            this.activeValues = linkedHashSet;
            this.pendingValues = linkedHashSet;
            this.hasPendingValues = false;
        }
    }

    protected void removeAllValues() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "removeAllValues", new String[0]));
        if (this.isRequired) {
            int n = 0x330001;
            String string = MessageHandler.getMessage(n, this.name);
            throw new ConfigException(n, string);
        }
        if (this.requiresAdminAction) {
            if (this.pendingValues == null) {
                this.pendingValues = new LinkedHashSet();
            } else {
                this.pendingValues.clear();
            }
            this.hasPendingValues = true;
        } else {
            this.activeValues.clear();
            this.pendingValues = this.activeValues;
            this.hasPendingValues = false;
        }
    }

    public void setInitialValues(LinkedHashSet<AttributeValue> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "setInitialValues", new String[0]));
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
        }
        this.activeValues = linkedHashSet;
        this.pendingValues = linkedHashSet;
        this.hasPendingValues = false;
    }

    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
        if (this.hasPendingValues) {
            this.activeValues = this.pendingValues;
            this.hasPendingValues = false;
        }
    }

    public abstract LinkedHashSet<AttributeValue> stringsToValues(List<String> var1, boolean var2) throws ConfigException;

    public abstract List<String> activeValuesToStrings();

    public abstract List<String> pendingValuesToStrings();

    public abstract ConfigAttribute getConfigAttribute(List<Attribute> var1) throws ConfigException;

    public abstract javax.management.Attribute toJMXAttribute();

    public abstract javax.management.Attribute toJMXAttributePending();

    public abstract void toJMXAttribute(AttributeList var1);

    public abstract void toJMXAttributeInfo(List<MBeanAttributeInfo> var1);

    public abstract MBeanParameterInfo toJMXParameterInfo();

    public abstract void setValue(javax.management.Attribute var1) throws ConfigException;

    public abstract ConfigAttribute duplicate();
}

