/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

public class EntryChangeNotificationControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.EntryChangeNotificationControl";
    private DN previousDN;
    private long changeNumber;
    private PersistentSearchChangeType changeType;

    public EntryChangeNotificationControl(PersistentSearchChangeType persistentSearchChangeType, long l) {
        super("2.16.840.1.113730.3.4.7", false, EntryChangeNotificationControl.encodeValue(persistentSearchChangeType, null, l));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)persistentSearchChangeType), String.valueOf(l)));
        this.changeType = persistentSearchChangeType;
        this.changeNumber = l;
        this.previousDN = null;
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType persistentSearchChangeType, DN dN, long l) {
        super("2.16.840.1.113730.3.4.7", false, EntryChangeNotificationControl.encodeValue(persistentSearchChangeType, dN, l));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)persistentSearchChangeType), String.valueOf(dN), String.valueOf(l)));
        this.changeType = persistentSearchChangeType;
        this.previousDN = dN;
        this.changeNumber = l;
    }

    public EntryChangeNotificationControl(String string, boolean bl, PersistentSearchChangeType persistentSearchChangeType, DN dN, long l) {
        super(string, bl, EntryChangeNotificationControl.encodeValue(persistentSearchChangeType, dN, l));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf((Object)persistentSearchChangeType), String.valueOf(dN), String.valueOf(l)));
        this.changeType = persistentSearchChangeType;
        this.previousDN = dN;
        this.changeNumber = l;
    }

    private EntryChangeNotificationControl(String string, boolean bl, PersistentSearchChangeType persistentSearchChangeType, DN dN, long l, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf((Object)persistentSearchChangeType), String.valueOf(dN), String.valueOf(l), String.valueOf(aSN1OctetString)));
        this.changeType = persistentSearchChangeType;
        this.previousDN = dN;
        this.changeNumber = l;
    }

    private static ASN1OctetString encodeValue(PersistentSearchChangeType persistentSearchChangeType, DN dN, long l) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf((Object)persistentSearchChangeType), String.valueOf(dN), String.valueOf(l)));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
        arrayList.add(new ASN1Enumerated(persistentSearchChangeType.intValue()));
        if (dN != null) {
            arrayList.add(new ASN1OctetString(dN.toString()));
        }
        if (l > 0L) {
            arrayList.add(new ASN1Long(l));
        }
        return new ASN1OctetString(new ASN1Sequence(arrayList).encode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EntryChangeNotificationControl decodeControl(Control control) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294068;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        DN dN = null;
        long l = -1L;
        try {
            ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            if (arrayList.size() < 1 || arrayList.size() > 3) {
                int n = 2294069;
                String string = MessageHandler.getMessage(n, arrayList.size());
                throw new LDAPException(2, n, string);
            }
            int n = arrayList.get(0).decodeAsEnumerated().intValue();
            PersistentSearchChangeType persistentSearchChangeType = PersistentSearchChangeType.valueOf(n);
            if (arrayList.size() == 2) {
                ASN1Element aSN1Element = arrayList.get(1);
                if (aSN1Element.getType() == 4) {
                    if (persistentSearchChangeType != PersistentSearchChangeType.MODIFY_DN) {
                        int n2 = 2294070;
                        String string = MessageHandler.getMessage(n2, String.valueOf((Object)persistentSearchChangeType));
                        throw new LDAPException(2, n2, string);
                    }
                    ASN1OctetString aSN1OctetString = aSN1Element.decodeAsOctetString();
                    dN = DN.decode(aSN1OctetString);
                    return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), persistentSearchChangeType, dN, l, control.getValue());
                }
                if (aSN1Element.getType() == 2) {
                    l = aSN1Element.decodeAsLong().longValue();
                    return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), persistentSearchChangeType, dN, l, control.getValue());
                }
                int n3 = 2294071;
                String string = MessageHandler.getMessage(n3, StaticUtils.byteToHex(aSN1Element.getType()));
                throw new LDAPException(2, n3, string);
            }
            if (arrayList.size() != 3) return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), persistentSearchChangeType, dN, l, control.getValue());
            if (persistentSearchChangeType != PersistentSearchChangeType.MODIFY_DN) {
                int n4 = 2294070;
                String string = MessageHandler.getMessage(n4, String.valueOf((Object)persistentSearchChangeType));
                throw new LDAPException(2, n4, string);
            }
            ASN1OctetString aSN1OctetString = arrayList.get(1).decodeAsOctetString();
            dN = DN.decode(aSN1OctetString);
            l = arrayList.get(2).decodeAsLong().longValue();
            return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), persistentSearchChangeType, dN, l, control.getValue());
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2294072;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string, exception);
        }
    }

    public PersistentSearchChangeType getChangeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeType", new String[0]));
        return this.changeType;
    }

    public void setChangeType(PersistentSearchChangeType persistentSearchChangeType) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangeType", String.valueOf((Object)persistentSearchChangeType)));
        this.changeType = persistentSearchChangeType;
        this.setValue(EntryChangeNotificationControl.encodeValue(persistentSearchChangeType, this.previousDN, this.changeNumber));
    }

    public DN getPreviousDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getPreviousDN", new String[0]));
        return this.previousDN;
    }

    public void setPreviousDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setPreviousDN", String.valueOf(dN)));
        this.previousDN = dN;
        this.setValue(EntryChangeNotificationControl.encodeValue(this.changeType, dN, this.changeNumber));
    }

    public long getChangeNumber() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeNumber", new String[0]));
        return this.changeNumber;
    }

    public void setChangeNumber(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangeNumber", String.valueOf(l)));
        this.changeNumber = l;
        this.setValue(EntryChangeNotificationControl.encodeValue(this.changeType, this.previousDN, l));
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("EntryChangeNotificationControl(changeType=");
        stringBuilder.append(this.changeType.toString());
        if (this.previousDN != null) {
            stringBuilder.append(",previousDN=\"");
            stringBuilder.append(this.previousDN.toString());
            stringBuilder.append("\"");
        }
        if (this.changeNumber > 0L) {
            stringBuilder.append(",changeNumber=");
            stringBuilder.append(this.changeNumber);
        }
        stringBuilder.append(")");
    }
}

