/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPreReadRequestControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.LDAPPreReadRequestControl";
    private boolean returnAllOperationalAttrs;
    private boolean returnAllUserAttrs;
    private LinkedHashSet<String> rawAttributes;
    private LinkedHashSet<AttributeType> requestedAttributes;

    public LDAPPreReadRequestControl(boolean bl, LinkedHashSet<String> linkedHashSet) {
        super("1.3.6.1.1.13.1", bl, LDAPPreReadRequestControl.encodeAttributes(linkedHashSet));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl), String.valueOf(linkedHashSet)));
        this.rawAttributes = linkedHashSet == null ? new LinkedHashSet(0) : linkedHashSet;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    public LDAPPreReadRequestControl(String string, boolean bl, LinkedHashSet<String> linkedHashSet) {
        super(string, bl, LDAPPreReadRequestControl.encodeAttributes(linkedHashSet));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(linkedHashSet)));
        this.rawAttributes = linkedHashSet == null ? new LinkedHashSet(0) : linkedHashSet;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    private LDAPPreReadRequestControl(String string, boolean bl, LinkedHashSet<String> linkedHashSet, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(linkedHashSet), String.valueOf(aSN1OctetString)));
        this.rawAttributes = linkedHashSet == null ? new LinkedHashSet(0) : linkedHashSet;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    public static LDAPPreReadRequestControl decodeControl(Control control) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294045;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        try {
            ASN1Sequence aSN1Sequence = ASN1Sequence.decodeAsSequence(control.getValue().value());
            for (ASN1Element aSN1Element : aSN1Sequence.elements()) {
                linkedHashSet.add(aSN1Element.decodeAsOctetString().stringValue());
            }
        }
        catch (ASN1Exception aSN1Exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", aSN1Exception));
            int n = 2294046;
            String string = MessageHandler.getMessage(n, aSN1Exception.getMessage());
            throw new LDAPException(2, n, string, aSN1Exception);
        }
        return new LDAPPreReadRequestControl(control.getOID(), control.isCritical(), linkedHashSet, control.getValue());
    }

    private static ASN1OctetString encodeAttributes(LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeAttributes", String.valueOf(linkedHashSet)));
        if (linkedHashSet == null) {
            return new ASN1OctetString(new ASN1Sequence().encode());
        }
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(linkedHashSet.size());
        for (String string : linkedHashSet) {
            arrayList.add(new ASN1OctetString(string));
        }
        return new ASN1OctetString(new ASN1Sequence(arrayList).encode());
    }

    public LinkedHashSet<String> getRawAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawAttributes", new String[0]));
        return this.rawAttributes;
    }

    public void setRawAttributes(LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawAttributes", String.valueOf(linkedHashSet)));
        this.rawAttributes = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
        this.setValue(LDAPPreReadRequestControl.encodeAttributes(linkedHashSet));
        this.requestedAttributes = null;
    }

    public LinkedHashSet<AttributeType> getRequestedAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestedAttributes", new String[0]));
        if (this.requestedAttributes == null) {
            this.returnAllOperationalAttrs = false;
            this.returnAllUserAttrs = this.rawAttributes.size() == 0;
            this.requestedAttributes = new LinkedHashSet(this.rawAttributes.size());
            for (String string : this.rawAttributes) {
                Object object;
                if ((string = string.toLowerCase()).equals("*")) {
                    this.returnAllUserAttrs = true;
                    continue;
                }
                if (string.equals("+")) {
                    this.returnAllOperationalAttrs = true;
                    continue;
                }
                if (string.startsWith("@")) {
                    object = string.substring(1);
                    ObjectClass objectClass = DirectoryServer.getObjectClass((String)object);
                    if (objectClass == null) continue;
                    this.requestedAttributes.addAll(objectClass.getOptionalAttributeChain());
                    this.requestedAttributes.addAll(objectClass.getRequiredAttributeChain());
                    continue;
                }
                object = DirectoryServer.getAttributeType(string);
                if (object == null) {
                    object = DirectoryServer.getDefaultAttributeType(string);
                }
                this.requestedAttributes.add((AttributeType)object);
            }
        }
        return this.requestedAttributes;
    }

    public boolean returnAllUserAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "returnAllUserAttributes", new String[0]));
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        return this.returnAllUserAttrs;
    }

    public boolean returnAllOperationalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "returnAllOperationalAttributes", new String[0]));
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        return this.returnAllOperationalAttrs;
    }

    public boolean allowsAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "allowsAttribute", String.valueOf(attributeType)));
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        if (this.requestedAttributes.contains(attributeType)) {
            return true;
        }
        if (attributeType.isOperational()) {
            return this.returnAllOperationalAttrs;
        }
        return this.returnAllUserAttrs;
    }

    @Override
    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPPreReadRequestControl(criticality=");
        stringBuilder.append(this.isCritical());
        stringBuilder.append(",attrs=\"");
        if (!this.rawAttributes.isEmpty()) {
            Iterator iterator = this.rawAttributes.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                stringBuilder.append((String)iterator.next());
            }
        }
        stringBuilder.append("\")");
    }
}

