/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.opends.server.api.AccessControlHandler;
import org.opends.server.api.AccessControlProvider;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DefaultAccessControlProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public final class AccessControlConfigManager {
    private static final String CLASS_NAME = "org.opends.server.core.AccessControlConfigManager";
    private static AccessControlConfigManager instance = null;
    private AtomicReference<AccessControlProvider> accessControlProvider;
    private Configuration currentConfiguration;

    public static AccessControlConfigManager getInstance() {
        assert (Debug.debugEnter(CLASS_NAME, "getInstance", new String[0]));
        if (instance == null) {
            instance = new AccessControlConfigManager();
        }
        return instance;
    }

    public boolean isAccessControlEnabled() {
        assert (Debug.debugEnter(CLASS_NAME, "isEnabled", new String[0]));
        return this.currentConfiguration.isEnabled();
    }

    public AccessControlHandler getAccessControlHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getAccessControlHandler", new String[0]));
        return this.accessControlProvider.get().getInstance();
    }

    void initializeAccessControl() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "initializeAccessControl", new String[0]));
        try {
            object = DN.decode("cn=Access Control Handler,cn=config");
            configEntry = DirectoryServer.getConfigEntry((DN)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeAccessControlConfigManager", exception));
            int n = 3473927;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3473928;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        object = Configuration.readConfiguration(configEntry);
        configEntry.registerChangeListener(new ChangeListener());
        this.updateConfiguration((Configuration)object);
    }

    private AccessControlConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.accessControlProvider = new AtomicReference<DefaultAccessControlProvider>(new DefaultAccessControlProvider());
        this.currentConfiguration = null;
    }

    private void updateConfiguration(Configuration configuration) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "updateConfiguration", new String[0]));
        DN dN = configuration.getConfigEntry().getDN();
        Class clazz = null;
        if (this.currentConfiguration == null) {
            clazz = configuration.isEnabled() ? configuration.getProviderClass() : DefaultAccessControlProvider.class;
        } else {
            boolean bl = this.currentConfiguration.isEnabled();
            boolean bl2 = configuration.isEnabled();
            if (!bl && bl2) {
                clazz = configuration.getProviderClass();
            } else if (bl && !bl2) {
                clazz = DefaultAccessControlProvider.class;
            } else if (bl2 && !this.currentConfiguration.getProviderClass().equals(configuration.getProviderClass())) {
                clazz = configuration.getProviderClass();
            }
        }
        if (clazz != null) {
            AccessControlProvider accessControlProvider;
            try {
                accessControlProvider = (AccessControlProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "updateConfiguration", exception));
                int n = 3473941;
                String string = MessageHandler.getMessage(n, clazz.getName(), String.valueOf(dN.toString()), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            accessControlProvider.initializeAccessControlHandler(configuration.getConfigEntry());
            AccessControlProvider accessControlProvider2 = this.accessControlProvider.getAndSet(accessControlProvider);
            if (accessControlProvider2 != null) {
                accessControlProvider2.finalizeAccessControlHandler();
            }
            if (clazz.equals(DefaultAccessControlProvider.class)) {
                int n = 3277325;
                String string = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
            } else {
                int n = 3605006;
                String string = MessageHandler.getMessage(n, clazz.getName());
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.NOTICE, string, n);
            }
        }
        this.currentConfiguration = configuration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Configuration {
        private static final String CLASS_NAME = "org.opends.server.core.AccessControlConfigManager.Configuration";
        private boolean enabled;
        private Class<? extends AccessControlProvider> providerClass;
        private ConfigEntry configEntry;

        public static Configuration readConfiguration(ConfigEntry configEntry) throws ConfigException {
            assert (Debug.debugEnter(CLASS_NAME, "createConfiguration", new String[0]));
            if (!configEntry.hasObjectClass("ds-cfg-access-control-handler")) {
                int n = 3473929;
                String string = MessageHandler.getMessage(n, configEntry.toString());
                throw new ConfigException(n, string);
            }
            boolean bl = Configuration.getEnabledAttribute(configEntry);
            Class<? extends AccessControlProvider> clazz = Configuration.getClassAttribute(configEntry);
            return new Configuration(configEntry, bl, clazz);
        }

        public boolean isEnabled() {
            assert (Debug.debugEnter(CLASS_NAME, "isEnabled", new String[0]));
            return this.enabled;
        }

        public Class<? extends AccessControlProvider> getProviderClass() {
            assert (Debug.debugEnter(CLASS_NAME, "getProviderClass", new String[0]));
            return this.providerClass;
        }

        public ConfigEntry getConfigEntry() {
            assert (Debug.debugEnter(CLASS_NAME, "getConfigEntry", new String[0]));
            return this.configEntry;
        }

        private Configuration(ConfigEntry configEntry, boolean bl, Class<? extends AccessControlProvider> clazz) {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.configEntry = configEntry;
            this.enabled = bl;
            this.providerClass = clazz;
        }

        private static boolean getEnabledAttribute(ConfigEntry configEntry) throws ConfigException {
            assert (Debug.debugEnter(CLASS_NAME, "getEnabledAttribute", new String[0]));
            try {
                BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-acl-handler-enabled", MessageHandler.getMessage(3146251), false);
                BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                if (booleanConfigAttribute2 == null) {
                    int n = 3473932;
                    String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, string);
                }
                return booleanConfigAttribute2.activeValue();
            }
            catch (ConfigException configException) {
                int n = 3473935;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(configException));
                throw new ConfigException(n, string, configException);
            }
        }

        private static Class<? extends AccessControlProvider> getClassAttribute(ConfigEntry configEntry) throws ConfigException {
            assert (Debug.debugEnter(CLASS_NAME, "getClassAttribute", new String[0]));
            try {
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-acl-handler-class", MessageHandler.getMessage(3146256), true, false, false);
                StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute2 == null) {
                    int n = 3473937;
                    String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, string);
                }
                String string = stringConfigAttribute2.activeValue();
                try {
                    return Class.forName(string).asSubclass(AccessControlProvider.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    assert (Debug.debugException(CLASS_NAME, "updateConfiguration", classNotFoundException));
                    int n = 3473939;
                    String string2 = MessageHandler.getMessage(n, string, String.valueOf(configEntry.getDN().toString()), StaticUtils.stackTraceToSingleLineString(classNotFoundException));
                    throw new ConfigException(n, string2, classNotFoundException);
                }
                catch (ClassCastException classCastException) {
                    assert (Debug.debugException(CLASS_NAME, "updateConfiguration", classCastException));
                    int n = 3473940;
                    String string3 = MessageHandler.getMessage(n, string, String.valueOf(configEntry.getDN().toString()), AccessControlProvider.class.getName(), StaticUtils.stackTraceToSingleLineString(classCastException));
                    throw new ConfigException(n, string3, classCastException);
                }
            }
            catch (ConfigException configException) {
                int n = 3473938;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(configException));
                throw new ConfigException(n, string, configException);
            }
        }
    }

    private class ChangeListener
    implements ConfigChangeListener {
        private static final String CLASS_NAME = "org.opends.server.core.AccessControlConfigManager.ChangeListener";

        private ChangeListener() {
        }

        public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
            assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", new String[0]));
            try {
                Configuration.readConfiguration(configEntry);
            }
            catch (ConfigException configException) {
                stringBuilder.append(configException.getMessage());
                return false;
            }
            return true;
        }

        public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            ResultCode resultCode = ResultCode.SUCCESS;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                Configuration configuration = Configuration.readConfiguration(configEntry);
                AccessControlConfigManager.this.updateConfiguration(configuration);
            }
            catch (ConfigException configException) {
                arrayList.add(configException.getMessage());
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            catch (InitializationException initializationException) {
                arrayList.add(initializationException.getMessage());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            return new ConfigChangeResult(resultCode, false, arrayList);
        }
    }
}

