/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.AddOperation";
    private ArrayList<Control> responseControls;
    private ByteString rawEntryDN;
    private CancelRequest cancelRequest;
    private DN entryDN;
    private Entry entry;
    private List<LDAPAttribute> rawAttributes;
    private Map<AttributeType, List<Attribute>> operationalAttributes;
    private Map<AttributeType, List<Attribute>> userAttributes;
    private Map<ObjectClass, String> objectClasses;
    private long changeNumber;
    private long processingStartTime;
    private long processingStopTime;

    public AddOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, List<LDAPAttribute> list2) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf(list2)));
        this.rawEntryDN = byteString;
        this.rawAttributes = list2;
        this.responseControls = new ArrayList();
        this.cancelRequest = null;
        this.entry = null;
        this.entryDN = null;
        this.userAttributes = null;
        this.operationalAttributes = null;
        this.objectClasses = null;
        this.changeNumber = -1L;
    }

    public AddOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, Map<ObjectClass, String> map, Map<AttributeType, List<Attribute>> map2, Map<AttributeType, List<Attribute>> map3) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(this.rawEntryDN), String.valueOf(this.rawAttributes)));
        this.entryDN = dN;
        this.objectClasses = map;
        this.userAttributes = map2;
        this.operationalAttributes = map3;
        this.entry = null;
        this.rawEntryDN = new ASN1OctetString(dN.toString());
        this.rawAttributes = new ArrayList<LDAPAttribute>();
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>();
        for (String iterator : map.values()) {
            arrayList.add(new ASN1OctetString(iterator));
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute("objectClass", arrayList);
        this.rawAttributes.add(lDAPAttribute);
        for (List<Attribute> list2 : map2.values()) {
            for (Attribute attribute : list2) {
                this.rawAttributes.add(new LDAPAttribute(attribute));
            }
        }
        for (List<Attribute> list2 : map3.values()) {
            for (Attribute attribute : list2) {
                this.rawAttributes.add(new LDAPAttribute(attribute));
            }
        }
        this.responseControls = new ArrayList();
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    public ByteString getRawEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawEntryDN", new String[0]));
        return this.rawEntryDN;
    }

    public void setRawEntryDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawEntryDN", String.valueOf(byteString)));
        this.rawEntryDN = byteString;
        this.entryDN = null;
    }

    public DN getEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryDN", new String[0]));
        return this.entryDN;
    }

    public void setEntryDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setEntryDN", String.valueOf(dN)));
        this.entryDN = dN;
    }

    public List<LDAPAttribute> getRawAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawAttributes", new String[0]));
        return this.rawAttributes;
    }

    public void addRawAttribute(LDAPAttribute lDAPAttribute) {
        assert (Debug.debugEnter(CLASS_NAME, "addRawAttribute", String.valueOf(lDAPAttribute)));
        this.rawAttributes.add(lDAPAttribute);
        this.objectClasses = null;
        this.userAttributes = null;
        this.operationalAttributes = null;
    }

    public void setRawAttributes(List<LDAPAttribute> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawAttributes", String.valueOf(list)));
        this.rawAttributes = list;
        this.objectClasses = null;
        this.userAttributes = null;
        this.operationalAttributes = null;
    }

    public Map<ObjectClass, String> getObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClasses", new String[0]));
        return this.objectClasses;
    }

    public Map<AttributeType, List<Attribute>> getUserAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserAttributes", new String[0]));
        return this.userAttributes;
    }

    public Map<AttributeType, List<Attribute>> getOperationalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationalAttributes", new String[0]));
        return this.operationalAttributes;
    }

    public Entry getEntryToAdd() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryToAdd", new String[0]));
        return this.entry;
    }

    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    public long getChangeNumber() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeNumber", new String[0]));
        return this.changeNumber;
    }

    public void setChangeNumber(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangeNumber", String.valueOf(l)));
        this.changeNumber = l;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.ADD;
    }

    @Override
    public String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}};
    }

    @Override
    public String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"processingTime", charSequence}};
    }

    public ArrayList<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 381[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addObjectClassChain(ObjectClass objectClass) {
        ObjectClass objectClass2;
        assert (Debug.debugEnter(CLASS_NAME, "addObjectClassChain", String.valueOf(objectClass)));
        if (!this.objectClasses.containsKey(objectClass)) {
            this.objectClasses.put(objectClass, objectClass.getNameOrOID());
        }
        if ((objectClass2 = objectClass.getSuperiorClass()) != null && !this.objectClasses.containsKey(objectClass2)) {
            this.addObjectClassChain(objectClass2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handlePasswordPolicy(PasswordPolicy passwordPolicy, Entry entry) throws DirectoryException {
        void var10_19;
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "handlePasswordPolicy", String.valueOf(passwordPolicy), String.valueOf(entry)));
        AttributeType attributeType = passwordPolicy.getPasswordAttribute();
        List<Attribute> list = entry.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            int n = 197104;
            String string = MessageHandler.getMessage(n, attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        Attribute attribute = list.get(0);
        if (attribute.hasOptions()) {
            int n = 197104;
            String string = MessageHandler.getMessage(n, attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet.isEmpty()) {
            return;
        }
        if (!passwordPolicy.allowMultiplePasswordValues() && linkedHashSet.size() > 1) {
            int n = 197105;
            String string = MessageHandler.getMessage(n, attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        CopyOnWriteArrayList<PasswordStorageScheme> copyOnWriteArrayList = passwordPolicy.getDefaultStorageSchemes();
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(copyOnWriteArrayList.size());
        for (AttributeValue object52 : linkedHashSet) {
            object2 = object52.getValue();
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                if (AuthPasswordSyntax.isEncoded((ByteString)object2)) {
                    if (passwordPolicy.allowPreEncodedPasswords()) {
                        linkedHashSet2.add(object52);
                        continue;
                    }
                    int n = 197106;
                    String string = MessageHandler.getMessage(n, attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
            } else if (UserPasswordSyntax.isEncoded((ByteString)object2)) {
                if (passwordPolicy.allowPreEncodedPasswords()) {
                    linkedHashSet2.add(object52);
                    continue;
                }
                int n = 197106;
                String string = MessageHandler.getMessage(n, attributeType.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
            }
            if (!passwordPolicy.skipValidationForAdministrators()) {
                object = new StringBuilder();
                for (PasswordValidator passwordValidator : passwordPolicy.getPasswordValidators().values()) {
                    if (passwordValidator.passwordIsValid((ByteString)object2, this, entry, (StringBuilder)object)) continue;
                    int n = 197107;
                    String string = MessageHandler.getMessage(n, attributeType.getNameOrOID(), String.valueOf(object));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
            }
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                for (PasswordStorageScheme passwordStorageScheme : copyOnWriteArrayList) {
                    ByteString byteString = passwordStorageScheme.encodeAuthPassword((ByteString)object2);
                    linkedHashSet2.add(new AttributeValue(attributeType, byteString));
                }
                continue;
            }
            for (PasswordStorageScheme passwordStorageScheme : copyOnWriteArrayList) {
                ByteString byteString = passwordStorageScheme.encodePasswordWithScheme((ByteString)object2);
                linkedHashSet2.add(new AttributeValue(attributeType, byteString));
            }
        }
        attribute.setValues(linkedHashSet2);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(TimeThread.getGeneralizedTime());
        AttributeType attributeType2 = DirectoryServer.getAttributeType("pwdchangedtime");
        if (attributeType2 == null) {
            AttributeType attributeType3 = DirectoryServer.getDefaultAttributeType("pwdChangedTime");
        }
        object2 = new LinkedHashSet(1);
        ((HashSet)object2).add(new AttributeValue((AttributeType)var10_19, (ByteString)aSN1OctetString));
        object = new ArrayList(1);
        ((ArrayList)object).add(new Attribute((AttributeType)var10_19, "pwdChangedTime", (LinkedHashSet<AttributeValue>)object2));
        entry.putAttribute((AttributeType)var10_19, (List<Attribute>)object);
        if (passwordPolicy.forceChangeOnAdd()) {
            void var13_32;
            AttributeType attributeType4 = DirectoryServer.getAttributeType("pwdreset");
            if (attributeType4 == null) {
                AttributeType attributeType5 = DirectoryServer.getDefaultAttributeType("pwdReset");
            }
            LinkedHashSet<AttributeValue> linkedHashSet3 = new LinkedHashSet<AttributeValue>(1);
            linkedHashSet3.add(new AttributeValue((AttributeType)var13_32, (ByteString)aSN1OctetString));
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(new Attribute((AttributeType)var13_32, "pwdReset", linkedHashSet3));
            entry.putAttribute((AttributeType)var13_32, arrayList);
        }
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long l = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < l) {
            block5: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancel", exception)) break block5;
                    throw new AssertionError();
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return this.cancelRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AddOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", dn=");
        stringBuilder.append(this.rawEntryDN);
        stringBuilder.append(")");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$AcceptRejectWarn;
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$WritabilityMode;

        static {
            $SwitchMap$org$opends$server$types$WritabilityMode = new int[WritabilityMode.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$WritabilityMode[WritabilityMode.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$WritabilityMode[WritabilityMode.INTERNAL_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$org$opends$server$types$AcceptRejectWarn = new int[AcceptRejectWarn.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$AcceptRejectWarn[AcceptRejectWarn.REJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$AcceptRejectWarn[AcceptRejectWarn.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

