/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SimpleSubtreeSpecification;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RFC3672SubtreeSpecification
extends SimpleSubtreeSpecification {
    private static final String CLASS_NAME = RFC3672SubtreeSpecification.class.getName();
    private DN rootDN;
    private DN relativeBaseDN;
    private Refinement refinements;

    public static RFC3672SubtreeSpecification valueOf(DN dN, String string) throws DirectoryException {
        String string2;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "valueOf", new String[0]));
        DN dN2 = null;
        int n2 = -1;
        int n3 = -1;
        HashSet<DN> hashSet = new HashSet<DN>();
        HashSet<DN> hashSet2 = new HashSet<DN>();
        Refinement refinement = null;
        SimpleSubtreeSpecification.Parser parser = new SimpleSubtreeSpecification.Parser(string);
        boolean bl = true;
        try {
            block21: {
                parser.skipLeftBrace();
                n = 1;
                while (true) {
                    if (parser.hasNextRightBrace()) {
                        parser.skipRightBrace();
                        if (parser.hasNext()) {
                            throw new InputMismatchException();
                        }
                        break block21;
                    }
                    if (n == 0) {
                        parser.skipSeparator();
                    } else {
                        n = 0;
                    }
                    string2 = parser.nextKey();
                    if (string2.equals("base")) {
                        if (dN2 != null) {
                            throw new InputMismatchException();
                        }
                        dN2 = DN.decode(parser.nextStringValue());
                        continue;
                    }
                    if (string2.equals("minimum")) {
                        if (n2 != -1) {
                            throw new InputMismatchException();
                        }
                        n2 = parser.nextInt();
                        continue;
                    }
                    if (string2.equals("maximum")) {
                        if (n3 != -1) {
                            throw new InputMismatchException();
                        }
                        n3 = parser.nextInt();
                        continue;
                    }
                    if (string2.equals("specificationfilter")) {
                        if (refinement != null) {
                            throw new InputMismatchException();
                        }
                        refinement = RFC3672SubtreeSpecification.parseRefinement(parser);
                        continue;
                    }
                    if (!string2.equals("specificexclusions")) break;
                    if (!hashSet.isEmpty() || !hashSet2.isEmpty()) {
                        throw new InputMismatchException();
                    }
                    parser.nextSpecificExclusions(hashSet, hashSet2);
                }
                throw new InputMismatchException();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 >= 0 && n3 < n2) {
                bl = false;
            }
        }
        catch (InputMismatchException inputMismatchException) {
            bl = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
        }
        if (bl) {
            return new RFC3672SubtreeSpecification(dN, dN2, n2, n3, hashSet, hashSet2, refinement);
        }
        n = 6488321;
        string2 = MessageHandler.getMessage(n, string);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
    }

    private static Refinement parseRefinement(SimpleSubtreeSpecification.Parser parser) throws InputMismatchException, NoSuchElementException {
        String string = StaticUtils.toLowerCase(parser.nextName());
        parser.skipColon();
        if (string.equals("item")) {
            return new ItemRefinement(parser.nextName());
        }
        if (string.equals("not")) {
            Refinement refinement = RFC3672SubtreeSpecification.parseRefinement(parser);
            return new NotRefinement(refinement);
        }
        if (string.equals("and")) {
            ArrayList<Refinement> arrayList = RFC3672SubtreeSpecification.parseRefinementSet(parser);
            return new AndRefinement(arrayList);
        }
        if (string.equals("or")) {
            ArrayList<Refinement> arrayList = RFC3672SubtreeSpecification.parseRefinementSet(parser);
            return new OrRefinement(arrayList);
        }
        throw new InputMismatchException();
    }

    private static ArrayList<Refinement> parseRefinementSet(SimpleSubtreeSpecification.Parser parser) throws InputMismatchException, NoSuchElementException {
        ArrayList<Refinement> arrayList = new ArrayList<Refinement>();
        parser.skipLeftBrace();
        boolean bl = true;
        while (true) {
            if (parser.hasNextRightBrace()) break;
            if (!bl) {
                parser.skipSeparator();
            } else {
                bl = false;
            }
            Refinement refinement = RFC3672SubtreeSpecification.parseRefinement(parser);
            arrayList.add(refinement);
        }
        parser.skipRightBrace();
        return arrayList;
    }

    public RFC3672SubtreeSpecification(DN dN, DN dN2, int n, int n2, Iterable<DN> iterable, Iterable<DN> iterable2, Refinement refinement) {
        super(dN2 == null ? dN : new DN(dN, dN2), n, n2, iterable, iterable2);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.rootDN = dN;
        this.relativeBaseDN = dN2;
        this.refinements = refinement;
    }

    public DN getRootDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootDN", new String[0]));
        return this.rootDN;
    }

    public DN getRelativeBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRelativeBaseDN", new String[0]));
        return this.relativeBaseDN;
    }

    public Refinement getRefinements() {
        assert (Debug.debugEnter(CLASS_NAME, "getRefinements", new String[0]));
        return this.refinements;
    }

    @Override
    public boolean isWithinScope(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "isWithinScope", new String[0]));
        if (this.isDNWithinScope(entry.getDN())) {
            if (this.refinements != null) {
                return this.refinements.matches(entry);
            }
            return true;
        }
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        boolean bl = true;
        stringBuilder.append("{");
        if (this.relativeBaseDN != null && !this.relativeBaseDN.isNullDN()) {
            stringBuilder.append(" base ");
            StaticUtils.toRFC3641StringValue(stringBuilder, this.relativeBaseDN.toString());
            bl = false;
        }
        Iterable<DN> iterable = this.getChopBefore();
        Iterable<DN> iterable2 = this.getChopAfter();
        if (iterable != null && iterable.iterator().hasNext() || iterable2 != null && iterable2.iterator().hasNext()) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" specificExclusions { ");
            boolean bl2 = true;
            if (iterable != null) {
                for (DN dN : iterable) {
                    if (!bl2) {
                        stringBuilder.append(", chopBefore:");
                    } else {
                        stringBuilder.append("chopBefore:");
                        bl2 = false;
                    }
                    StaticUtils.toRFC3641StringValue(stringBuilder, dN.toString());
                }
            }
            if (iterable2 != null) {
                for (DN dN : iterable2) {
                    if (!bl2) {
                        stringBuilder.append(", chopAfter:");
                    } else {
                        stringBuilder.append("chopAfter:");
                        bl2 = false;
                    }
                    StaticUtils.toRFC3641StringValue(stringBuilder, dN.toString());
                }
            }
            stringBuilder.append(" }");
        }
        if (this.getMinimumDepth() > 0) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" minimum ");
            stringBuilder.append(this.getMinimumDepth());
        }
        if (this.getMaximumDepth() >= 0) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" maximum ");
            stringBuilder.append(this.getMaximumDepth());
        }
        if (this.refinements != null) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" specificationFilter ");
            this.refinements.toString(stringBuilder);
        }
        stringBuilder.append(" }");
        return stringBuilder;
    }

    @Override
    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object instanceof RFC3672SubtreeSpecification) {
            RFC3672SubtreeSpecification rFC3672SubtreeSpecification = (RFC3672SubtreeSpecification)object;
            if (!this.commonComponentsEquals(rFC3672SubtreeSpecification)) {
                return false;
            }
            if (!this.getBaseDN().equals(rFC3672SubtreeSpecification.getBaseDN())) {
                return false;
            }
            if (this.refinements != null) {
                return this.refinements.equals(rFC3672SubtreeSpecification.refinements);
            }
            return this.refinements == rFC3672SubtreeSpecification.refinements;
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.commonComponentsHashCode();
        n = n * 31 + this.getBaseDN().hashCode();
        if (this.refinements != null) {
            n = n * 31 + this.refinements.hashCode();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OrRefinement
    extends Refinement {
        private Collection<Refinement> refinementSet;

        public OrRefinement(Collection<Refinement> collection) {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.refinementSet = collection;
        }

        @Override
        public boolean matches(Entry entry) {
            for (Refinement refinement : this.refinementSet) {
                if (!refinement.matches(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public StringBuilder toString(StringBuilder stringBuilder) {
            switch (this.refinementSet.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.refinementSet.iterator().next().toString(stringBuilder);
                    break;
                }
                default: {
                    stringBuilder.append("or:{");
                    Iterator<Refinement> iterator = this.refinementSet.iterator();
                    iterator.next().toString(stringBuilder);
                    while (iterator.hasNext()) {
                        stringBuilder.append(", ");
                        iterator.next().toString(stringBuilder);
                    }
                    stringBuilder.append("}");
                }
            }
            return stringBuilder;
        }

        @Override
        public boolean equals(Object object) {
            assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
            if (this == object) {
                return true;
            }
            if (object instanceof AndRefinement) {
                AndRefinement andRefinement = (AndRefinement)object;
                return ((Object)this.refinementSet).equals(andRefinement.refinementSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
            return ((Object)this.refinementSet).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AndRefinement
    extends Refinement {
        private Collection<Refinement> refinementSet;

        public AndRefinement(Collection<Refinement> collection) {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.refinementSet = collection;
        }

        @Override
        public boolean matches(Entry entry) {
            for (Refinement refinement : this.refinementSet) {
                if (refinement.matches(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public StringBuilder toString(StringBuilder stringBuilder) {
            switch (this.refinementSet.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.refinementSet.iterator().next().toString(stringBuilder);
                    break;
                }
                default: {
                    stringBuilder.append("and:{");
                    Iterator<Refinement> iterator = this.refinementSet.iterator();
                    iterator.next().toString(stringBuilder);
                    while (iterator.hasNext()) {
                        stringBuilder.append(", ");
                        iterator.next().toString(stringBuilder);
                    }
                    stringBuilder.append("}");
                }
            }
            return stringBuilder;
        }

        @Override
        public boolean equals(Object object) {
            assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
            if (this == object) {
                return true;
            }
            if (object instanceof AndRefinement) {
                AndRefinement andRefinement = (AndRefinement)object;
                return ((Object)this.refinementSet).equals(andRefinement.refinementSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
            return ((Object)this.refinementSet).hashCode();
        }
    }

    public static final class NotRefinement
    extends Refinement {
        private Refinement refinement;

        public NotRefinement(Refinement refinement) {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.refinement = refinement;
        }

        public boolean matches(Entry entry) {
            return !this.refinement.matches(entry);
        }

        public StringBuilder toString(StringBuilder stringBuilder) {
            stringBuilder.append("not:");
            return this.refinement.toString(stringBuilder);
        }

        public boolean equals(Object object) {
            assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
            if (this == object) {
                return true;
            }
            if (object instanceof NotRefinement) {
                NotRefinement notRefinement = (NotRefinement)object;
                return this.refinement.equals(notRefinement.refinement);
            }
            return false;
        }

        public int hashCode() {
            assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
            return this.refinement.hashCode();
        }
    }

    public static final class ItemRefinement
    extends Refinement {
        private String objectClass;
        private String normalizedObjectClass;

        public ItemRefinement(String string) {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.objectClass = string;
            this.normalizedObjectClass = StaticUtils.toLowerCase(string.trim());
        }

        public boolean matches(Entry entry) {
            ObjectClass objectClass = DirectoryServer.getObjectClass(this.normalizedObjectClass);
            if (objectClass == null) {
                return false;
            }
            return entry.hasObjectClass(objectClass);
        }

        public StringBuilder toString(StringBuilder stringBuilder) {
            stringBuilder.append("item:");
            stringBuilder.append(this.objectClass);
            return stringBuilder;
        }

        public boolean equals(Object object) {
            assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
            if (this == object) {
                return true;
            }
            if (object instanceof ItemRefinement) {
                ItemRefinement itemRefinement = (ItemRefinement)object;
                return this.normalizedObjectClass.equals(itemRefinement.normalizedObjectClass);
            }
            return false;
        }

        public int hashCode() {
            assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
            return this.normalizedObjectClass.hashCode();
        }
    }

    public static abstract class Refinement {
        protected Refinement() {
        }

        public abstract boolean matches(Entry var1);

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            return this.toString(stringBuilder).toString();
        }

        public abstract StringBuilder toString(StringBuilder var1);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }
}

