/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.LockManager;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainSASLMechanismHandler
extends SASLMechanismHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.PlainSASLMechanismHandler";
    private DN configEntryDN;
    private DN identityMapperDN;
    private IdentityMapper identityMapper;

    public PlainSASLMechanismHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSASLMechanismHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanismHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        int n = 0x100141;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245506;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.identityMapperDN = dNConfigAttribute2.activeValue();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                n = 1245507;
                String string = MessageHandler.getMessage(n, String.valueOf(this.identityMapperDN), String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1245508;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerSASLMechanismHandler("PLAIN", this);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSASLMechanismHandler", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
        DirectoryServer.deregisterSASLMechanismHandler("PLAIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Object object;
        Object object2;
        Object object3;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(bindOperation)));
        String string = null;
        String string2 = null;
        String string3 = null;
        ASN1OctetString aSN1OctetString = bindOperation.getSASLCredentials();
        if (aSN1OctetString == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n2 = 1245331;
            String string4 = MessageHandler.getMessage(n2);
            bindOperation.setAuthFailureReason(n2, string4);
            return;
        }
        String string5 = aSN1OctetString.stringValue();
        int n3 = string5.length();
        int n4 = string5.indexOf(0);
        if (n4 < 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n5 = 1245332;
            String string6 = MessageHandler.getMessage(n5);
            bindOperation.setAuthFailureReason(n5, string6);
            return;
        }
        if (n4 > 0) {
            string = string5.substring(0, n4);
        }
        if ((n = string5.indexOf(0, n4 + 1)) < 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n6 = 1245333;
            String string7 = MessageHandler.getMessage(n6);
            bindOperation.setAuthFailureReason(n6, string7);
            return;
        }
        if (n == n4 + 1) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n7 = 1245334;
            String string8 = MessageHandler.getMessage(n7);
            bindOperation.setAuthFailureReason(n7, string8);
            return;
        }
        if (n == n3 - 1) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n8 = 1245335;
            String string9 = MessageHandler.getMessage(n8);
            bindOperation.setAuthFailureReason(n8, string9);
            return;
        }
        string2 = string5.substring(n4 + 1, n);
        string3 = string5.substring(n + 1);
        Entry entry = null;
        String string10 = StaticUtils.toLowerCase(string2);
        if (string10.startsWith("dn:")) {
            int n9;
            try {
                object3 = DN.decode(string2.substring(3));
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n10 = 1245336;
                String string11 = MessageHandler.getMessage(n10, string2, directoryException.getErrorMessage());
                bindOperation.setAuthFailureReason(n10, string11);
                return;
            }
            if (((DN)object3).isNullDN()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n11 = 1245337;
                String string12 = MessageHandler.getMessage(n11);
                bindOperation.setAuthFailureReason(n11, string12);
                return;
            }
            object2 = DirectoryServer.getActualRootBindDN((DN)object3);
            if (object2 != null) {
                object3 = object2;
            }
            object = null;
            for (n9 = 0; n9 < 3 && (object = LockManager.lockRead((DN)object3)) == null; ++n9) {
            }
            if (object == null) {
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                n9 = 1048739;
                String string13 = MessageHandler.getMessage(n9, String.valueOf(object3));
                bindOperation.setAuthFailureReason(n9, string13);
                return;
            }
            try {
                entry = DirectoryServer.getEntry((DN)object3);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n12 = 1245338;
                String string14 = MessageHandler.getMessage(n12, String.valueOf(object3), directoryException.getErrorMessage());
                bindOperation.setAuthFailureReason(n12, string14);
                return;
            }
            finally {
                LockManager.unlock((DN)object3, (Lock)object);
            }
        }
        if (string10.startsWith("u:")) {
            string2 = string2.substring(2);
        }
        try {
            entry = this.identityMapper.getEntryForID(string2);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n13 = 1245509;
            String string15 = MessageHandler.getMessage(n13, String.valueOf(string2), directoryException.getErrorMessage());
            bindOperation.setAuthFailureReason(n13, string15);
            return;
        }
        if (entry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n14 = 1245341;
            object2 = MessageHandler.getMessage(n14, string2);
            bindOperation.setAuthFailureReason(n14, (String)object2);
            return;
        }
        bindOperation.setSASLAuthUserEntry(entry);
        try {
            object3 = new PasswordPolicyState(entry, false, false);
            if (!((PasswordPolicyState)object3).passwordMatches(new ASN1OctetString(string3))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n15 = 1245344;
                object = MessageHandler.getMessage(n15);
                bindOperation.setAuthFailureReason(n15, (String)object);
                return;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n16 = 1245562;
            object = MessageHandler.getMessage(n16, String.valueOf(entry.getDN()), String.valueOf(exception));
            bindOperation.setAuthFailureReason(n16, (String)object);
            return;
        }
        bindOperation.setResultCode(ResultCode.SUCCESS);
        object3 = new AuthenticationInfo(entry.getDN(), "PLAIN", DirectoryServer.isRootDN(entry.getDN()));
        bindOperation.getClientConnection().setAuthenticationInfo((AuthenticationInfo)object3);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 0x100141;
        linkedList.add(new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false, this.identityMapperDN));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        int n = 0x100141;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            IdentityMapper identityMapper;
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245506;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                return false;
            }
            DN dN = dNConfigAttribute2.pendingValue();
            if (!dN.equals(this.identityMapperDN) && (identityMapper = DirectoryServer.getIdentityMapper(dN)) == null) {
                n = 1245507;
                list.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.configEntryDN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245508;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        DN dN = null;
        IdentityMapper identityMapper = null;
        int n = 0x100141;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245506;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            } else {
                dN = dNConfigAttribute2.pendingValue();
                if (!dN.equals(this.identityMapperDN) && (identityMapper = DirectoryServer.getIdentityMapper(dN)) == null) {
                    n = 1245507;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.configEntryDN)));
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 1245508;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        if (resultCode == ResultCode.SUCCESS && dN != null && this.identityMapper != null) {
            this.identityMapperDN = dN;
            this.identityMapper = identityMapper;
            if (bl) {
                n = 1048902;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.identityMapperDN)));
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public boolean isPasswordBased(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordBased", String.valueOf(string)));
        return true;
    }

    @Override
    public boolean isSecure(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", String.valueOf(string)));
        return false;
    }
}

