/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.nio.ByteBuffer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.DebugLogger;
import org.opends.server.api.ProtocolElement;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;

public class Debug {
    private static CopyOnWriteArrayList<DebugLogger> debugLoggers = new CopyOnWriteArrayList();
    private static ReentrantLock loggerMutex = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugLogger(DebugLogger debugLogger) {
        loggerMutex.lock();
        try {
            for (DebugLogger debugLogger2 : debugLoggers) {
                if (!debugLogger2.equals(debugLogger)) continue;
                return;
            }
            debugLoggers.add(debugLogger);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugLogger(DebugLogger debugLogger) {
        loggerMutex.lock();
        try {
            debugLoggers.remove(debugLogger);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllDebugLoggers(boolean bl) {
        loggerMutex.lock();
        try {
            if (bl) {
                DebugLogger[] debugLoggerArray = new DebugLogger[debugLoggers.size()];
                debugLoggers.toArray(debugLoggerArray);
                debugLoggers.clear();
                for (DebugLogger debugLogger : debugLoggerArray) {
                    debugLogger.closeDebugLogger();
                }
            } else {
                debugLoggers.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    public static boolean debugBytesRead(String string, String string2, ByteBuffer byteBuffer) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugBytesRead(string, string2, byteBuffer);
        }
        return true;
    }

    public static boolean debugBytesWritten(String string, String string2, ByteBuffer byteBuffer) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugBytesWritten(string, string2, byteBuffer);
        }
        return true;
    }

    public static boolean debugConstructor(String string, String ... stringArray) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugConstructor(string, stringArray);
        }
        return true;
    }

    public static boolean debugEnter(String string, String string2, String ... stringArray) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugEnter(string, string2, stringArray);
        }
        return true;
    }

    public static boolean debugMessage(DebugLogCategory debugLogCategory, DebugLogSeverity debugLogSeverity, String string, String string2, String string3) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugMessage(debugLogCategory, debugLogSeverity, string, string2, string3);
        }
        return true;
    }

    public static boolean debugException(String string, String string2, Throwable throwable) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugException(string, string2, throwable);
        }
        return true;
    }

    public static boolean debugProtocolElementRead(String string, String string2, ProtocolElement protocolElement) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugProtocolElementRead(string, string2, protocolElement);
        }
        return true;
    }

    public static boolean debugProtocolElementWritten(String string, String string2, ProtocolElement protocolElement) {
        for (DebugLogger debugLogger : debugLoggers) {
            debugLogger.debugProtocolElementWritten(string, string2, protocolElement);
        }
        return true;
    }
}

