/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.LogFileFilter;
import org.opends.server.loggers.RetentionPolicy;

public class FreeDiskSpaceRetentionPolicy
implements RetentionPolicy {
    private static final String CLASS_NAME = "org.opends.server.loggers.FreeDiskSpaceRetentionPolicy";
    private long freeDiskSpace = 0L;
    private File directory = null;
    private String prefix = null;

    public FreeDiskSpaceRetentionPolicy(String string, String string2, long l) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(l)));
        this.directory = new File(string);
        this.freeDiskSpace = l;
        this.prefix = string2;
    }

    public int deleteFiles() {
        assert (Debug.debugEnter(CLASS_NAME, "deleteFiles", new String[0]));
        int n = 0;
        long l = 0L;
        try {
            Method method = File.class.getMethod("getFreeSpace", new Class[0]);
            Object object = method.invoke((Object)this.directory, new Object[0]);
            l = (Long)object;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "deleteFiles", exception));
            return 0;
        }
        if (l > this.freeDiskSpace) {
            return 0;
        }
        long l2 = this.freeDiskSpace - l;
        File[] fileArray = this.directory.listFiles(new LogFileFilter(this.prefix));
        Arrays.sort(fileArray, new FileComparator());
        long l3 = 0L;
        for (int i = fileArray.length - 1; i < 1; --i) {
            fileArray[i].delete();
            if ((l3 += fileArray[i].length()) >= l2) break;
            ++n;
        }
        return n;
    }
}

