/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.opends.server.messages.MessageHandler;
import org.opends.server.plugins.profiler.ProfileStack;
import org.opends.server.plugins.profiler.ProfileStackFrame;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class ProfileViewer
implements TreeSelectionListener {
    private HashMap<ProfileStackFrame, ProfileStackFrame> rootFrames = new HashMap();
    private HashMap<String, HashMap<ProfileStack, Long>> stacksByMethod = new HashMap();
    private JEditorPane frameInfoPane;
    private JTree profileTree;
    private long totalDuration = 0L;
    private long totalIntervals = 0L;

    public static void main(String[] stringArray) {
        String string2;
        int n;
        Argument argument = null;
        BooleanArgument booleanArgument = null;
        StringArgument stringArgument = null;
        ArgumentParser argumentParser = new ArgumentParser("org.opends.server.plugins.profiler.ProfileViewer", false);
        try {
            stringArgument = new StringArgument("filenames", Character.valueOf('f'), "fileName", true, true, true, "{file}", null, null, 7340084, new Object[0]);
            argumentParser.addArgument(stringArgument);
            booleanArgument = new BooleanArgument("usegui", Character.valueOf('g'), "useGUI", 7340085, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argument = new BooleanArgument("help", Character.valueOf('H'), "help", 7340086, new Object[0]);
            argumentParser.addArgument(argument);
            argumentParser.setUsageArgument(argument);
        }
        catch (ArgumentException argumentException) {
            n = 7602231;
            string2 = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(string2);
            System.exit(1);
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            n = 7602232;
            string2 = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(string2);
            System.err.println(argumentParser.getUsage());
            System.exit(1);
        }
        if (argument.isPresent()) {
            System.exit(0);
        }
        ProfileViewer profileViewer = new ProfileViewer();
        for (String string2 : stringArgument.getValues()) {
            try {
                profileViewer.processDataFile(string2);
            }
            catch (Exception exception) {
                int n2 = 7602233;
                String string3 = MessageHandler.getMessage(n2, string2, StaticUtils.stackTraceToSingleLineString(exception));
                System.err.println(string3);
            }
        }
        if (booleanArgument.isPresent()) {
            profileViewer.displayGUI();
        } else {
            profileViewer.printProfileData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataFile(String string) throws IOException, ASN1Exception {
        ASN1Reader aSN1Reader = new ASN1Reader(new FileInputStream(string));
        try {
            ASN1Element aSN1Element = aSN1Reader.readElement();
            ArrayList<ASN1Element> arrayList = aSN1Element.decodeAsSequence().elements();
            this.totalIntervals += arrayList.get(0).decodeAsLong().longValue();
            long l = arrayList.get(1).decodeAsLong().longValue();
            long l2 = arrayList.get(2).decodeAsLong().longValue();
            this.totalDuration += l2 - l;
            while ((aSN1Element = aSN1Reader.readElement()) != null) {
                String string2;
                HashMap<ProfileStack, Long> hashMap;
                ProfileStack profileStack = ProfileStack.decode(aSN1Element);
                aSN1Element = aSN1Reader.readElement();
                long l3 = aSN1Element.decodeAsLong().longValue();
                int n = profileStack.getNumFrames() - 1;
                if (n < 0) continue;
                String[] stringArray = profileStack.getClassNames();
                String[] stringArray2 = profileStack.getMethodNames();
                int[] nArray = profileStack.getLineNumbers();
                ProfileStackFrame profileStackFrame = new ProfileStackFrame(stringArray[n], stringArray2[n]);
                ProfileStackFrame profileStackFrame2 = this.rootFrames.get(profileStackFrame);
                if (profileStackFrame2 == null) {
                    profileStackFrame2 = profileStackFrame;
                }
                if ((hashMap = this.stacksByMethod.get(string2 = stringArray[n] + "." + stringArray2[n])) == null) {
                    hashMap = new HashMap();
                    this.stacksByMethod.put(string2, hashMap);
                }
                hashMap.put(profileStack, l3);
                profileStackFrame2.updateLineNumberCount(nArray[n], l3);
                this.rootFrames.put(profileStackFrame2, profileStackFrame2);
                profileStackFrame2.recurseSubFrames(profileStack, n - 1, l3, this.stacksByMethod);
            }
        }
        finally {
            try {
                aSN1Reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public ProfileStackFrame[] getRootFrames() {
        Object[] objectArray = new ProfileStackFrame[]{};
        objectArray = this.rootFrames.values().toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public long getTotalIntervals() {
        return this.totalIntervals;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public void printProfileData() {
        System.out.println("Total Intervals:     " + this.totalIntervals);
        System.out.println("Total Duration:      " + this.totalDuration);
        System.out.println();
        System.out.println();
        for (ProfileStackFrame profileStackFrame : this.getRootFrames()) {
            ProfileViewer.printFrame(profileStackFrame, 0);
        }
    }

    private static void printFrame(ProfileStackFrame profileStackFrame, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.print(profileStackFrame.getTotalCount());
        System.out.print("\t");
        System.out.print(profileStackFrame.getClassName());
        System.out.print(".");
        System.out.println(profileStackFrame.getMethodName());
        if (profileStackFrame.hasSubFrames()) {
            for (ProfileStackFrame profileStackFrame2 : profileStackFrame.getSubordinateFrames()) {
                ProfileViewer.printFrame(profileStackFrame2, n + 1);
            }
        }
    }

    public void displayGUI() {
        JFrame jFrame = new JFrame("Directory Server Profile Data");
        jFrame.setDefaultCloseOperation(3);
        JSplitPane jSplitPane = new JSplitPane(0);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.setFont(new Font("Monospaced", 0, 12));
        String string = "<HTML><BODY><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR></BODY></HTML>";
        this.frameInfoPane = new JEditorPane("text/html", string);
        jSplitPane.setBottomComponent(new JScrollPane(this.frameInfoPane));
        String string2 = "Profile Data:  " + this.totalIntervals + " sample intervals " + "captured over " + this.totalDuration + " milliseconds";
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2, true);
        ProfileStackFrame[] profileStackFrameArray = this.getRootFrames();
        if (profileStackFrameArray.length == 0) {
            System.err.println("ERROR:  No data available for viewing.");
            return;
        }
        for (ProfileStackFrame profileStackFrame : this.getRootFrames()) {
            boolean bl = profileStackFrame.hasSubFrames();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(profileStackFrame, bl);
            this.recurseTreeNodes(profileStackFrame, defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.profileTree = new JTree(new DefaultTreeModel(defaultMutableTreeNode, true));
        this.profileTree.setFont(new Font("Monospaced", 0, 12));
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.profileTree.setSelectionModel(defaultTreeSelectionModel);
        this.profileTree.addTreeSelectionListener(this);
        this.profileTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getFirstChild()));
        this.valueChanged(null);
        jSplitPane.setTopComponent(new JScrollPane(this.profileTree));
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setOneTouchExpandable(true);
        container.add((Component)jSplitPane, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private void recurseTreeNodes(ProfileStackFrame profileStackFrame, DefaultMutableTreeNode defaultMutableTreeNode) {
        ProfileStackFrame[] profileStackFrameArray = profileStackFrame.getSubordinateFrames();
        if (profileStackFrameArray.length == 0) {
            return;
        }
        String string = String.valueOf(profileStackFrameArray[0].getTotalCount());
        int n = string.length();
        for (ProfileStackFrame profileStackFrame2 : profileStackFrameArray) {
            boolean bl = profileStackFrame.hasSubFrames();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(profileStackFrame2, bl);
            if (bl) {
                this.recurseTreeNodes(profileStackFrame2, defaultMutableTreeNode2);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private String formatCount(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(l);
        while (stringBuilder.length() < n) {
            stringBuilder.insert(0, ' ');
        }
        return stringBuilder.toString();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        try {
            TreePath treePath = this.profileTree.getSelectionPath();
            if (treePath == null) {
                this.frameInfoPane.setText("");
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) {
                this.frameInfoPane.setText("");
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof ProfileStackFrame)) {
                this.frameInfoPane.setText("");
                return;
            }
            ProfileStackFrame profileStackFrame = (ProfileStackFrame)object;
            if (profileStackFrame == null) {
                this.frameInfoPane.setText("");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<HTML><BODY><PRE>");
            stringBuilder.append("Information for stack frame <B>");
            stringBuilder.append(profileStackFrame.getClassName());
            stringBuilder.append(".");
            stringBuilder.append(profileStackFrame.getHTMLSafeMethodName());
            stringBuilder.append("</B><BR><BR>Occurrences by Source Line Number:<BR>");
            HashMap<Integer, Long> hashMap = profileStackFrame.getLineNumbers();
            for (Integer serializable2 : hashMap.keySet()) {
                stringBuilder.append("     ");
                long l = hashMap.get(serializable2);
                if (serializable2 == -2) {
                    stringBuilder.append("&lt;native&gt;");
                } else if (serializable2 == -1) {
                    stringBuilder.append("&lt;unknown&gt;");
                } else {
                    stringBuilder.append("Line ");
                    stringBuilder.append(serializable2);
                }
                stringBuilder.append(":  ");
                stringBuilder.append(l);
                if (l == 1L) {
                    stringBuilder.append(" occurrence<BR>");
                    continue;
                }
                stringBuilder.append(" occurrences<BR>");
            }
            stringBuilder.append("<BR><BR>");
            stringBuilder.append("<HR>Stack Traces Including this Method:");
            String string = profileStackFrame.getClassName() + "." + profileStackFrame.getMethodName();
            HashMap<ProfileStack, Long> hashMap2 = this.stacksByMethod.get(string);
            for (ProfileStack profileStack : hashMap2.keySet()) {
                stringBuilder.append("<BR><BR>");
                stringBuilder.append(hashMap2.get(profileStack));
                stringBuilder.append(" occurrence(s):");
                this.appendHTMLStack(profileStack, stringBuilder, string);
            }
            stringBuilder.append("</PRE></BODY></HTML>");
            this.frameInfoPane.setText(stringBuilder.toString());
            this.frameInfoPane.setSelectionStart(0);
            this.frameInfoPane.setSelectionEnd(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.frameInfoPane.setText("");
        }
    }

    private void appendHTMLStack(ProfileStack profileStack, StringBuilder stringBuilder, String string) {
        int n = profileStack.getNumFrames();
        for (int i = n - 1; i >= 0; --i) {
            stringBuilder.append("<BR>     ");
            String string2 = profileStack.getClassName(i);
            String string3 = profileStack.getMethodName(i);
            int n2 = profileStack.getLineNumber(i);
            String string4 = string3.equals("<init>") ? "&lt;init&gt;" : string3;
            String string5 = string2 + "." + string3;
            if (string5.equals(string)) {
                stringBuilder.append("<B>");
                stringBuilder.append(string2);
                stringBuilder.append(".");
                stringBuilder.append(string4);
                stringBuilder.append(":");
                if (n2 == -2) {
                    stringBuilder.append("&lt;native&gt;");
                } else if (n2 == -1) {
                    stringBuilder.append("&lt;unknown&gt;");
                } else {
                    stringBuilder.append(n2);
                }
                stringBuilder.append("</B>");
                continue;
            }
            stringBuilder.append(string2);
            stringBuilder.append(".");
            stringBuilder.append(string4);
            stringBuilder.append(":");
            if (n2 == -2) {
                stringBuilder.append("&lt;native&gt;");
                continue;
            }
            if (n2 == -1) {
                stringBuilder.append("&lt;unknown&gt;");
                continue;
            }
            stringBuilder.append(n2);
        }
    }
}

