/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1OctetString
extends ASN1Element
implements ByteString {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1OctetString";
    private static final long serialVersionUID = -6101268916754431502L;
    private String stringValue;

    public ASN1OctetString() {
        super((byte)4);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public ASN1OctetString(byte by) {
        super(by);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by)));
    }

    public ASN1OctetString(byte[] byArray) {
        super((byte)4, byArray);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.bytesToHex(byArray)));
        this.stringValue = null;
    }

    public ASN1OctetString(String string) {
        super((byte)4, StaticUtils.getBytes(string));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.stringValue = string;
    }

    public ASN1OctetString(byte by, byte[] byArray) {
        super(by, byArray);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray)));
        this.stringValue = null;
    }

    public ASN1OctetString(byte by, String string) {
        super(by, StaticUtils.getBytes(string));
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), String.valueOf(string)));
        this.stringValue = string;
    }

    public String stringValue() {
        assert (Debug.debugEnter(CLASS_NAME, "stringValue", new String[0]));
        if (this.stringValue == null) {
            try {
                this.stringValue = new String(this.value(), "UTF-8");
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "stringValue", exception));
                this.stringValue = new String(this.value());
            }
        }
        return this.stringValue;
    }

    public void stringValue(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "stringValue", "java.lang.StringBuilder"));
        if (this.stringValue != null) {
            stringBuilder.append(this.stringValue);
            return;
        }
        byte[] byArray = this.value();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0x7F) != byArray[i]) {
                String string;
                try {
                    string = new String(byArray, i, n - i, "UTF-8");
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "stringValue", exception));
                    string = new String(byArray, i, n - i);
                }
                stringBuilder.append(string);
                return;
            }
            stringBuilder.append((char)byArray[i]);
        }
    }

    public void setValue(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(string)));
        if (string == null) {
            this.stringValue = null;
            this.setValueInternal(new byte[0]);
        } else {
            this.stringValue = string;
            this.setValueInternal(StaticUtils.getBytes(string));
        }
    }

    public void setValue(byte[] byArray) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            this.setValueInternal(ASN1Constants.NO_VALUE);
        } else {
            this.setValueInternal(byArray);
        }
        this.stringValue = null;
    }

    public static ASN1OctetString decodeAsOctetString(ASN1Element aSN1Element) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsOctetString", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293783;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        return new ASN1OctetString(aSN1Element.getType(), aSN1Element.value());
    }

    public static ASN1OctetString decodeAsOctetString(byte[] byArray) throws ASN1Exception {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsOctetString", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n2 = 2293784;
            String string = MessageHandler.getMessage(n2);
            throw new ASN1Exception(n2, string);
        }
        if (byArray.length < 2) {
            int n3 = 0x230002;
            String string = MessageHandler.getMessage(n3, byArray.length);
            throw new ASN1Exception(n3, string);
        }
        byte by = byArray[0];
        int n4 = byArray[1] & 0x7F;
        int n5 = 2;
        if (n4 != byArray[1]) {
            n = n4;
            if (n > 4) {
                int n6 = 0x230003;
                String string = MessageHandler.getMessage(n6, n);
                throw new ASN1Exception(n6, string);
            }
            if (byArray.length < 2 + n) {
                int n7 = 2293764;
                String string = MessageHandler.getMessage(n7, n);
                throw new ASN1Exception(n7, string);
            }
            n4 = 0;
            n5 = 2 + n;
            for (int i = 0; i < n; ++i) {
                n4 = n4 << 8 | byArray[i + 2] & 0xFF;
            }
        }
        if (byArray.length - n5 != n4) {
            n = 2293765;
            String string = MessageHandler.getMessage(n, n4, byArray.length - n5);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n5, byArray2, 0, n4);
        return new ASN1OctetString(by, byArray2);
    }

    public ASN1OctetString duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        byte[] byArray = this.value();
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return new ASN1OctetString(this.getType(), byArray);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append(this.stringValue());
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Octet String");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(ServerConstants.EOL);
        byte[] byArray = this.value();
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Value (");
        stringBuilder.append(byArray.length);
        stringBuilder.append(" bytes)");
        stringBuilder.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(stringBuilder, byArray, n + 2);
    }

    public ASN1OctetString toASN1OctetString() {
        assert (Debug.debugEnter(CLASS_NAME, "toASN1OctetString", new String[0]));
        return this;
    }
}

