/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.opends.server.config.JMXMBean;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.jmx.DirectoryRMIClientSocketFactory;
import org.opends.server.protocols.jmx.DirectoryRMIServerSocketFactory;
import org.opends.server.protocols.jmx.JmxConnectionHandler;
import org.opends.server.protocols.jmx.OpendsRMIJRMPServerImpl;
import org.opends.server.protocols.jmx.OpendsRmiServerSocketFactory;
import org.opends.server.protocols.jmx.RmiAuthenticator;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;

public class RmiConnector {
    private MBeanServer mbs = null;
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.RmiConnector";
    private String registryClientAddress = "0.0.0.0";
    private JmxConnectionHandler jmxConnectionHandler;
    private String jmxRmiConnectorNoClientCertificateName;
    private String jmxRmiConnectorClientCertificateName;
    protected JMXConnectorServer jmxRmiConnectorNoClientCertificate;
    private JMXConnectorServer jmxRmiConnectorClientCertificate;
    private RmiAuthenticator rmiAuthenticator;
    private Registry registry = null;
    OpendsRmiServerSocketFactory rmiSsf;

    public RmiConnector(MBeanServer mBeanServer, JmxConnectionHandler jmxConnectionHandler) {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.mbs = mBeanServer;
        this.jmxConnectionHandler = jmxConnectionHandler;
        String string = JMXMBean.getJmxName(jmxConnectionHandler.getComponentEntryDN());
        this.jmxRmiConnectorNoClientCertificateName = string + "," + "Type=jmxRmiConnectorNoClientCertificateName";
        this.jmxRmiConnectorClientCertificateName = string + "," + "Type=jmxRmiConnectorClientCertificateName";
    }

    public void initialize() {
        assert (Debug.debugEnter(CLASS_NAME, "initialize", new String[0]));
        try {
            this.startCommonRegistry();
            this.startConnectorNoClientCertificate();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "start", exception));
            throw new RuntimeException("Error while starting the RMI module : " + exception.getMessage());
        }
        assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "start", "RMI module started"));
    }

    private void startCommonRegistry() throws Exception {
        block10: {
            assert (Debug.debugEnter(CLASS_NAME, "startCommonRegistry", new String[0]));
            int n = this.jmxConnectionHandler.listenPort;
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "startCommonRegistry", "start or reach an RMI registry on port " + n));
            try {
                if (this.registry == null) {
                    this.rmiSsf = new OpendsRmiServerSocketFactory();
                    this.registry = LocateRegistry.createRegistry(n, RMISocketFactory.getDefaultSocketFactory(), this.rmiSsf);
                }
            }
            catch (RemoteException remoteException) {
                assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.WARNING, CLASS_NAME, "startCommonRegistry", "cannot create the RMI registry -> already done ?"));
                try {
                    Registry registry = LocateRegistry.getRegistry(n);
                    registry.list();
                    this.registry = registry;
                }
                catch (Exception exception) {
                    assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.ERROR, CLASS_NAME, "startCommonRegistry", "exception thrown while pinging the RMI registry"));
                    assert (Debug.debugException(CLASS_NAME, "startCommonRegistry", remoteException));
                    throw remoteException;
                }
                if ($assertionsDisabled || Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.WARNING, CLASS_NAME, "startCommonRegistry", "RMI was registry already started")) break block10;
                throw new AssertionError();
            }
        }
    }

    private void startConnectorNoClientCertificate() throws Exception {
        assert (Debug.debugEnter(CLASS_NAME, "startConnectorNoClientCertificate", new String[0]));
        try {
            Object object;
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            DirectoryRMIClientSocketFactory directoryRMIClientSocketFactory = null;
            DirectoryRMIServerSocketFactory directoryRMIServerSocketFactory = null;
            if (this.jmxConnectionHandler.useSSL) {
                assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "startConnectorNoClientCertificate", "SSL connection"));
                object2 = SSLContext.getInstance("TLSv1");
                ((SSLContext)object2).init(this.jmxConnectionHandler.jmxKeyManager.getKeyManagers(), null, null);
                object = ((SSLContext)object2).getSocketFactory();
                directoryRMIServerSocketFactory = new DirectoryRMIServerSocketFactory((SSLSocketFactory)object, false);
                hashMap.put("jmx.remote.rmi.server.socket.factory", directoryRMIServerSocketFactory);
                directoryRMIClientSocketFactory = new DirectoryRMIClientSocketFactory(false);
                hashMap.put("jmx.remote.rmi.client.socket.factory", directoryRMIClientSocketFactory);
            } else assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.WARNING, CLASS_NAME, "startConnectorNoClientCertificate", "UNSECURE CONNECTION"));
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "startConnectorNoClientCertificate", "Add RmiAuthenticator into JMX map"));
            this.rmiAuthenticator = new RmiAuthenticator(this.jmxConnectionHandler);
            hashMap.put("jmx.remote.authenticator", this.rmiAuthenticator);
            object2 = "org.opends.server.protocols.jmx.client-unknown";
            object = "service:jmx:rmi:///jndi/rmi://" + this.registryClientAddress + ":" + this.jmxConnectionHandler.listenPort + "/" + (String)object2;
            JMXServiceURL jMXServiceURL = new JMXServiceURL((String)object);
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "startConnectorNoClientCertificate", "Create and start the JMX RMI connector"));
            OpendsRMIJRMPServerImpl opendsRMIJRMPServerImpl = new OpendsRMIJRMPServerImpl(0, directoryRMIClientSocketFactory, directoryRMIServerSocketFactory, hashMap);
            this.jmxRmiConnectorNoClientCertificate = new RMIConnectorServer(jMXServiceURL, hashMap, opendsRMIJRMPServerImpl, this.mbs);
            this.jmxRmiConnectorNoClientCertificate.start();
            ObjectName objectName = new ObjectName(this.jmxRmiConnectorNoClientCertificateName);
            this.mbs.registerMBean(this.jmxRmiConnectorNoClientCertificate, objectName);
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "startConnectorNoClientCertificate", "JMX RMI connector Started"));
        }
        catch (Exception exception) {
            Debug.debugException(CLASS_NAME, "startConnectorNoClientCertificate", exception);
            throw exception;
        }
    }

    public void finalizeConnectionHandler(boolean bl) {
        block13: {
            block12: {
                if (bl) {
                    try {
                        if (this.jmxRmiConnectorNoClientCertificate != null) {
                            this.jmxRmiConnectorNoClientCertificate.stop();
                        }
                        if (this.jmxRmiConnectorClientCertificate != null) {
                            this.jmxRmiConnectorClientCertificate.stop();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.jmxRmiConnectorNoClientCertificate = null;
                    this.jmxRmiConnectorClientCertificate = null;
                } else {
                    this.rmiAuthenticator.setFinalizedPhase(true);
                }
                try {
                    ObjectName objectName = new ObjectName(this.jmxRmiConnectorNoClientCertificateName);
                    if (this.mbs.isRegistered(objectName)) {
                        this.mbs.unregisterMBean(objectName);
                    }
                    if (this.jmxRmiConnectorNoClientCertificate != null) {
                        this.jmxRmiConnectorNoClientCertificate.stop();
                    }
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeConnectionHandler", exception)) break block12;
                    throw new AssertionError();
                }
            }
            try {
                this.rmiSsf.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeConnectionHandler", iOException)) break block13;
                throw new AssertionError();
            }
        }
        this.registry = null;
    }
}

