/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class DeleteRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.DeleteRequestProtocolOp";
    private ASN1OctetString dn;

    public DeleteRequestProtocolOp(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
    }

    public ASN1OctetString getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 74;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Delete Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        this.dn.setType((byte)74);
        return this.dn;
    }

    public static DeleteRequestProtocolOp decodeDeleteRequest(ASN1Element aSN1Element) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeDeleteRequest", String.valueOf(aSN1Element)));
        try {
            return new DeleteRequestProtocolOp(aSN1Element.decodeAsOctetString());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeDeleteRequest", exception));
            int n = 2293850;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("DeleteRequest(dn=");
        this.dn.toString(stringBuilder);
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Delete Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Entry DN:  ");
        this.dn.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
    }
}

