/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.FilterType;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPFilter {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPFilter";
    private ArrayList<ASN1OctetString> subAnyElements;
    private ArrayList<LDAPFilter> filterComponents;
    private ASN1OctetString assertionValue;
    private ASN1OctetString subFinalElement;
    private ASN1OctetString subInitialElement;
    private boolean dnAttributes;
    private FilterType filterType;
    private LDAPFilter notComponent;
    private String attributeType;
    private String matchingRuleID;

    private LDAPFilter(FilterType filterType, ArrayList<LDAPFilter> arrayList, LDAPFilter lDAPFilter, String string, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ArrayList<ASN1OctetString> arrayList2, ASN1OctetString aSN1OctetString3, String string2, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)filterType), String.valueOf(arrayList), String.valueOf(lDAPFilter), String.valueOf(string), String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2), String.valueOf(arrayList2), String.valueOf(aSN1OctetString3), String.valueOf(string2), String.valueOf(bl)));
        this.filterType = filterType;
        this.filterComponents = arrayList;
        this.notComponent = lDAPFilter;
        this.attributeType = string;
        this.assertionValue = aSN1OctetString;
        this.subInitialElement = aSN1OctetString2;
        this.subAnyElements = arrayList2;
        this.subFinalElement = aSN1OctetString3;
        this.matchingRuleID = string2;
        this.dnAttributes = bl;
    }

    public LDAPFilter(SearchFilter searchFilter) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(searchFilter)));
        this.filterType = searchFilter.getFilterType();
        switch (this.filterType) {
            case AND: 
            case OR: {
                List<SearchFilter> list = searchFilter.getFilterComponents();
                this.filterComponents = new ArrayList(list.size());
                for (SearchFilter searchFilter2 : list) {
                    this.filterComponents.add(new LDAPFilter(searchFilter2));
                }
                this.notComponent = null;
                this.attributeType = null;
                this.assertionValue = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case NOT: {
                this.notComponent = new LDAPFilter(searchFilter.getNotComponent());
                this.filterComponents = null;
                this.attributeType = null;
                this.assertionValue = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case EQUALITY: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case APPROXIMATE_MATCH: {
                this.attributeType = searchFilter.getAttributeType().getNameOrOID();
                this.assertionValue = searchFilter.getAssertionValue().getValue().toASN1OctetString();
                this.filterComponents = null;
                this.notComponent = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case SUBSTRING: {
                this.attributeType = searchFilter.getAttributeType().getNameOrOID();
                ByteString byteString = searchFilter.getSubInitialElement();
                this.subInitialElement = byteString == null ? null : byteString.toASN1OctetString();
                byteString = searchFilter.getSubFinalElement();
                this.subFinalElement = byteString == null ? null : byteString.toASN1OctetString();
                List<ByteString> list = searchFilter.getSubAnyElements();
                if (list == null) {
                    this.subAnyElements = null;
                } else {
                    this.subAnyElements = new ArrayList(list.size());
                    for (ByteString byteString2 : list) {
                        this.subAnyElements.add(byteString2.toASN1OctetString());
                    }
                }
                this.filterComponents = null;
                this.notComponent = null;
                this.assertionValue = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case PRESENT: {
                this.attributeType = searchFilter.getAttributeType().getNameOrOID();
                this.filterComponents = null;
                this.notComponent = null;
                this.assertionValue = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
                this.matchingRuleID = null;
                this.dnAttributes = false;
                break;
            }
            case EXTENSIBLE_MATCH: {
                this.dnAttributes = searchFilter.getDNAttributes();
                this.matchingRuleID = searchFilter.getMatchingRuleID();
                AttributeType attributeType = searchFilter.getAttributeType();
                this.attributeType = attributeType == null ? null : attributeType.getNameOrOID();
                AttributeValue attributeValue = searchFilter.getAssertionValue();
                this.assertionValue = attributeValue == null ? null : attributeValue.getValue().toASN1OctetString();
                this.filterComponents = null;
                this.notComponent = null;
                this.subInitialElement = null;
                this.subAnyElements = null;
                this.subFinalElement = null;
            }
        }
    }

    public static LDAPFilter createANDFilter(ArrayList<LDAPFilter> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "createANDFilter", String.valueOf(arrayList)));
        return new LDAPFilter(FilterType.AND, arrayList, null, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createORFilter(ArrayList<LDAPFilter> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "createORFilter", String.valueOf(arrayList)));
        return new LDAPFilter(FilterType.OR, arrayList, null, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createNOTFilter(LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "createNOTFilter", String.valueOf(lDAPFilter)));
        return new LDAPFilter(FilterType.NOT, null, lDAPFilter, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createEqualityFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createEqualityFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new LDAPFilter(FilterType.EQUALITY, null, null, string, aSN1OctetString, null, null, null, null, false);
    }

    public static LDAPFilter createSubstringFilter(String string, ASN1OctetString aSN1OctetString, ArrayList<ASN1OctetString> arrayList, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugEnter(CLASS_NAME, "createSubstringFilter", String.valueOf(string), String.valueOf(aSN1OctetString), String.valueOf(arrayList), String.valueOf(aSN1OctetString2)));
        return new LDAPFilter(FilterType.SUBSTRING, null, null, string, null, aSN1OctetString, arrayList, aSN1OctetString2, null, false);
    }

    public static LDAPFilter createGreaterOrEqualFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createGreaterOrEqualFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new LDAPFilter(FilterType.GREATER_OR_EQUAL, null, null, string, aSN1OctetString, null, null, null, null, false);
    }

    public static LDAPFilter createLessOrEqualFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createLessOrEqualFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new LDAPFilter(FilterType.LESS_OR_EQUAL, null, null, string, aSN1OctetString, null, null, null, null, false);
    }

    public static LDAPFilter createPresenceFilter(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "createPresenceFilter", String.valueOf(string)));
        return new LDAPFilter(FilterType.PRESENT, null, null, string, null, null, null, null, null, false);
    }

    public static LDAPFilter createApproximateFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createApproximateFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new LDAPFilter(FilterType.APPROXIMATE_MATCH, null, null, string, aSN1OctetString, null, null, null, null, false);
    }

    public static LDAPFilter createExtensibleFilter(String string, String string2, ASN1OctetString aSN1OctetString, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "createExtensibleFilter", String.valueOf(string), String.valueOf(string2), String.valueOf(aSN1OctetString), String.valueOf(bl)));
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, string2, aSN1OctetString, null, null, null, string, bl);
    }

    public static LDAPFilter decode(String string) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        if (string == null) {
            int n = 2293952;
            String string2 = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string2);
        }
        try {
            return LDAPFilter.decode(string, 0, string.length());
        }
        catch (LDAPException lDAPException) {
            assert (Debug.debugException(CLASS_NAME, "decode", lDAPException));
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n = 2293953;
            String string3 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new LDAPException(2, n, string3, exception);
        }
    }

    private static LDAPFilter decode(String string, int n, int n2) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        FilterType filterType;
        int n3;
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "createFilterFromString", String.valueOf(string), String.valueOf(n), String.valueOf(n2)));
        int n4 = n2 - n;
        if (n4 <= 0) {
            int n5 = 2293952;
            String string2 = MessageHandler.getMessage(n5);
            throw new LDAPException(2, n5, string2);
        }
        if (string.charAt(n) == '(') {
            if (string.charAt(n2 - 1) == ')') {
                ++n;
                --n2;
            } else {
                int n6 = 2293954;
                String string3 = MessageHandler.getMessage(n6, string, n, n2);
                throw new LDAPException(2, n6, string3);
            }
        }
        if ((c = string.charAt(n)) == '&') {
            return LDAPFilter.decodeCompoundFilter(FilterType.AND, string, n + 1, n2);
        }
        if (c == '|') {
            return LDAPFilter.decodeCompoundFilter(FilterType.OR, string, n + 1, n2);
        }
        if (c == '!') {
            LDAPFilter lDAPFilter = LDAPFilter.decode(string, n + 1, n2);
            return new LDAPFilter(FilterType.NOT, null, lDAPFilter, null, null, null, null, null, null, false);
        }
        int n7 = -1;
        for (n3 = n; n3 < n2; ++n3) {
            if (string.charAt(n3) != '=') continue;
            n7 = n3;
            break;
        }
        if (n7 <= n) {
            n3 = 2293955;
            String string4 = MessageHandler.getMessage(n3, string, n, n2);
            throw new LDAPException(2, n3, string4);
        }
        switch (string.charAt(n7 - 1)) {
            case '~': {
                filterType = FilterType.APPROXIMATE_MATCH;
                n3 = n7 - 1;
                break;
            }
            case '>': {
                filterType = FilterType.GREATER_OR_EQUAL;
                n3 = n7 - 1;
                break;
            }
            case '<': {
                filterType = FilterType.LESS_OR_EQUAL;
                n3 = n7 - 1;
                break;
            }
            case ':': {
                return LDAPFilter.decodeExtensibleMatchFilter(string, n, n7, n2);
            }
            default: {
                filterType = FilterType.EQUALITY;
                n3 = n7;
            }
        }
        String string5 = string.substring(n, n3);
        String string6 = string.substring(n7 + 1, n2);
        if (string6.length() == 0) {
            return new LDAPFilter(filterType, null, null, string5, new ASN1OctetString(), null, null, null, null, false);
        }
        if (string6.equals("*")) {
            return new LDAPFilter(FilterType.PRESENT, null, null, string5, null, null, null, null, null, false);
        }
        if (string6.indexOf(42) >= 0) {
            return LDAPFilter.decodeSubstringFilter(string, string5, n7, n2);
        }
        boolean bl = false;
        byte[] byArray = StaticUtils.getBytes(string6);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            bl = true;
            break;
        }
        if (bl) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(string6.length());
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 92) {
                    if (i + 2 >= byArray.length) {
                        int n5 = 2293956;
                        String n8 = MessageHandler.getMessage(n5, string, n7 + i + 1);
                        throw new LDAPException(2, n5, n8);
                    }
                    byte by = 0;
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = 16;
                            break;
                        }
                        case 50: {
                            by = 32;
                            break;
                        }
                        case 51: {
                            by = 48;
                            break;
                        }
                        case 52: {
                            by = 64;
                            break;
                        }
                        case 53: {
                            by = 80;
                            break;
                        }
                        case 54: {
                            by = 96;
                            break;
                        }
                        case 55: {
                            by = 112;
                            break;
                        }
                        case 56: {
                            by = -128;
                            break;
                        }
                        case 57: {
                            by = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = -16;
                            break;
                        }
                        default: {
                            int n9 = 2293956;
                            String string9 = MessageHandler.getMessage(n9, string, n7 + i + 1);
                            throw new LDAPException(2, n9, string9);
                        }
                    }
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = (byte)(by | 1);
                            break;
                        }
                        case 50: {
                            by = (byte)(by | 2);
                            break;
                        }
                        case 51: {
                            by = (byte)(by | 3);
                            break;
                        }
                        case 52: {
                            by = (byte)(by | 4);
                            break;
                        }
                        case 53: {
                            by = (byte)(by | 5);
                            break;
                        }
                        case 54: {
                            by = (byte)(by | 6);
                            break;
                        }
                        case 55: {
                            by = (byte)(by | 7);
                            break;
                        }
                        case 56: {
                            by = (byte)(by | 8);
                            break;
                        }
                        case 57: {
                            by = (byte)(by | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = (byte)(by | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = (byte)(by | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = (byte)(by | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = (byte)(by | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = (byte)(by | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = (byte)(by | 0xF);
                            break;
                        }
                        default: {
                            int n6 = 2293956;
                            String string2 = MessageHandler.getMessage(n6, string, n7 + i + 1);
                            throw new LDAPException(2, n6, string2);
                        }
                    }
                    byteBuffer.put(by);
                    continue;
                }
                byteBuffer.put(byArray[i]);
            }
            byArray = new byte[byteBuffer.position()];
            byteBuffer.flip();
            byteBuffer.get(byArray);
            aSN1OctetString = new ASN1OctetString(byArray);
        } else {
            aSN1OctetString = new ASN1OctetString(byArray);
        }
        return new LDAPFilter(filterType, null, null, string5, aSN1OctetString, null, null, null, null, false);
    }

    private static LDAPFilter decodeCompoundFilter(FilterType filterType, String string, int n, int n2) throws LDAPException {
        int n3;
        assert (Debug.debugEnter(CLASS_NAME, "decodeCompoundFilter", String.valueOf((Object)filterType), String.valueOf(string), String.valueOf(n), String.valueOf(n2)));
        ArrayList<LDAPFilter> arrayList = new ArrayList<LDAPFilter>();
        if (n == n2) {
            return new LDAPFilter(filterType, arrayList, null, null, null, null, null, null, null, false);
        }
        if (string.charAt(n) != '(' || string.charAt(n2 - 1) != ')') {
            int n4 = 2293957;
            String string2 = MessageHandler.getMessage(n4, string, n, n2);
            throw new LDAPException(2, n4, string2);
        }
        int n5 = 0;
        int n6 = -1;
        for (n3 = n; n3 < n2; ++n3) {
            char c = string.charAt(n3);
            if (c == '(') {
                if (n6 < 0) {
                    n6 = n3;
                }
                ++n5;
                continue;
            }
            if (c == ')') {
                if (--n5 == 0) {
                    arrayList.add(LDAPFilter.decode(string, n6, n3 + 1));
                    n6 = -1;
                    continue;
                }
                if (n5 >= 0) continue;
                int n7 = 2293958;
                String string3 = MessageHandler.getMessage(n7, string, n3);
                throw new LDAPException(2, n7, string3);
            }
            if (n5 > 0) continue;
            int n8 = 2293957;
            String string4 = MessageHandler.getMessage(n8, string, n, n2);
            throw new LDAPException(2, n8, string4);
        }
        if (n5 != 0) {
            n3 = 2293959;
            String string5 = MessageHandler.getMessage(n3, string, n6);
            throw new LDAPException(2, n3, string5);
        }
        return new LDAPFilter(filterType, arrayList, null, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeSubstringFilter(String string, String string2, int n, int n2) throws LDAPException {
        int n3;
        Object object;
        int n4;
        ArrayList<ASN1OctetString> arrayList;
        ASN1OctetString aSN1OctetString;
        int n5;
        assert (Debug.debugEnter(CLASS_NAME, "decodeSubstringFilter", String.valueOf(string), String.valueOf(string2), String.valueOf(n), String.valueOf(n2)));
        byte[] byArray = StaticUtils.getBytes(string.substring(n + 1, n2));
        boolean bl = false;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n5 = 0; n5 < byArray.length; ++n5) {
            if (byArray[n5] == 42) {
                linkedList.add(n5);
                continue;
            }
            if (byArray[n5] != 92) continue;
            bl = true;
        }
        if (linkedList.isEmpty()) {
            n5 = 2293960;
            String string3 = MessageHandler.getMessage(n5, string, n + 1, n2);
            throw new LDAPException(2, n5, string3);
        }
        int n6 = (Integer)linkedList.removeFirst();
        if (n6 == 0) {
            aSN1OctetString = null;
        } else if (bl) {
            arrayList = ByteBuffer.allocate(n6);
            for (int i = 0; i < n6; ++i) {
                if (byArray[i] == 92) {
                    if (i + 2 >= byArray.length) {
                        n4 = 2293956;
                        String string4 = MessageHandler.getMessage(n4, string, n + i + 1);
                        throw new LDAPException(2, n4, string4);
                    }
                    n4 = 0;
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            n4 = 16;
                            break;
                        }
                        case 50: {
                            n4 = 32;
                            break;
                        }
                        case 51: {
                            n4 = 48;
                            break;
                        }
                        case 52: {
                            n4 = 64;
                            break;
                        }
                        case 53: {
                            n4 = 80;
                            break;
                        }
                        case 54: {
                            n4 = 96;
                            break;
                        }
                        case 55: {
                            n4 = 112;
                            break;
                        }
                        case 56: {
                            n4 = -128;
                            break;
                        }
                        case 57: {
                            n4 = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            n4 = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            n4 = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            n4 = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            n4 = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            n4 = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            n4 = -16;
                            break;
                        }
                        default: {
                            int n7 = 2293956;
                            String string5 = MessageHandler.getMessage(n7, string, n + i + 1);
                            throw new LDAPException(2, n7, string5);
                        }
                    }
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            n4 = (byte)(n4 | 1);
                            break;
                        }
                        case 50: {
                            n4 = (byte)(n4 | 2);
                            break;
                        }
                        case 51: {
                            n4 = (byte)(n4 | 3);
                            break;
                        }
                        case 52: {
                            n4 = (byte)(n4 | 4);
                            break;
                        }
                        case 53: {
                            n4 = (byte)(n4 | 5);
                            break;
                        }
                        case 54: {
                            n4 = (byte)(n4 | 6);
                            break;
                        }
                        case 55: {
                            n4 = (byte)(n4 | 7);
                            break;
                        }
                        case 56: {
                            n4 = (byte)(n4 | 8);
                            break;
                        }
                        case 57: {
                            n4 = (byte)(n4 | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            n4 = (byte)(n4 | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            n4 = (byte)(n4 | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            n4 = (byte)(n4 | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            n4 = (byte)(n4 | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            n4 = (byte)(n4 | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            n4 = (byte)(n4 | 0xF);
                            break;
                        }
                        default: {
                            int n8 = 2293956;
                            String string6 = MessageHandler.getMessage(n8, string, n + i + 1);
                            throw new LDAPException(2, n8, string6);
                        }
                    }
                    ((ByteBuffer)((Object)arrayList)).put((byte)n4);
                    continue;
                }
                ((ByteBuffer)((Object)arrayList)).put(byArray[i]);
            }
            object = new byte[((Buffer)((Object)arrayList)).position()];
            ((ByteBuffer)((Object)arrayList)).flip();
            ((ByteBuffer)((Object)arrayList)).get((byte[])object);
            aSN1OctetString = new ASN1OctetString((byte[])object);
        } else {
            arrayList = (ArrayList<ASN1OctetString>)new byte[n6];
            System.arraycopy(byArray, 0, arrayList, 0, n6);
            aSN1OctetString = new ASN1OctetString((byte[])arrayList);
        }
        arrayList = new ArrayList<ASN1OctetString>();
        object = linkedList.iterator();
        while (object.hasNext()) {
            Object object2;
            n4 = (Integer)object.next();
            int n9 = n4 - n6 - 1;
            if (bl) {
                object2 = ByteBuffer.allocate(n9);
                for (int i = n6 + 1; i < n4; ++i) {
                    if (byArray[i] == 92) {
                        if (i + 2 >= byArray.length) {
                            n3 = 2293956;
                            String string7 = MessageHandler.getMessage(n3, string, n + i + 1);
                            throw new LDAPException(2, n3, string7);
                        }
                        n3 = 0;
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                n3 = 16;
                                break;
                            }
                            case 50: {
                                n3 = 32;
                                break;
                            }
                            case 51: {
                                n3 = 48;
                                break;
                            }
                            case 52: {
                                n3 = 64;
                                break;
                            }
                            case 53: {
                                n3 = 80;
                                break;
                            }
                            case 54: {
                                n3 = 96;
                                break;
                            }
                            case 55: {
                                n3 = 112;
                                break;
                            }
                            case 56: {
                                n3 = -128;
                                break;
                            }
                            case 57: {
                                n3 = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                n3 = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                n3 = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                n3 = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                n3 = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                n3 = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                n3 = -16;
                                break;
                            }
                            default: {
                                int n10 = 2293956;
                                String string8 = MessageHandler.getMessage(n10, string, n + i + 1);
                                throw new LDAPException(2, n10, string8);
                            }
                        }
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                n3 = (byte)(n3 | 1);
                                break;
                            }
                            case 50: {
                                n3 = (byte)(n3 | 2);
                                break;
                            }
                            case 51: {
                                n3 = (byte)(n3 | 3);
                                break;
                            }
                            case 52: {
                                n3 = (byte)(n3 | 4);
                                break;
                            }
                            case 53: {
                                n3 = (byte)(n3 | 5);
                                break;
                            }
                            case 54: {
                                n3 = (byte)(n3 | 6);
                                break;
                            }
                            case 55: {
                                n3 = (byte)(n3 | 7);
                                break;
                            }
                            case 56: {
                                n3 = (byte)(n3 | 8);
                                break;
                            }
                            case 57: {
                                n3 = (byte)(n3 | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                n3 = (byte)(n3 | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                n3 = (byte)(n3 | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                n3 = (byte)(n3 | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                n3 = (byte)(n3 | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                n3 = (byte)(n3 | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                n3 = (byte)(n3 | 0xF);
                                break;
                            }
                            default: {
                                int n11 = 2293956;
                                String string9 = MessageHandler.getMessage(n11, string, n + i + 1);
                                throw new LDAPException(2, n11, string9);
                            }
                        }
                        ((ByteBuffer)object2).put((byte)n3);
                        continue;
                    }
                    ((ByteBuffer)object2).put(byArray[i]);
                }
                byte[] byArray2 = new byte[((Buffer)object2).position()];
                ((ByteBuffer)object2).flip();
                ((ByteBuffer)object2).get(byArray2);
                arrayList.add(new ASN1OctetString(byArray2));
            } else {
                object2 = new byte[n9];
                System.arraycopy(byArray, n6 + 1, object2, 0, n9);
                arrayList.add(new ASN1OctetString((byte[])object2));
            }
            n6 = n4;
        }
        if (n6 == byArray.length - 1) {
            object = null;
        } else {
            n4 = byArray.length - n6 - 1;
            if (bl) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n4);
                for (int i = n6 + 1; i < byArray.length; ++i) {
                    if (byArray[i] == 92) {
                        if (i + 2 >= byArray.length) {
                            int n12 = 2293956;
                            String string10 = MessageHandler.getMessage(n12, string, n + i + 1);
                            throw new LDAPException(2, n12, string10);
                        }
                        byte by = 0;
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                by = 16;
                                break;
                            }
                            case 50: {
                                by = 32;
                                break;
                            }
                            case 51: {
                                by = 48;
                                break;
                            }
                            case 52: {
                                by = 64;
                                break;
                            }
                            case 53: {
                                by = 80;
                                break;
                            }
                            case 54: {
                                by = 96;
                                break;
                            }
                            case 55: {
                                by = 112;
                                break;
                            }
                            case 56: {
                                by = -128;
                                break;
                            }
                            case 57: {
                                by = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                by = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                by = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                by = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                by = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                by = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                by = -16;
                                break;
                            }
                            default: {
                                n3 = 2293956;
                                String string11 = MessageHandler.getMessage(n3, string, n + i + 1);
                                throw new LDAPException(2, n3, string11);
                            }
                        }
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                by = (byte)(by | 1);
                                break;
                            }
                            case 50: {
                                by = (byte)(by | 2);
                                break;
                            }
                            case 51: {
                                by = (byte)(by | 3);
                                break;
                            }
                            case 52: {
                                by = (byte)(by | 4);
                                break;
                            }
                            case 53: {
                                by = (byte)(by | 5);
                                break;
                            }
                            case 54: {
                                by = (byte)(by | 6);
                                break;
                            }
                            case 55: {
                                by = (byte)(by | 7);
                                break;
                            }
                            case 56: {
                                by = (byte)(by | 8);
                                break;
                            }
                            case 57: {
                                by = (byte)(by | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                by = (byte)(by | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                by = (byte)(by | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                by = (byte)(by | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                by = (byte)(by | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                by = (byte)(by | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                by = (byte)(by | 0xF);
                                break;
                            }
                            default: {
                                n3 = 2293956;
                                String string12 = MessageHandler.getMessage(n3, string, n + i + 1);
                                throw new LDAPException(2, n3, string12);
                            }
                        }
                        byteBuffer.put(by);
                        continue;
                    }
                    byteBuffer.put(byArray[i]);
                }
                byte[] byArray3 = new byte[byteBuffer.position()];
                byteBuffer.flip();
                byteBuffer.get(byArray3);
                object = new ASN1OctetString(byArray3);
            } else {
                byte[] byArray4 = new byte[n4];
                System.arraycopy(byArray, n6 + 1, byArray4, 0, n4);
                object = new ASN1OctetString(byArray4);
            }
        }
        return new LDAPFilter(FilterType.SUBSTRING, null, null, string2, null, aSN1OctetString, arrayList, (ASN1OctetString)object, null, false);
    }

    private static LDAPFilter decodeExtensibleMatchFilter(String string, int n, int n2, int n3) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        assert (Debug.debugEnter(CLASS_NAME, "decodeExtensibleMatchFilter", String.valueOf(string), String.valueOf(n), String.valueOf(n2), String.valueOf(n3)));
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = StaticUtils.toLowerCase(string.substring(n, n2));
        if (string.charAt(n) == ':') {
            if (string4.startsWith(":dn:")) {
                bl = true;
                if (n + 4 < n2 - 1) {
                    string3 = string.substring(n + 4, n2 - 1);
                }
            } else {
                string3 = string.substring(n + 1, n2 - 1);
            }
        } else {
            int n4 = string.indexOf(58, n);
            if (n4 < 0) {
                int n5 = 2293961;
                String string5 = MessageHandler.getMessage(n5, string, n);
                throw new LDAPException(2, n5, string5);
            }
            string2 = string.substring(n, n4);
            if (n4 < n2 - 1) {
                if (string4.startsWith(":dn:", n4)) {
                    bl = true;
                    if (n4 + 4 < n2 - 1) {
                        string3 = string.substring(n4 + 4, n2 - 1);
                    }
                } else {
                    string3 = string.substring(n4 + 1, n2 - 1);
                }
            }
        }
        byte[] byArray = StaticUtils.getBytes(string.substring(n2 + 1, n3));
        boolean bl2 = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 92) {
                    if (i + 2 >= byArray.length) {
                        int n4 = 2293956;
                        String n6 = MessageHandler.getMessage(n4, string, n2 + i + 1);
                        throw new LDAPException(2, n4, n6);
                    }
                    byte by = 0;
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = 16;
                            break;
                        }
                        case 50: {
                            by = 32;
                            break;
                        }
                        case 51: {
                            by = 48;
                            break;
                        }
                        case 52: {
                            by = 64;
                            break;
                        }
                        case 53: {
                            by = 80;
                            break;
                        }
                        case 54: {
                            by = 96;
                            break;
                        }
                        case 55: {
                            by = 112;
                            break;
                        }
                        case 56: {
                            by = -128;
                            break;
                        }
                        case 57: {
                            by = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = -16;
                            break;
                        }
                        default: {
                            int n7 = 2293956;
                            String string8 = MessageHandler.getMessage(n7, string, n2 + i + 1);
                            throw new LDAPException(2, n7, string8);
                        }
                    }
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = (byte)(by | 1);
                            break;
                        }
                        case 50: {
                            by = (byte)(by | 2);
                            break;
                        }
                        case 51: {
                            by = (byte)(by | 3);
                            break;
                        }
                        case 52: {
                            by = (byte)(by | 4);
                            break;
                        }
                        case 53: {
                            by = (byte)(by | 5);
                            break;
                        }
                        case 54: {
                            by = (byte)(by | 6);
                            break;
                        }
                        case 55: {
                            by = (byte)(by | 7);
                            break;
                        }
                        case 56: {
                            by = (byte)(by | 8);
                            break;
                        }
                        case 57: {
                            by = (byte)(by | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = (byte)(by | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = (byte)(by | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = (byte)(by | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = (byte)(by | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = (byte)(by | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = (byte)(by | 0xF);
                            break;
                        }
                        default: {
                            int n5 = 2293956;
                            String string5 = MessageHandler.getMessage(n5, string, n2 + i + 1);
                            throw new LDAPException(2, n5, string5);
                        }
                    }
                    byteBuffer.put(by);
                    continue;
                }
                byteBuffer.put(byArray[i]);
            }
            byArray = new byte[byteBuffer.position()];
            byteBuffer.flip();
            byteBuffer.get(byArray);
            aSN1OctetString = new ASN1OctetString(byArray);
        } else {
            aSN1OctetString = new ASN1OctetString(byArray);
        }
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, string2, aSN1OctetString, null, null, null, string3, bl);
    }

    public FilterType getFilterType() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilterType", new String[0]));
        return this.filterType;
    }

    public ArrayList<LDAPFilter> getFilterComponents() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilterComponents", new String[0]));
        return this.filterComponents;
    }

    public void setFilterComponents(ArrayList<LDAPFilter> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "setFilterComponents", String.valueOf(arrayList)));
        this.filterComponents = arrayList;
    }

    public LDAPFilter getNOTComponent() {
        assert (Debug.debugEnter(CLASS_NAME, "getNOTComponent", new String[0]));
        return this.notComponent;
    }

    public void setNOTComponent(LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "setNOTComponent", String.valueOf(lDAPFilter)));
        this.notComponent = lDAPFilter;
    }

    public String getAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        return this.attributeType;
    }

    public void setAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributeType", String.valueOf(string)));
        this.attributeType = string;
    }

    public ASN1OctetString getAssertionValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getAssertionValue", new String[0]));
        return this.assertionValue;
    }

    public void setAssertionValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setAssertionValue", String.valueOf(aSN1OctetString)));
        this.assertionValue = aSN1OctetString;
    }

    public ASN1OctetString getSubInitialElement() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubInitialElement", new String[0]));
        return this.subInitialElement;
    }

    public void setSubInitialElement(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubInitialElement", String.valueOf(aSN1OctetString)));
        this.subInitialElement = aSN1OctetString;
    }

    public ArrayList<ASN1OctetString> getSubAnyElements() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubAnyElements", new String[0]));
        return this.subAnyElements;
    }

    public void setSubAnyElements(ArrayList<ASN1OctetString> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubAnyElements", String.valueOf(arrayList)));
        this.subAnyElements = arrayList;
    }

    public ASN1OctetString getSubFinalElement() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubFinalElement", new String[0]));
        return this.subFinalElement;
    }

    public void setSubFinalElement(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubFinalElement", String.valueOf(aSN1OctetString)));
        this.subFinalElement = aSN1OctetString;
    }

    public String getMatchingRuleID() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleID", new String[0]));
        return this.matchingRuleID;
    }

    public void setMatchingRuleID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchingRuleID", String.valueOf(string)));
        this.matchingRuleID = string;
    }

    public boolean getDNAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getDNAttributes", new String[0]));
        return this.dnAttributes;
    }

    public void setDNAttributes(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setDNAttributes", String.valueOf(bl)));
        this.dnAttributes = bl;
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        switch (this.filterType) {
            case AND: 
            case OR: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(this.filterComponents.size());
                for (LDAPFilter lDAPFilter : this.filterComponents) {
                    arrayList.add(lDAPFilter.encode());
                }
                return new ASN1Set(this.filterType.getBERType(), arrayList);
            }
            case NOT: {
                return new ASN1Element(this.filterType.getBERType(), this.notComponent.encode().encode());
            }
            case EQUALITY: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case APPROXIMATE_MATCH: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
                arrayList.add(new ASN1OctetString(this.attributeType));
                arrayList.add(this.assertionValue);
                return new ASN1Sequence(this.filterType.getBERType(), arrayList);
            }
            case SUBSTRING: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
                arrayList.add(new ASN1OctetString(this.attributeType));
                ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>();
                if (this.subInitialElement != null) {
                    this.subInitialElement.setType((byte)-128);
                    arrayList2.add(this.subInitialElement);
                }
                if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
                    for (ASN1OctetString aSN1OctetString : this.subAnyElements) {
                        aSN1OctetString.setType((byte)-127);
                        arrayList2.add(aSN1OctetString);
                    }
                }
                if (this.subFinalElement != null) {
                    this.subFinalElement.setType((byte)-126);
                    arrayList2.add(this.subFinalElement);
                }
                arrayList.add(new ASN1Sequence(arrayList2));
                return new ASN1Sequence(this.filterType.getBERType(), arrayList);
            }
            case PRESENT: {
                return new ASN1OctetString(this.filterType.getBERType(), this.attributeType);
            }
            case EXTENSIBLE_MATCH: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(4);
                if (this.matchingRuleID != null) {
                    arrayList.add(new ASN1OctetString(-127, this.matchingRuleID));
                }
                if (this.attributeType != null) {
                    arrayList.add(new ASN1OctetString(-126, this.attributeType));
                }
                this.assertionValue.setType((byte)-125);
                arrayList.add(this.assertionValue);
                if (this.dnAttributes) {
                    arrayList.add(new ASN1Boolean(-124, true));
                }
                return new ASN1Sequence(this.filterType.getBERType(), arrayList);
            }
        }
        assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.ERROR, CLASS_NAME, "encode", "Invalid search filter type:  " + (Object)((Object)this.filterType)));
        return null;
    }

    public static LDAPFilter decode(ASN1Element aSN1Element) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293898;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        switch (aSN1Element.getType()) {
            case -96: 
            case -95: {
                return LDAPFilter.decodeCompoundFilter(aSN1Element);
            }
            case -94: {
                return LDAPFilter.decodeNotFilter(aSN1Element);
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                return LDAPFilter.decodeTypeAndValueFilter(aSN1Element);
            }
            case -92: {
                return LDAPFilter.decodeSubstringFilter(aSN1Element);
            }
            case -121: {
                return LDAPFilter.decodePresenceFilter(aSN1Element);
            }
            case -87: {
                return LDAPFilter.decodeExtensibleMatchFilter(aSN1Element);
            }
        }
        int n = 2293899;
        String string = MessageHandler.getMessage(n, aSN1Element.getType());
        throw new LDAPException(2, n, string);
    }

    private static LDAPFilter decodeCompoundFilter(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        FilterType filterType;
        assert (Debug.debugEnter(CLASS_NAME, "decodeCompoundFilter", String.valueOf(aSN1Element)));
        switch (aSN1Element.getType()) {
            case -96: {
                filterType = FilterType.AND;
                break;
            }
            case -95: {
                filterType = FilterType.OR;
                break;
            }
            default: {
                assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.ERROR, CLASS_NAME, "decodeCompoundFilter", "Invalid filter type " + StaticUtils.byteToHex(aSN1Element.getType()) + " for a compound filter"));
                filterType = null;
            }
        }
        try {
            arrayList = aSN1Element.decodeAsSet().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompoundFilter", exception));
            int n = 2293900;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        ArrayList<LDAPFilter> arrayList2 = new ArrayList<LDAPFilter>(arrayList.size());
        try {
            for (ASN1Element aSN1Element2 : arrayList) {
                arrayList2.add(LDAPFilter.decode(aSN1Element2));
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompoundFilter", exception));
            int n = 2293901;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        return new LDAPFilter(filterType, arrayList2, null, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeNotFilter(ASN1Element aSN1Element) throws LDAPException {
        LDAPFilter lDAPFilter;
        ASN1Element aSN1Element2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeNotFilter", String.valueOf(aSN1Element)));
        try {
            aSN1Element2 = ASN1Element.decode(aSN1Element.value());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeNotFilter", exception));
            int n = 2293902;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        try {
            lDAPFilter = LDAPFilter.decode(aSN1Element2);
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeNotFilter", exception));
            int n = 2293903;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        return new LDAPFilter(FilterType.NOT, null, lDAPFilter, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeTypeAndValueFilter(ASN1Element aSN1Element) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        String string;
        ArrayList<ASN1Element> arrayList;
        FilterType filterType;
        assert (Debug.debugEnter(CLASS_NAME, "decodeTypeAndValueFilter", String.valueOf(aSN1Element)));
        switch (aSN1Element.getType()) {
            case -93: {
                filterType = FilterType.EQUALITY;
                break;
            }
            case -91: {
                filterType = FilterType.GREATER_OR_EQUAL;
                break;
            }
            case -90: {
                filterType = FilterType.LESS_OR_EQUAL;
                break;
            }
            case -88: {
                filterType = FilterType.APPROXIMATE_MATCH;
                break;
            }
            default: {
                assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.ERROR, CLASS_NAME, "decodeTypeAndValueFilter", "Invalid filter type " + StaticUtils.byteToHex(aSN1Element.getType()) + " for a type-and-value filter"));
                filterType = null;
            }
        }
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeTypeAndValueFilter", exception));
            int n = 2293904;
            String string2 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string2, exception);
        }
        if (arrayList.size() != 2) {
            int n = 2293905;
            String string3 = MessageHandler.getMessage(n, arrayList.size());
            throw new LDAPException(2, n, string3);
        }
        try {
            string = arrayList.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeTypeAndValueFilter", exception));
            int n = 2293906;
            String string4 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string4, exception);
        }
        try {
            aSN1OctetString = arrayList.get(1).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeTypeAndValueFilter", exception));
            int n = 2293907;
            String string5 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string5, exception);
        }
        return new LDAPFilter(filterType, null, null, string, aSN1OctetString, null, null, null, null, false);
    }

    private static LDAPFilter decodeSubstringFilter(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        String string;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeSubstringFilter", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSubstringFilter", exception));
            int n = 2293908;
            String string2 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string2, exception);
        }
        if (arrayList2.size() != 2) {
            int n = 2293909;
            String string3 = MessageHandler.getMessage(n, arrayList2.size());
            throw new LDAPException(2, n, string3);
        }
        try {
            string = arrayList2.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSubstringFilter", exception));
            int n = 2293910;
            String string4 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string4, exception);
        }
        try {
            arrayList = arrayList2.get(1).decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSubstringFilter", exception));
            int n = 2293911;
            String string5 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string5, exception);
        }
        if (arrayList.isEmpty()) {
            int n = 2293912;
            String string6 = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string6);
        }
        ASN1OctetString aSN1OctetString = null;
        ASN1OctetString aSN1OctetString2 = null;
        ArrayList<ASN1OctetString> arrayList3 = null;
        try {
            block14: for (ASN1Element aSN1Element2 : arrayList) {
                switch (aSN1Element2.getType()) {
                    case -128: {
                        aSN1OctetString = aSN1Element2.decodeAsOctetString();
                        continue block14;
                    }
                    case -126: {
                        aSN1OctetString2 = aSN1Element2.decodeAsOctetString();
                        continue block14;
                    }
                    case -127: {
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList<ASN1OctetString>();
                        }
                        arrayList3.add(aSN1Element2.decodeAsOctetString());
                        continue block14;
                    }
                }
                int n = 2293913;
                String string7 = MessageHandler.getMessage(n);
                throw new LDAPException(2, n, string7);
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSubstringFilter", exception));
            int n = 2293914;
            String string8 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string8, exception);
        }
        return new LDAPFilter(FilterType.SUBSTRING, null, null, string, null, aSN1OctetString, arrayList3, aSN1OctetString2, null, false);
    }

    private static LDAPFilter decodePresenceFilter(ASN1Element aSN1Element) throws LDAPException {
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "decodePresenceFilter", String.valueOf(aSN1Element)));
        try {
            string = aSN1Element.decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodePresenceFilter", exception));
            int n = 2293915;
            String string2 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string2, exception);
        }
        return new LDAPFilter(FilterType.PRESENT, null, null, string, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeExtensibleMatchFilter(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeExtensibleMatchFilter", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSubstringFilter", exception));
            int n = 2293916;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        ASN1OctetString aSN1OctetString = null;
        boolean bl = false;
        String string = null;
        String string2 = null;
        try {
            block11: for (ASN1Element aSN1Element2 : arrayList) {
                switch (aSN1Element2.getType()) {
                    case -127: {
                        string2 = aSN1Element2.decodeAsOctetString().stringValue();
                        continue block11;
                    }
                    case -126: {
                        string = aSN1Element2.decodeAsOctetString().stringValue();
                        continue block11;
                    }
                    case -125: {
                        aSN1OctetString = aSN1Element2.decodeAsOctetString();
                        continue block11;
                    }
                    case -124: {
                        bl = aSN1Element2.decodeAsBoolean().booleanValue();
                        continue block11;
                    }
                }
                int n = 2293917;
                String string3 = MessageHandler.getMessage(n, aSN1Element2.getType());
                throw new LDAPException(2, n, string3);
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSubstringFilter", exception));
            int n = 2293918;
            String string4 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string4, exception);
        }
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, string, aSN1OctetString, null, null, null, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public SearchFilter toSearchFilter() {
        void var3_10;
        Object object;
        HashSet<String> hashSet;
        ArrayList<SearchFilter> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "toSearchFilter", new String[0]));
        if (this.filterComponents == null) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<SearchFilter>(this.filterComponents.size());
            for (LDAPFilter object22 : this.filterComponents) {
                arrayList.add(object22.toSearchFilter());
            }
        }
        SearchFilter searchFilter = this.notComponent == null ? null : this.notComponent.toSearchFilter();
        if (this.attributeType == null) {
            Object var3_4 = null;
            hashSet = null;
        } else {
            int n = this.attributeType.indexOf(59);
            if (n > 0) {
                object = this.attributeType.substring(0, n);
                AttributeType attributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase((String)object));
                if (attributeType == null) {
                    AttributeType attributeType2 = DirectoryServer.getDefaultAttributeType((String)object);
                }
                hashSet = new HashSet<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(this.attributeType.substring(n + 1), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    hashSet.add(stringTokenizer.nextToken());
                }
            } else {
                hashSet = null;
                AttributeType attributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(this.attributeType));
                if (attributeType == null) {
                    AttributeType attributeType3 = DirectoryServer.getDefaultAttributeType(this.attributeType);
                }
            }
        }
        AttributeValue attributeValue = new AttributeValue((AttributeType)var3_10, (ByteString)this.assertionValue);
        object = this.subAnyElements == null ? null : new ArrayList<ASN1OctetString>(this.subAnyElements);
        return new SearchFilter(this.filterType, arrayList, searchFilter, (AttributeType)var3_10, hashSet, attributeValue, this.subInitialElement, (List<ByteString>)object, this.subFinalElement, this.matchingRuleID, this.dnAttributes);
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        switch (this.filterType) {
            case AND: {
                stringBuilder.append("(&");
                for (LDAPFilter lDAPFilter : this.filterComponents) {
                    lDAPFilter.toString(stringBuilder);
                }
                stringBuilder.append(")");
                break;
            }
            case OR: {
                stringBuilder.append("(|");
                for (LDAPFilter lDAPFilter : this.filterComponents) {
                    lDAPFilter.toString(stringBuilder);
                }
                stringBuilder.append(")");
                break;
            }
            case NOT: {
                stringBuilder.append("(!");
                this.notComponent.toString(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case EQUALITY: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType);
                stringBuilder.append("=");
                LDAPFilter.valueToFilterString(stringBuilder, this.assertionValue);
                stringBuilder.append(")");
                break;
            }
            case SUBSTRING: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType);
                stringBuilder.append("=");
                if (this.subInitialElement != null) {
                    LDAPFilter.valueToFilterString(stringBuilder, this.subInitialElement);
                }
                if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
                    for (ASN1OctetString aSN1OctetString : this.subAnyElements) {
                        stringBuilder.append("*");
                        LDAPFilter.valueToFilterString(stringBuilder, aSN1OctetString);
                    }
                }
                stringBuilder.append("*");
                if (this.subFinalElement != null) {
                    LDAPFilter.valueToFilterString(stringBuilder, this.subFinalElement);
                }
                stringBuilder.append(")");
                break;
            }
            case GREATER_OR_EQUAL: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType);
                stringBuilder.append(">=");
                LDAPFilter.valueToFilterString(stringBuilder, this.assertionValue);
                stringBuilder.append(")");
                break;
            }
            case LESS_OR_EQUAL: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType);
                stringBuilder.append("<=");
                LDAPFilter.valueToFilterString(stringBuilder, this.assertionValue);
                stringBuilder.append(")");
                break;
            }
            case PRESENT: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType);
                stringBuilder.append("=*)");
                break;
            }
            case APPROXIMATE_MATCH: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType);
                stringBuilder.append("~=");
                LDAPFilter.valueToFilterString(stringBuilder, this.assertionValue);
                stringBuilder.append(")");
                break;
            }
            case EXTENSIBLE_MATCH: {
                stringBuilder.append("(");
                if (this.attributeType != null) {
                    stringBuilder.append(this.attributeType);
                }
                if (this.dnAttributes) {
                    stringBuilder.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    stringBuilder.append(":");
                    stringBuilder.append(this.matchingRuleID);
                }
                stringBuilder.append(":=");
                LDAPFilter.valueToFilterString(stringBuilder, this.assertionValue);
                stringBuilder.append(")");
            }
        }
    }

    public static void valueToFilterString(StringBuilder stringBuilder, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "valueToFilterString", "java.lang.StringBuilder", String.valueOf(aSN1OctetString)));
        if (aSN1OctetString == null) {
            return;
        }
        byte[] byArray = aSN1OctetString.value();
        stringBuilder.ensureCapacity(stringBuilder.length() + byArray.length);
        for (byte by : byArray) {
            if ((by & 0x7F) != by || by <= 31 || by == 40 || by == 41 || by == 42 || by == 92 || by == 127) {
                stringBuilder.append("\\");
                stringBuilder.append(StaticUtils.byteToHex(by));
                continue;
            }
            stringBuilder.append((char)by);
        }
    }
}

