/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultEntryProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.SearchResultEntryProtocolOp";
    private LinkedList<LDAPAttribute> attributes;
    private DN dn;

    public SearchResultEntryProtocolOp(DN dN) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN)));
        this.dn = dN;
        this.attributes = new LinkedList();
    }

    public SearchResultEntryProtocolOp(DN dN, LinkedList<LDAPAttribute> linkedList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(linkedList)));
        this.dn = dN;
        this.attributes = linkedList == null ? new LinkedList() : linkedList;
    }

    public SearchResultEntryProtocolOp(SearchResultEntry searchResultEntry) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(searchResultEntry)));
        this.dn = searchResultEntry.getDN();
        this.attributes = new LinkedList();
        Attribute attribute = searchResultEntry.getObjectClassAttribute();
        if (attribute != null) {
            this.attributes.add(new LDAPAttribute(attribute));
        }
        for (List<Attribute> list : searchResultEntry.getUserAttributes().values()) {
            for (Attribute attribute2 : list) {
                this.attributes.add(new LDAPAttribute(attribute2));
            }
        }
        for (List<Attribute> list : searchResultEntry.getOperationalAttributes().values()) {
            for (Attribute attribute2 : list) {
                this.attributes.add(new LDAPAttribute(attribute2));
            }
        }
    }

    public DN getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(dN)));
        this.dn = dN;
    }

    public LinkedList<LDAPAttribute> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return this.attributes;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 100;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Search Result Entry";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(new ASN1OctetString(this.dn.toString()));
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.attributes.size());
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            arrayList2.add(lDAPAttribute.encode());
        }
        arrayList.add(new ASN1Sequence(arrayList2));
        return new ASN1Sequence(100, arrayList);
    }

    public static SearchResultEntryProtocolOp decodeSearchEntry(ASN1Element aSN1Element) throws LDAPException {
        LinkedList<LDAPAttribute> linkedList;
        DN dN;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeSearchEntry", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchEntry", exception));
            int n = 2293878;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList.size();
        if (n != 2) {
            int n2 = 2293879;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        try {
            dN = DN.decode(arrayList.get(0).decodeAsOctetString().stringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchEntry", exception));
            int n3 = 2293880;
            String string = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string, exception);
        }
        try {
            ArrayList<ASN1Element> arrayList2 = arrayList.get(1).decodeAsSequence().elements();
            linkedList = new LinkedList<LDAPAttribute>();
            for (ASN1Element aSN1Element2 : arrayList2) {
                linkedList.add(LDAPAttribute.decode(aSN1Element2));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchEntry", exception));
            int n4 = 2293881;
            String string = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string, exception);
        }
        return new SearchResultEntryProtocolOp(dN, linkedList);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("SearchResultEntry(dn=");
        this.dn.toString(stringBuilder);
        stringBuilder.append(", attrs={");
        if (!this.attributes.isEmpty()) {
            Iterator iterator = this.attributes.iterator();
            ((LDAPAttribute)iterator.next()).toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                ((LDAPAttribute)iterator.next()).toString(stringBuilder);
            }
        }
        stringBuilder.append("})");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Search Result Entry");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  DN:  ");
        this.dn.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("  Attributes:");
        stringBuilder.append(ServerConstants.EOL);
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            lDAPAttribute.toString(stringBuilder, n + 4);
        }
    }

    public void toLDIF(StringBuilder stringBuilder, int n) {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", "java.lang.StringBuilder", String.valueOf(n)));
        String string = this.dn.toString();
        if (StaticUtils.needsBase64Encoding(string)) {
            string = Base64.encode(StaticUtils.getBytes(string));
            stringBuilder.append("dn:: ");
            n2 = n - 5;
        } else {
            stringBuilder.append("dn: ");
            n2 = n - 4;
        }
        int n3 = string.length();
        if (n3 <= n2 || n2 <= 0) {
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        } else {
            stringBuilder.append(string.substring(0, n2));
            stringBuilder.append(ServerConstants.EOL);
            int n4 = n2;
            while (n3 - n4 > n - 1) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4, n4 + n - 1));
                stringBuilder.append(ServerConstants.EOL);
                n4 += n - 1;
            }
            if (n4 < n3) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            String string2 = lDAPAttribute.getAttributeType();
            int n5 = string2.length();
            for (ASN1OctetString aSN1OctetString : lDAPAttribute.getValues()) {
                String string3;
                if (StaticUtils.needsBase64Encoding(aSN1OctetString.value())) {
                    string3 = Base64.encode(aSN1OctetString.value());
                    stringBuilder.append(string2);
                    stringBuilder.append(":: ");
                    n2 = n - n5 - 3;
                } else {
                    string3 = aSN1OctetString.stringValue();
                    stringBuilder.append(string2);
                    stringBuilder.append(": ");
                    n2 = n - n5 - 2;
                }
                int n6 = string3.length();
                if (n6 <= n2 || n2 <= 0) {
                    stringBuilder.append(string3);
                    stringBuilder.append(ServerConstants.EOL);
                    continue;
                }
                stringBuilder.append(string3.substring(0, n2));
                stringBuilder.append(ServerConstants.EOL);
                int n7 = n2;
                while (n6 - n7 > n - 1) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string3.substring(n7, n7 + n - 1));
                    stringBuilder.append(ServerConstants.EOL);
                    n7 += n - 1;
                }
                if (n7 >= n6) continue;
                stringBuilder.append(" ");
                stringBuilder.append(string3.substring(n7));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append(ServerConstants.EOL);
    }

    /*
     * WARNING - void declaration
     */
    public SearchResultEntry toSearchResultEntry() throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "toSearchResultEntry", new String[0]));
        HashMap<ObjectClass, String> hashMap = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> hashMap3 = new HashMap<AttributeType, List<Attribute>>();
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            List<Attribute> list;
            Attribute attribute = lDAPAttribute.toAttribute();
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.isObjectClassType()) {
                for (ASN1OctetString aSN1OctetString : lDAPAttribute.getValues()) {
                    void var11_15;
                    String string = aSN1OctetString.toString();
                    ObjectClass objectClass = DirectoryServer.getObjectClass(StaticUtils.toLowerCase(string));
                    if (objectClass == null) {
                        ObjectClass objectClass2 = DirectoryServer.getDefaultObjectClass(string);
                    }
                    hashMap.put((ObjectClass)var11_15, string);
                }
                continue;
            }
            if (attributeType.isOperational()) {
                list = hashMap3.get(attributeType);
                if (list == null) {
                    list = new ArrayList<Attribute>(1);
                    list.add(attribute);
                    hashMap3.put(attributeType, list);
                    continue;
                }
                list.add(attribute);
                continue;
            }
            list = hashMap2.get(attributeType);
            if (list == null) {
                list = new ArrayList<Attribute>(1);
                list.add(attribute);
                hashMap2.put(attributeType, list);
                continue;
            }
            boolean bl = false;
            for (Attribute attribute2 : list) {
                if (!attribute2.optionsEqual(attribute.getOptions())) continue;
                LinkedHashSet<AttributeValue> linkedHashSet = attribute2.getValues();
                linkedHashSet.addAll(attribute.getValues());
                bl = true;
            }
            if (bl) continue;
            list.add(attribute);
        }
        Entry entry = new Entry(this.dn, hashMap, hashMap2, hashMap3);
        return new SearchResultEntry(entry);
    }
}

