/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;

public class AuthPasswordEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.AuthPasswordEqualityMatchingRule";

    public AuthPasswordEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "authPasswordMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.4203.1.2.3";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "authentication password matching rule";
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        byte[] byArray = byteString.value();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return new ASN1OctetString(byArray2);
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }

    public ConditionResult valuesMatch(ByteString byteString, ByteString byteString2) {
        StringBuilder[] stringBuilderArray;
        assert (Debug.debugEnter(CLASS_NAME, "valuesMatch", String.valueOf(byteString), String.valueOf(byteString2)));
        try {
            stringBuilderArray = AuthPasswordSyntax.decodeAuthPassword(byteString.stringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valuesMatch", exception));
            return ConditionResult.FALSE;
        }
        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getAuthPasswordStorageScheme(stringBuilderArray[0].toString());
        if (passwordStorageScheme == null) {
            return ConditionResult.FALSE;
        }
        if (passwordStorageScheme.authPasswordMatches(byteString2, stringBuilderArray[1].toString(), stringBuilderArray[2].toString())) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "generateHashCode", String.valueOf(attributeValue)));
        return 1;
    }
}

