/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Schema;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectClassSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.ObjectClassSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public ObjectClassSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "ObjectClassDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "ObjectClassDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "ObjectClassDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "ObjectClassDescription";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.37";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Object Class Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        try {
            ObjectClassSyntax.decodeObjectClass(byteString, DirectoryServer.getSchema());
            return true;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ObjectClass decodeObjectClass(ByteString byteString, Schema schema) throws DirectoryException {
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeObjectClass", String.valueOf(byteString)));
        String string = byteString.stringValue();
        String string2 = StaticUtils.toLowerCase(string);
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        if (n >= n2) {
            int n3 = 6488133;
            String string3 = MessageHandler.getMessage(n3);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if ((c = string.charAt(n++)) != '(') {
            int n4 = 6488134;
            String string4 = MessageHandler.getMessage(n4, string, n - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488135;
            String string5 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        int n6 = n;
        if (!StaticUtils.isDigit(c)) {
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int n7 = 6488138;
                String string6 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n7);
            }
        } else {
            boolean bl = false;
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (bl) {
                        int n8 = 6488136;
                        String string7 = MessageHandler.getMessage(n8, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n8);
                    }
                    bl = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int n9 = 6488137;
                    String string8 = MessageHandler.getMessage(n9, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n9);
                }
                bl = false;
            }
        }
        if (n >= n2) {
            int n10 = 6488135;
            String string9 = MessageHandler.getMessage(n10, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n10);
        }
        String string10 = string2.substring(n6, n - 1);
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n11 = 6488135;
            String string11 = MessageHandler.getMessage(n11, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string11, n11);
        }
        String string12 = string10;
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        String string13 = null;
        boolean bl = false;
        ObjectClass objectClass = DirectoryServer.getTopObjectClass();
        CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet = new CopyOnWriteArraySet<AttributeType>();
        CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2 = new CopyOnWriteArraySet<AttributeType>();
        ObjectClassType objectClassType = objectClass.getObjectClassType();
        ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2 = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>();
        block5: while (true) {
            Serializable serializable;
            block38: {
                StringBuilder stringBuilder;
                String string14;
                int n12;
                Object object;
                block46: {
                    block37: {
                        StringBuilder stringBuilder2;
                        block44: {
                            block42: {
                                block40: {
                                    String string15;
                                    block45: {
                                        String string16;
                                        block43: {
                                            block41: {
                                                block39: {
                                                    StringBuilder stringBuilder3 = new StringBuilder();
                                                    n = ObjectClassSyntax.readTokenName(string, stringBuilder3, n);
                                                    string15 = stringBuilder3.toString();
                                                    string16 = StaticUtils.toLowerCase(string15);
                                                    if (!string15.equals(")")) break block39;
                                                    if (n < n2) {
                                                        int n13 = 6488140;
                                                        String string17 = MessageHandler.getMessage(n13, string, n - 1);
                                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string17, n13);
                                                    }
                                                    break block40;
                                                }
                                                if (!string16.equals("name")) break block41;
                                                if ((c = string.charAt(n++)) == '\'') {
                                                    serializable = new StringBuilder();
                                                    StringBuilder stringBuilder4 = new StringBuilder();
                                                    n = ObjectClassSyntax.readQuotedString(string, string2, (StringBuilder)serializable, stringBuilder4, n - 1);
                                                    string12 = ((StringBuilder)serializable).toString();
                                                    concurrentHashMap.put(stringBuilder4.toString(), string12);
                                                    continue;
                                                }
                                                if (c != '(') {
                                                    int n14 = 6488139;
                                                    String string18 = MessageHandler.getMessage(n14, string, Character.valueOf(c), n - 1);
                                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string18, n14);
                                                }
                                                break block42;
                                            }
                                            if (string16.equals("desc")) {
                                                serializable = new StringBuilder();
                                                n = ObjectClassSyntax.readQuotedString(string, (StringBuilder)serializable, n);
                                                string13 = ((StringBuilder)serializable).toString();
                                                continue;
                                            }
                                            if (string16.equals("obsolete")) {
                                                bl = true;
                                                continue;
                                            }
                                            if (string16.equals("sup")) {
                                                serializable = new StringBuilder();
                                                n = ObjectClassSyntax.readWOID(string2, (StringBuilder)serializable, n);
                                                objectClass = schema.getObjectClass(((StringBuilder)serializable).toString());
                                                if (objectClass == null) {
                                                    int n15 = 6422606;
                                                    object = MessageHandler.getMessage(n15, String.valueOf(string10), String.valueOf(serializable));
                                                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, (String)object, n15);
                                                    objectClass = DirectoryServer.getTopObjectClass();
                                                }
                                                objectClassType = objectClass.getObjectClassType();
                                                continue;
                                            }
                                            if (string16.equals("abstract")) {
                                                objectClassType = ObjectClassType.ABSTRACT;
                                                continue;
                                            }
                                            if (string16.equals("structural")) {
                                                objectClassType = ObjectClassType.STRUCTURAL;
                                                continue;
                                            }
                                            if (string16.equals("auxiliary")) {
                                                objectClassType = ObjectClassType.AUXILIARY;
                                                continue;
                                            }
                                            if (!string16.equals("must")) break block43;
                                            serializable = new LinkedList();
                                            if ((c = string.charAt(n++)) == '(') break block44;
                                            stringBuilder2 = new StringBuilder();
                                            n = ObjectClassSyntax.readWOID(string2, stringBuilder2, n - 1);
                                            object = schema.getAttributeType(stringBuilder2.toString());
                                            if (object == null) {
                                                n12 = 6422608;
                                                string14 = MessageHandler.getMessage(n12, string10, stringBuilder2.toString());
                                                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string14, n12);
                                                object = DirectoryServer.getDefaultAttributeType(stringBuilder2.toString());
                                            }
                                            ((LinkedList)serializable).add(object);
                                            break block37;
                                        }
                                        if (!string16.equals("may")) break block45;
                                        serializable = new LinkedList();
                                        if ((c = string.charAt(n++)) == '(') break block46;
                                        stringBuilder = new StringBuilder();
                                        n = ObjectClassSyntax.readWOID(string2, stringBuilder, n - 1);
                                        object = schema.getAttributeType(stringBuilder.toString());
                                        if (object == null) {
                                            n12 = 6422609;
                                            string14 = MessageHandler.getMessage(n12, string10, stringBuilder.toString());
                                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string14, n12);
                                            object = DirectoryServer.getDefaultAttributeType(stringBuilder.toString());
                                        }
                                        ((LinkedList)serializable).add(object);
                                        break block38;
                                    }
                                    serializable = new CopyOnWriteArrayList();
                                    n = ObjectClassSyntax.readExtraParameterValues(string, (CopyOnWriteArrayList<String>)serializable, n);
                                    concurrentHashMap2.put(string15, (CopyOnWriteArrayList<String>)serializable);
                                    continue;
                                }
                                if (objectClass.getOID().equals(string10)) {
                                    objectClass = null;
                                }
                                return new ObjectClass(string12, concurrentHashMap, string10, string13, objectClass, copyOnWriteArraySet, copyOnWriteArraySet2, objectClassType, bl, concurrentHashMap2);
                            }
                            serializable = new StringBuilder();
                            StringBuilder stringBuilder5 = new StringBuilder();
                            n = ObjectClassSyntax.readQuotedString(string, string2, (StringBuilder)serializable, stringBuilder5, n);
                            string12 = ((StringBuilder)serializable).toString();
                            concurrentHashMap.put(stringBuilder5.toString(), string12);
                            while (true) {
                                if (string.charAt(n) == ')') {
                                    ++n;
                                    while (true) {
                                        if (n >= n2 || (c = string.charAt(n)) != ' ') continue block5;
                                        ++n;
                                    }
                                }
                                serializable = new StringBuilder();
                                stringBuilder5 = new StringBuilder();
                                n = ObjectClassSyntax.readQuotedString(string, string2, (StringBuilder)serializable, stringBuilder5, n);
                                concurrentHashMap.put(stringBuilder5.toString(), ((StringBuilder)serializable).toString());
                            }
                        }
                        do {
                            stringBuilder2 = new StringBuilder();
                            n = ObjectClassSyntax.readWOID(string2, stringBuilder2, n);
                            object = schema.getAttributeType(stringBuilder2.toString());
                            if (object == null) {
                                n12 = 6422608;
                                string14 = MessageHandler.getMessage(n12, string10, stringBuilder2.toString());
                                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string14, n12);
                                object = DirectoryServer.getDefaultAttributeType(stringBuilder2.toString());
                            }
                            ((LinkedList)serializable).add(object);
                            c = string.charAt(n++);
                            if (c == ')') break block37;
                        } while (c == '$');
                        n12 = 6488139;
                        string14 = MessageHandler.getMessage(n12, string, Character.valueOf(c), n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string14, n12);
                    }
                    copyOnWriteArraySet.addAll((Collection<AttributeType>)((Object)serializable));
                    continue;
                }
                do {
                    stringBuilder = new StringBuilder();
                    n = ObjectClassSyntax.readWOID(string2, stringBuilder, n);
                    object = schema.getAttributeType(stringBuilder.toString());
                    if (object == null) {
                        n12 = 6422609;
                        string14 = MessageHandler.getMessage(n12, string10, stringBuilder.toString());
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string14, n12);
                        object = DirectoryServer.getDefaultAttributeType(stringBuilder.toString());
                    }
                    ((LinkedList)serializable).add(object);
                    c = string.charAt(n++);
                    if (c == ')') break block38;
                } while (c == '$');
                n12 = 6488139;
                string14 = MessageHandler.getMessage(n12, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string14, n12);
            }
            copyOnWriteArraySet2.addAll((Collection<AttributeType>)((Object)serializable));
        }
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488135;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488135;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6422607;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488135;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }

    private static int readQuotedString(String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder", "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string2.length();
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488135;
            String string3 = MessageHandler.getMessage(n3, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if (c != '\'') {
            int n4 = 6422607;
            String string4 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) != '\'') {
            stringBuilder2.append(c);
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488135;
            String string5 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        return n;
    }

    private static int readWOID(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "readWOID", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n3 = string.length();
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            int n4 = 6488135;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (StaticUtils.isDigit(c)) {
            n2 = 0;
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (n2 != 0) {
                        int n5 = 6488136;
                        String string3 = MessageHandler.getMessage(n5, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n5);
                    }
                    stringBuilder.append(c);
                    n2 = 1;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return n - 1;
                    }
                    int n6 = 6488137;
                    String string4 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
                }
                stringBuilder.append(c);
                n2 = 0;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    return n - 1;
                }
                int n7 = 6488138;
                String string5 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
            }
        } else {
            int n8 = 6488139;
            String string6 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n8);
        }
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            n2 = 6488135;
            String string7 = MessageHandler.getMessage(n2, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n2);
        }
        return n;
    }

    private static int readExtraParameterValues(String string, CopyOnWriteArrayList<String> copyOnWriteArrayList, int n) throws DirectoryException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "readExtraParameterValues", String.valueOf(string), "java.util.concurrent.CopyOnWriteArrayList<String>", String.valueOf(n)));
        int n2 = string.length();
        char c = string.charAt(n++);
        while (n < n2 && c == ' ') {
            c = string.charAt(n++);
        }
        if (n >= n2) {
            int n3 = 6488135;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c == '\'') {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != '\'') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        } else if (c == '(') {
            while (true) {
                ++n;
                while (n < n2 && (c = string.charAt(n)) == ' ') {
                    ++n;
                }
                if (n >= n2) {
                    int n4 = 6488135;
                    String string3 = MessageHandler.getMessage(n4, string);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                }
                if (c != ')') {
                    if (c == '(') {
                        int n5 = 6488139;
                        String string4 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                    n = ObjectClassSyntax.readExtraParameterValues(string, copyOnWriteArrayList, n);
                    continue;
                }
                break;
            }
        } else {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 6488135;
            String string5 = MessageHandler.getMessage(n6, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n6);
        }
        return n;
    }
}

