/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class OtherMailboxSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.OtherMailboxSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public OtherMailboxSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.11");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.11", "OtherMailbox");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.12");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.12", "OtherMailbox");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "OtherMailbox";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.39";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Other Mailbox";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return null;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        if (byteString == null) {
            int n2 = 6488264;
            stringBuilder.append(MessageHandler.getMessage(n2));
            return false;
        }
        String string = byteString.stringValue();
        int n3 = string.length();
        if (n3 == 0) {
            int n4 = 6488264;
            stringBuilder.append(MessageHandler.getMessage(n4));
            return false;
        }
        for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            if (c == '$') {
                if (n == 0) {
                    int n7 = 6488265;
                    stringBuilder.append(MessageHandler.getMessage(n7, string));
                    return false;
                }
                ++n;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            int n2 = 6488266;
            stringBuilder.append(MessageHandler.getMessage(n2, string, Character.valueOf(c), n));
            return false;
        }
        if (n >= n3) {
            int n4 = 6488267;
            stringBuilder.append(MessageHandler.getMessage(n4, string));
            return false;
        }
        while (n < n3) {
            char c = string.charAt(n);
            if (c != (c & 0x7F)) {
                int n5 = 6488268;
                stringBuilder.append(MessageHandler.getMessage(n5, string, Character.valueOf(c), n));
                return false;
            }
            ++n;
        }
        return true;
    }
}

