/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelephoneNumberSyntax
extends AttributeSyntax
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.schema.TelephoneNumberSyntax";
    private boolean strictMode;
    private DN configEntryDN;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public TelephoneNumberSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.20");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.20", "TelephoneNumber");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.21");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.21", "TelephoneNumber");
        }
        this.strictMode = false;
        if (configEntry != null) {
            this.configEntryDN = configEntry.getDN();
            DirectoryServer.registerConfigurableComponent(this);
            int n = 6291539;
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-strict-telephone-number-format", MessageHandler.getMessage(n), false);
            try {
                BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                if (booleanConfigAttribute2 != null) {
                    this.strictMode = booleanConfigAttribute2.activeValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSyntax", exception));
                n = 6422612;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            }
        }
    }

    @Override
    public void finalizeSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSyntax", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "TelephoneNumber";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.50";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Telephone Number";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        int n;
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        if (byteString == null || (string = byteString.stringValue().trim()).length() == 0) {
            stringBuilder.append(MessageHandler.getMessage(6488149));
            return false;
        }
        int n2 = string.length();
        if (this.strictMode) {
            int n3;
            if (string.charAt(0) != '+') {
                int n4 = 6488150;
                String string2 = MessageHandler.getMessage(n4, string);
                stringBuilder.append(string2);
                return false;
            }
            boolean bl = false;
            for (n3 = 1; n3 < n2; ++n3) {
                char c = string.charAt(n3);
                if (StaticUtils.isDigit(c)) {
                    bl = true;
                    continue;
                }
                if (this.isSeparator(c)) continue;
                int n5 = 6488151;
                String string3 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n3);
                stringBuilder.append(string3);
                return false;
            }
            if (!bl) {
                n3 = 6488152;
                String string4 = MessageHandler.getMessage(n3, string);
                stringBuilder.append(string4);
                return false;
            }
            return true;
        }
        for (n = 0; n < n2; ++n) {
            if (!StaticUtils.isDigit(string.charAt(n))) continue;
            return true;
        }
        n = 6488152;
        String string5 = MessageHandler.getMessage(n, string);
        stringBuilder.append(string5);
        return false;
    }

    private boolean isSeparator(char c) {
        assert (Debug.debugEnter(CLASS_NAME, "isSeparator", String.valueOf(c)));
        switch (c) {
            case ' ': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 6291539;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-strict-telephone-number-format", MessageHandler.getMessage(n), false, this.strictMode));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        int n = 6291539;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-strict-telephone-number-format", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 6422612;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        boolean bl2;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl3 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 6291539;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-strict-telephone-number-format", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            bl2 = booleanConfigAttribute2 == null ? false : booleanConfigAttribute2.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 6422612;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            bl2 = false;
        }
        if (resultCode == ResultCode.SUCCESS && this.strictMode != bl2) {
            this.strictMode = bl2;
            if (bl) {
                n = 6291545;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.strictMode)));
            }
        }
        return new ConfigChangeResult(resultCode, bl3, arrayList);
    }
}

