/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.Operation;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.synchronization.ModifyDnContext;
import org.opends.server.synchronization.OperationContext;
import org.opends.server.synchronization.UpdateMessage;

public class ModifyDNMsg
extends UpdateMessage {
    private String newRDN;
    private String newSuperior;
    private boolean deleteOldRdn;
    private String newSuperiorId;
    private static final long serialVersionUID = -4905520652801395185L;

    public ModifyDNMsg(ModifyDNOperation modifyDNOperation) {
        super((OperationContext)modifyDNOperation.getAttachment("synchronizationContext"), modifyDNOperation.getRawEntryDN().stringValue());
        ModifyDnContext modifyDnContext = (ModifyDnContext)modifyDNOperation.getAttachment("synchronizationContext");
        this.newSuperiorId = modifyDnContext.getNewParentId();
        this.deleteOldRdn = modifyDNOperation.deleteOldRDN();
        this.newSuperior = modifyDNOperation.getRawNewSuperior() != null ? modifyDNOperation.getRawNewSuperior().stringValue() : null;
        this.newRDN = modifyDNOperation.getRawNewRDN().stringValue();
    }

    public ModifyDNMsg(byte[] byArray) throws DataFormatException, UnsupportedEncodingException {
        super(byArray);
        int n = this.decodeHeader((byte)4, byArray);
        int n2 = this.getNextLength(byArray, n);
        this.newRDN = new String(byArray, n, n2, "UTF-8");
        n += n2 + 1;
        n2 = this.getNextLength(byArray, n);
        this.newSuperior = n2 != 0 ? new String(byArray, n, n2, "UTF-8") : null;
        n += n2 + 1;
        n2 = this.getNextLength(byArray, n);
        this.newSuperiorId = n2 != 0 ? new String(byArray, n, n2, "UTF-8") : null;
        this.deleteOldRdn = byArray[n += n2 + 1] != 0;
    }

    public Operation createOperation(InternalClientConnection internalClientConnection, String string) {
        ModifyDNOperation modifyDNOperation = new ModifyDNOperation((ClientConnection)internalClientConnection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(string), new ASN1OctetString(this.newRDN), this.deleteOldRdn, this.newSuperior == null ? null : new ASN1OctetString(this.newSuperior));
        ModifyDnContext modifyDnContext = new ModifyDnContext(this.getChangeNumber(), this.getUniqueId(), this.newSuperiorId);
        modifyDNOperation.setAttachment("synchronizationContext", modifyDnContext);
        return modifyDNOperation;
    }

    public byte[] getBytes() {
        try {
            byte[] byArray = this.newRDN.getBytes("UTF-8");
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = byArray.length + 1 + 1;
            if (this.newSuperior != null) {
                byArray2 = this.newSuperior.getBytes("UTF-8");
                n += byArray2.length + 1;
            } else {
                ++n;
            }
            if (this.newSuperiorId != null) {
                byArray3 = this.newSuperiorId.getBytes("UTF-8");
                n += byArray3.length + 1;
            } else {
                ++n;
            }
            byte[] byArray4 = this.encodeHeader((byte)4, n);
            int n2 = byArray4.length - n;
            n2 = this.addByteArray(byArray, byArray4, n2);
            if (this.newSuperior != null) {
                n2 = this.addByteArray(byArray2, byArray4, n2);
            } else {
                byArray4[n2++] = 0;
            }
            if (this.newSuperiorId != null) {
                n2 = this.addByteArray(byArray3, byArray4, n2);
            } else {
                byArray4[n2++] = 0;
            }
            byArray4[n2++] = this.deleteOldRdn ? (byte)1 : 0;
            return byArray4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        return "Modify DN " + this.getDn() + " " + this.newRDN + " " + this.newSuperior + " " + this.getChangeNumber();
    }

    public void setNewSuperior(String string) {
        this.newSuperior = string;
    }
}

