/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.util.HashMap;
import java.util.Map;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.changelog.Changelog;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.synchronization.Historical;
import org.opends.server.synchronization.ServerState;
import org.opends.server.synchronization.SynchMessages;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SynchronizationProviderResult;

public class MultimasterSynchronization
extends SynchronizationProvider
implements ConfigAddListener,
ConfigDeleteListener,
ConfigChangeListener {
    static String CHANGELOG_DN = "cn=Changelog Server,cn=Multimaster Synchronization, cn=Synchronization Providers, cn=config";
    static String SYNCHRONIZATION_CLASS = "ds-cfg-synchronization-provider-config";
    private DN changelogConfigEntryDn = null;
    private Changelog changelog = null;
    private static Map<DN, SynchronizationDomain> domains = new HashMap<DN, SynchronizationDomain>();

    public static ServerState getServerState(DN dN) {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(dN);
        return synchronizationDomain.getServerState();
    }

    public void initializeSynchronizationProvider(ConfigEntry configEntry) throws ConfigException {
        SynchMessages.registerMessages();
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        try {
            this.changelogConfigEntryDn = DN.decode(CHANGELOG_DN);
            ConfigEntry configEntry2 = DirectoryServer.getConfigEntry(this.changelogConfigEntryDn);
            if (configEntry2 != null) {
                this.changelog = new Changelog(configEntry2);
            }
        }
        catch (DirectoryException directoryException) {
            throw new ConfigException(0x1030001, "Invalid Changelog configuration DN");
        }
        for (ConfigEntry configEntry3 : configEntry.getChildren().values()) {
            if (!configEntry3.hasObjectClass(SYNCHRONIZATION_CLASS)) continue;
            this.createNewSynchronizationDomain(configEntry3);
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        return false;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        try {
            if (configEntry.getDN().equals(DN.decode(CHANGELOG_DN))) {
                return Changelog.checkConfigEntry(configEntry, stringBuilder);
            }
        }
        catch (DirectoryException directoryException) {
            stringBuilder.append("Invalid Changelog configuration DN");
            return false;
        }
        if (configEntry.hasObjectClass(SYNCHRONIZATION_CLASS)) {
            return SynchronizationDomain.checkConfigEntry(configEntry, stringBuilder);
        }
        return false;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        if (configEntry.getDN().equals(this.changelogConfigEntryDn)) {
            try {
                this.changelog = new Changelog(configEntry);
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
            catch (ConfigException configException) {
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
        }
        if (configEntry.hasObjectClass(SYNCHRONIZATION_CLASS)) {
            try {
                this.createNewSynchronizationDomain(configEntry);
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
            catch (ConfigException configException) {
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private void createNewSynchronizationDomain(ConfigEntry configEntry) throws ConfigException {
        SynchronizationDomain synchronizationDomain = new SynchronizationDomain(configEntry);
        domains.put(synchronizationDomain.getBaseDN(), synchronizationDomain);
        synchronizationDomain.start();
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        return null;
    }

    public void doPostOperation(AddOperation addOperation) {
        DN dN = addOperation.getEntryDN();
        this.genericPostOperation(addOperation, dN);
    }

    public void doPostOperation(DeleteOperation deleteOperation) {
        DN dN = deleteOperation.getEntryDN();
        this.genericPostOperation(deleteOperation, dN);
    }

    public void doPostOperation(ModifyDNOperation modifyDNOperation) {
        DN dN = modifyDNOperation.getEntryDN();
        this.genericPostOperation(modifyDNOperation, dN);
    }

    public void doPostOperation(ModifyOperation modifyOperation) {
        DN dN = modifyOperation.getEntryDN();
        this.genericPostOperation(modifyOperation, dN);
    }

    public SynchronizationProviderResult handleConflictResolution(ModifyOperation modifyOperation) {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(modifyOperation.getEntryDN());
        if (synchronizationDomain == null) {
            return new SynchronizationProviderResult(true);
        }
        return synchronizationDomain.handleConflictResolution(modifyOperation);
    }

    public SynchronizationProviderResult handleConflictResolution(AddOperation addOperation) throws DirectoryException {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(addOperation.getEntryDN());
        if (synchronizationDomain == null) {
            return new SynchronizationProviderResult(true);
        }
        return synchronizationDomain.handleConflictResolution(addOperation);
    }

    public SynchronizationProviderResult handleConflictResolution(DeleteOperation deleteOperation) throws DirectoryException {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(deleteOperation.getEntryDN());
        if (synchronizationDomain == null) {
            return new SynchronizationProviderResult(true);
        }
        return synchronizationDomain.handleConflictResolution(deleteOperation);
    }

    public SynchronizationProviderResult handleConflictResolution(ModifyDNOperation modifyDNOperation) throws DirectoryException {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(modifyDNOperation.getEntryDN());
        if (synchronizationDomain == null) {
            return new SynchronizationProviderResult(true);
        }
        return synchronizationDomain.handleConflictResolution(modifyDNOperation);
    }

    public SynchronizationProviderResult doPreOperation(ModifyOperation modifyOperation) {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(modifyOperation.getEntryDN());
        if (synchronizationDomain == null) {
            return new SynchronizationProviderResult(true);
        }
        Historical historical = (Historical)modifyOperation.getAttachment("ds-synch-historical");
        if (historical == null) {
            Entry entry = modifyOperation.getModifiedEntry();
            historical = Historical.load(entry);
            modifyOperation.setAttachment("ds-synch-historical", historical);
        }
        historical.generateState(modifyOperation);
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult doPreOperation(DeleteOperation deleteOperation) throws DirectoryException {
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult doPreOperation(ModifyDNOperation modifyDNOperation) throws DirectoryException {
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult doPreOperation(AddOperation addOperation) {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(addOperation.getEntryDN());
        if (synchronizationDomain == null) {
            return new SynchronizationProviderResult(true);
        }
        if (!addOperation.isSynchronizationOperation()) {
            synchronizationDomain.doPreOperation(addOperation);
        }
        return new SynchronizationProviderResult(true);
    }

    public void finalizeSynchronizationProvider() {
        for (SynchronizationDomain synchronizationDomain : domains.values()) {
            synchronizationDomain.shutdown();
        }
        if (this.changelog != null) {
            Changelog.shutdown();
        }
    }

    private static SynchronizationDomain findDomain(DN dN) {
        SynchronizationDomain synchronizationDomain = null;
        DN dN2 = dN;
        do {
            synchronizationDomain = domains.get(dN2);
        } while ((dN2 = dN2.getParent()) != null && synchronizationDomain == null);
        if (synchronizationDomain != null && synchronizationDomain.getServerStateDN().equals(dN)) {
            return null;
        }
        return synchronizationDomain;
    }

    private void genericPostOperation(Operation operation, DN dN) {
        SynchronizationDomain synchronizationDomain = MultimasterSynchronization.findDomain(dN);
        if (synchronizationDomain == null) {
            return;
        }
        synchronizationDomain.synchronize(operation);
    }
}

