/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.core.DirectoryServer;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationMonitor
extends MonitorProvider {
    private SynchronizationDomain domain;

    public SynchronizationMonitor(SynchronizationDomain synchronizationDomain) {
        super("Synchronization monitor " + synchronizationDomain.getBaseDN().toString());
        this.domain = synchronizationDomain;
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "synchronization plugin " + this.domain.getBaseDN().toString();
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute = new Attribute("base-dn", this.domain.getBaseDN().toString());
        arrayList.add(attribute);
        attribute = new Attribute("connected-to", this.domain.getChangelogServer());
        arrayList.add(attribute);
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType("received-updates");
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(this.domain.getNumRcvdUpdates())));
        attribute = new Attribute(attributeType, "received-updates", linkedHashSet);
        arrayList.add(attribute);
        attributeType = DirectoryServer.getDefaultAttributeType("sent-updates");
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(this.domain.getNumSentUpdates())));
        attribute = new Attribute(attributeType, "sent-updates", linkedHashSet);
        arrayList.add(attribute);
        attributeType = DirectoryServer.getDefaultAttributeType("pending-updates");
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(this.domain.getPendingUpdatesCount())));
        attribute = new Attribute(attributeType, "pending-updates", linkedHashSet);
        arrayList.add(attribute);
        attributeType = DirectoryServer.getDefaultAttributeType("replayed-updates");
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(this.domain.getNumProcessedUpdates())));
        attribute = new Attribute(attributeType, "replayed-updates", linkedHashSet);
        arrayList.add(attribute);
        attributeType = DirectoryServer.getDefaultAttributeType("replayed-updates-ok");
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(this.domain.getNumReplayedPostOpCalled())));
        attribute = new Attribute(attributeType, "replayed-updates-ok", linkedHashSet);
        arrayList.add(attribute);
        attributeType = DirectoryServer.getDefaultAttributeType("debug-count");
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(this.domain.getDebugCount())));
        attribute = new Attribute(attributeType, "debug-count", linkedHashSet);
        arrayList.add(attribute);
        attributeType = DirectoryServer.getDefaultAttributeType("server-state");
        linkedHashSet = new LinkedHashSet();
        for (String string : this.domain.getServerState().toStringSet()) {
            linkedHashSet.add(new AttributeValue(attributeType, string));
        }
        attribute = new Attribute(attributeType, "server-state", linkedHashSet);
        arrayList.add(attribute);
        return arrayList;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }
}

