/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.opends.server.api.Backend;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class BackupTask
extends Task {
    private static final String CLASS_NAME = "org.opends.server.tasks.BackupTask";
    private boolean backUpAll;
    private boolean compress;
    private boolean encrypt;
    private boolean hash;
    private boolean incremental;
    private boolean signHash;
    private List<String> backendIDList;
    private String backupID;
    private File backupDirectory;
    private String incrementalBase;
    private Map<String, ConfigEntry> configEntries;
    private ArrayList<Backend> backendsToArchive;

    public void initializeTask() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeTask", new String[0]));
        Entry entry = this.getTaskEntry();
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-backup-all", true);
        AttributeType attributeType2 = DirectoryServer.getAttributeType("ds-task-backup-compress", true);
        AttributeType attributeType3 = DirectoryServer.getAttributeType("ds-task-backup-encrypt", true);
        AttributeType attributeType4 = DirectoryServer.getAttributeType("ds-task-backup-hash", true);
        AttributeType attributeType5 = DirectoryServer.getAttributeType("ds-task-backup-incremental", true);
        AttributeType attributeType6 = DirectoryServer.getAttributeType("ds-task-backup-sign-hash", true);
        AttributeType attributeType7 = DirectoryServer.getAttributeType("ds-task-backup-backend-id", true);
        AttributeType attributeType8 = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeType attributeType9 = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeType attributeType10 = DirectoryServer.getAttributeType("ds-task-backup-incremental-base-id", true);
        List<Attribute> list = entry.getAttribute(attributeType);
        this.backUpAll = TaskUtils.getBoolean(list, false);
        list = entry.getAttribute(attributeType2);
        this.compress = TaskUtils.getBoolean(list, false);
        list = entry.getAttribute(attributeType3);
        this.encrypt = TaskUtils.getBoolean(list, false);
        list = entry.getAttribute(attributeType4);
        this.hash = TaskUtils.getBoolean(list, false);
        list = entry.getAttribute(attributeType5);
        this.incremental = TaskUtils.getBoolean(list, false);
        list = entry.getAttribute(attributeType6);
        this.signHash = TaskUtils.getBoolean(list, false);
        list = entry.getAttribute(attributeType7);
        this.backendIDList = TaskUtils.getMultiValueString(list);
        list = entry.getAttribute(attributeType8);
        this.backupID = TaskUtils.getSingleValueString(list);
        list = entry.getAttribute(attributeType9);
        String string = TaskUtils.getSingleValueString(list);
        this.backupDirectory = new File(string);
        if (!this.backupDirectory.isAbsolute()) {
            this.backupDirectory = new File(DirectoryServer.getServerRoot(), string);
        }
        list = entry.getAttribute(attributeType10);
        this.incrementalBase = TaskUtils.getSingleValueString(list);
        this.configEntries = TaskUtils.getBackendConfigEntries();
    }

    private boolean argumentsAreValid() {
        if (this.backUpAll) {
            if (!this.backendIDList.isEmpty()) {
                int n = 10748179;
                String string = MessageHandler.getMessage(n, "ds-task-backup-all", "ds-task-backup-backend-id");
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return false;
            }
        } else if (this.backendIDList.isEmpty()) {
            int n = 10748180;
            String string = MessageHandler.getMessage(n, "ds-task-backup-all", "ds-task-backup-backend-id");
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        if (this.backupID == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.backupID = simpleDateFormat.format(new Date());
        }
        if (this.incrementalBase != null && !this.incremental) {
            int n = 10748192;
            String string = MessageHandler.getMessage(n, "ds-task-backup-incremental-base-id", "ds-task-backup-incremental");
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        if (this.signHash && !this.hash) {
            int n = 10748230;
            String string = MessageHandler.getMessage(n, "ds-task-backup-sign-hash", "ds-task-backup-hash");
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        if (!this.backupDirectory.exists()) {
            try {
                this.backupDirectory.mkdirs();
            }
            catch (Exception exception) {
                int n = 10748181;
                String string = MessageHandler.getMessage(n, this.backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                System.err.println(string);
                return false;
            }
        }
        int n = this.configEntries.size();
        this.backendsToArchive = new ArrayList(n);
        if (this.backUpAll) {
            for (Map.Entry object : this.configEntries.entrySet()) {
                Backend backend = DirectoryServer.getBackend((String)object.getKey());
                if (backend == null || !backend.supportsBackup()) continue;
                this.backendsToArchive.add(backend);
            }
        } else {
            for (String string : this.backendIDList) {
                String string2;
                int n2;
                Backend backend = DirectoryServer.getBackend(string);
                if (backend == null || this.configEntries.get(string) == null) {
                    n2 = 10748165;
                    string2 = MessageHandler.getMessage(n2, string);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n2);
                    continue;
                }
                if (!backend.supportsBackup()) {
                    n2 = 10617110;
                    string2 = MessageHandler.getMessage(n2, backend.getBackendID());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string2, n2);
                    continue;
                }
                this.backendsToArchive.add(backend);
            }
            if (this.backendsToArchive.size() != this.backendIDList.size()) {
                return false;
            }
        }
        if (this.backendsToArchive.isEmpty()) {
            int n3 = 10617111;
            String string = MessageHandler.getMessage(n3);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n3);
            return false;
        }
        return true;
    }

    private boolean backupBackend(Backend backend, File file) {
        BackupDirectory backupDirectory;
        Object object;
        ConfigEntry configEntry = this.configEntries.get(backend.getBackendID());
        if (file.exists()) {
            object = file.getPath() + File.separator + "backup.info";
            File file2 = new File((String)object);
            if (file2.exists()) {
                try {
                    backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(file.getPath());
                }
                catch (ConfigException configException) {
                    int n = 10748185;
                    String string = MessageHandler.getMessage(n, object, configException.getMessage());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    return false;
                }
                catch (Exception exception) {
                    int n = 10748185;
                    String string = MessageHandler.getMessage(n, object, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    return false;
                }
            } else {
                backupDirectory = new BackupDirectory(file.getPath(), configEntry.getDN());
            }
        } else {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                int n = 10748181;
                String string = MessageHandler.getMessage(n, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return false;
            }
            backupDirectory = new BackupDirectory(file.getPath(), configEntry.getDN());
        }
        object = new BackupConfig(backupDirectory, this.backupID, this.incremental);
        ((BackupConfig)object).setCompressData(this.compress);
        ((BackupConfig)object).setEncryptData(this.encrypt);
        ((BackupConfig)object).setHashData(this.hash);
        ((BackupConfig)object).setSignHash(this.signHash);
        ((BackupConfig)object).setIncrementalBaseID(this.incrementalBase);
        try {
            backend.createBackup(configEntry, (BackupConfig)object);
        }
        catch (DirectoryException directoryException) {
            int n = 10748169;
            String string = MessageHandler.getMessage(n, backend.getBackendID(), directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        catch (Exception exception) {
            int n = 10748169;
            String string = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        return true;
    }

    private boolean lockBackend(Backend backend) {
        try {
            String string = LockFileManager.getBackendLockFileName(backend);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(string, stringBuilder)) {
                int n = 10748232;
                String string2 = MessageHandler.getMessage(n, backend.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                return false;
            }
        }
        catch (Exception exception) {
            int n = 10748232;
            String string = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        return true;
    }

    private boolean unlockBackend(Backend backend) {
        try {
            String string = LockFileManager.getBackendLockFileName(backend);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.releaseLock(string, stringBuilder)) {
                int n = 10617161;
                String string2 = MessageHandler.getMessage(n, backend.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string2, n);
                return false;
            }
        }
        catch (Exception exception) {
            int n = 10617161;
            String string = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string, n);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        assert (Debug.debugEnter(CLASS_NAME, "runTask", new String[0]));
        if (!this.argumentsAreValid()) {
            return TaskState.STOPPED_BY_ERROR;
        }
        boolean bl = this.backUpAll ? true : this.backendsToArchive.size() > 1;
        boolean bl2 = false;
        for (Backend object2 : this.backendsToArchive) {
            if (!this.lockBackend(object2)) {
                bl2 = true;
                continue;
            }
            try {
                int n = 10944792;
                String string = MessageHandler.getMessage(n, object2.getBackendID());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                File file = bl ? new File(this.backupDirectory, object2.getBackendID()) : this.backupDirectory;
                if (this.backupBackend(object2, file)) continue;
                bl2 = true;
            }
            finally {
                if (this.unlockBackend(object2)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            int n = 10944794;
            String string = MessageHandler.getMessage(n);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        int n = 10944795;
        String string = MessageHandler.getMessage(n);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

