/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUtils {
    private static final String CLASS_NAME = "org.opends.server.tasks.TaskUtils";

    public static String getBackendID(ConfigEntry configEntry) {
        try {
            int n = 3146110;
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            String string = stringConfigAttribute2.activeValue();
            return string;
        }
        catch (ConfigException configException) {
            int n = 10748121;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), configException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return null;
        }
        catch (Exception exception) {
            int n = 10748121;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return null;
        }
    }

    public static Map<String, ConfigEntry> getBackendConfigEntries() {
        HashMap<String, ConfigEntry> hashMap = new HashMap<String, ConfigEntry>();
        DN dN = null;
        try {
            dN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException directoryException) {
            int n = 10748001;
            String string = MessageHandler.getMessage(n, "cn=Backends,cn=config", directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return hashMap;
        }
        catch (Exception exception) {
            int n = 10748001;
            String string = MessageHandler.getMessage(n, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return hashMap;
        }
        ConfigEntry configEntry = null;
        try {
            configEntry = DirectoryServer.getConfigEntry(dN);
        }
        catch (ConfigException configException) {
            int n = 10748002;
            String string = MessageHandler.getMessage(n, "cn=Backends,cn=config", configException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return hashMap;
        }
        catch (Exception exception) {
            int n = 10748002;
            String string = MessageHandler.getMessage(n, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return hashMap;
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            Object object;
            String string = null;
            try {
                int n = 3146110;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
                object = (StringConfigAttribute)configEntry2.getConfigAttribute(stringConfigAttribute);
                if (object == null) continue;
                string = ((StringConfigAttribute)object).activeValue();
            }
            catch (ConfigException configException) {
                int n = 10748121;
                object = MessageHandler.getMessage(n, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                continue;
            }
            catch (Exception exception) {
                int n = 10748121;
                object = MessageHandler.getMessage(n, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                continue;
            }
            hashMap.put(string, configEntry2);
        }
        return hashMap;
    }

    public static ConfigEntry getConfigEntry(Backend backend) {
        Map<String, ConfigEntry> map = TaskUtils.getBackendConfigEntries();
        return map.get(backend.getBackendID());
    }

    public static void setBackendEnabled(ConfigEntry configEntry, boolean bl) throws DirectoryException {
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(1);
        if (bl) {
            arrayList.add(new ASN1OctetString("TRUE"));
        } else {
            arrayList.add(new ASN1OctetString("FALSE"));
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute("ds-cfg-backend-enabled", arrayList);
        LDAPModification lDAPModification = new LDAPModification(ModificationType.REPLACE, lDAPAttribute);
        ArrayList<LDAPModification> arrayList2 = new ArrayList<LDAPModification>(1);
        arrayList2.add(lDAPModification);
        InternalClientConnection internalClientConnection = InternalClientConnection.getRootConnection();
        String string = configEntry.getDN().toString();
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
        ModifyOperation modifyOperation = internalClientConnection.processModify(aSN1OctetString, arrayList2);
        ResultCode resultCode = modifyOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            int n = bl ? 11796481 : 11796482;
            String string2 = MessageHandler.getMessage(n, string);
            throw new DirectoryException(resultCode, string2, n);
        }
    }

    public static boolean getBoolean(List<Attribute> list, boolean bl) {
        if (list == null || list.isEmpty()) {
            return bl;
        }
        for (Attribute attribute : list) {
            for (AttributeValue attributeValue : attribute.getValues()) {
                String string = StaticUtils.toLowerCase(attributeValue.getStringValue());
                if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
                    return true;
                }
                if (!string.equals("false") && !string.equals("no") && !string.equals("off") && !string.equals("0")) continue;
                return false;
            }
        }
        return bl;
    }

    public static ArrayList<String> getMultiValueString(List<Attribute> list) {
        Attribute attribute;
        LinkedHashSet<AttributeValue> linkedHashSet;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && !list.isEmpty() && (linkedHashSet = (attribute = list.get(0)).getValues()) != null && !linkedHashSet.isEmpty()) {
            for (AttributeValue attributeValue : linkedHashSet) {
                arrayList.add(attributeValue.getStringValue());
            }
        }
        return arrayList;
    }

    public static String getSingleValueString(List<Attribute> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string = null;
        Attribute attribute = list.get(0);
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet != null && !linkedHashSet.isEmpty()) {
            string = ((AttributeValue)linkedHashSet.iterator().next()).getStringValue();
        }
        return string;
    }

    public static int getSingleValueInteger(List<Attribute> list, int n) {
        block3: {
            Attribute attribute;
            LinkedHashSet<AttributeValue> linkedHashSet;
            if (list != null && !list.isEmpty() && (linkedHashSet = (attribute = list.get(0)).getValues()) != null && !linkedHashSet.isEmpty()) {
                String string = ((AttributeValue)linkedHashSet.iterator().next()).getStringValue();
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getSingleValueInteger", numberFormatException)) break block3;
                    throw new AssertionError();
                }
            }
        }
        return n;
    }
}

