/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPSearchOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSearch {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPSearch";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPSearch(AtomicInteger atomicInteger, PrintStream printStream, PrintStream printStream2) {
        this.nextMessageID = atomicInteger;
        this.out = printStream;
        this.err = printStream2;
    }

    public void executeSearch(LDAPConnection lDAPConnection, String string, ArrayList<LDAPFilter> arrayList, LinkedHashSet<String> linkedHashSet, LDAPSearchOptions lDAPSearchOptions, int n) throws IOException, LDAPException {
        for (LDAPFilter lDAPFilter : arrayList) {
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            SearchRequestProtocolOp searchRequestProtocolOp = new SearchRequestProtocolOp(aSN1OctetString, lDAPSearchOptions.getSearchScope(), lDAPSearchOptions.getDereferencePolicy(), lDAPSearchOptions.getSizeLimit(), lDAPSearchOptions.getTimeLimit(), false, lDAPFilter, linkedHashSet);
            try {
                byte by;
                boolean bl = lDAPSearchOptions.getTypesOnly();
                LDAPMessage lDAPMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), searchRequestProtocolOp, lDAPSearchOptions.getControls());
                int n2 = lDAPConnection.getASN1Writer().writeElement(lDAPMessage.encode());
                do {
                    int n3 = 0;
                    String string2 = null;
                    ASN1Element aSN1Element = lDAPConnection.getASN1Reader().readElement();
                    LDAPMessage lDAPMessage2 = LDAPMessage.decode(ASN1Sequence.decodeAsSequence(aSN1Element));
                    ArrayList<LDAPControl> arrayList2 = lDAPMessage2.getControls();
                    by = lDAPMessage2.getProtocolOpType();
                    switch (by) {
                        case 100: {
                            Object n5;
                            Object exception;
                            for (LDAPControl lDAPControl : arrayList2) {
                                if (lDAPControl.getOID().equals("2.16.840.1.113730.3.4.7")) {
                                    try {
                                        exception = EntryChangeNotificationControl.decodeControl(lDAPControl.getControl());
                                        this.out.println("# Persistent Search Change Type:  " + ((EntryChangeNotificationControl)exception).getChangeType().toString());
                                        n5 = ((EntryChangeNotificationControl)exception).getPreviousDN();
                                        if (n5 == null) continue;
                                        this.out.println("# Persistent Search Previous DN:  " + ((DN)n5).toString());
                                    }
                                    catch (Exception exception2) {}
                                    continue;
                                }
                                if (!lDAPControl.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.8")) continue;
                                try {
                                    String string3;
                                    exception = AccountUsableResponseControl.decodeControl(lDAPControl.getControl());
                                    this.out.println("# Account Usable Response Control");
                                    if (((AccountUsableResponseControl)exception).isUsable()) {
                                        this.out.println("#   Account is usable");
                                        if (((AccountUsableResponseControl)exception).getSecondsBeforeExpiration() <= 0) continue;
                                        int n4 = ((AccountUsableResponseControl)exception).getSecondsBeforeExpiration();
                                        string3 = StaticUtils.secondsToTimeString(n4);
                                        this.out.println("#   Time until expiration:  " + string3);
                                        continue;
                                    }
                                    this.out.println("#   Account is not usable");
                                    if (((AccountUsableResponseControl)exception).isInactive()) {
                                        this.out.println("#   Account is inactive");
                                    }
                                    if (((AccountUsableResponseControl)exception).isReset()) {
                                        this.out.println("#   Password has been reset");
                                    }
                                    if (((AccountUsableResponseControl)exception).isExpired()) {
                                        this.out.println("#   Password is expired");
                                        if (((AccountUsableResponseControl)exception).getRemainingGraceLogins() > 0) {
                                            this.out.println("#   Grace logins remaining:  " + ((AccountUsableResponseControl)exception).getRemainingGraceLogins());
                                        }
                                    }
                                    if (!((AccountUsableResponseControl)exception).isLocked()) continue;
                                    this.out.println("#   Account is locked");
                                    if (((AccountUsableResponseControl)exception).getSecondsBeforeUnlock() <= 0) continue;
                                    int n6 = ((AccountUsableResponseControl)exception).getSecondsBeforeUnlock();
                                    string3 = StaticUtils.secondsToTimeString(n6);
                                    this.out.println("#   Time until automatic unlock:  " + string3);
                                }
                                catch (Exception exception3) {}
                            }
                            SearchResultEntryProtocolOp searchResultEntryProtocolOp = lDAPMessage2.getSearchResultEntryProtocolOp();
                            StringBuilder object32 = new StringBuilder();
                            this.toLDIF(searchResultEntryProtocolOp, object32, n, bl);
                            this.out.println(object32.toString());
                            break;
                        }
                        case 115: {
                            Object exception = lDAPMessage2.getSearchResultReferenceProtocolOp();
                            this.out.println(((ProtocolOp)exception).toString());
                            break;
                        }
                        case 101: {
                            Object n5 = lDAPMessage2.getSearchResultDoneProtocolOp();
                            n3 = ((SearchResultDoneProtocolOp)n5).getResultCode();
                            string2 = ((SearchResultDoneProtocolOp)n5).getErrorMessage();
                            break;
                        }
                        default: {
                            int n7 = 10485870;
                            String string4 = MessageHandler.getMessage(n7, by);
                            this.err.println(string4);
                        }
                    }
                    if (n3 != 0 && n3 != 10) {
                        int n7 = 10485865;
                        if (string2 == null) {
                            string2 = "Result Code:" + n3;
                        }
                        throw new LDAPException(n3, n7, string2);
                    }
                    if (string2 == null) continue;
                    this.out.println();
                    this.out.println(string2);
                } while (by != 101);
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "executeSearch", aSN1Exception));
                throw new IOException(aSN1Exception.getMessage());
            }
        }
    }

    public void toLDIF(SearchResultEntryProtocolOp searchResultEntryProtocolOp, StringBuilder stringBuilder, int n, boolean bl) {
        int n2;
        String string = searchResultEntryProtocolOp.getDN().toString();
        if (StaticUtils.needsBase64Encoding(string)) {
            string = Base64.encode(StaticUtils.getBytes(string));
            stringBuilder.append("dn:: ");
            n2 = n - 5;
        } else {
            stringBuilder.append("dn: ");
            n2 = n - 4;
        }
        int n3 = string.length();
        if (n3 <= n2 || n2 <= 0) {
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        } else {
            stringBuilder.append(string.substring(0, n2));
            stringBuilder.append(ServerConstants.EOL);
            int n4 = n2;
            while (n3 - n4 > n - 1) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4, n4 + n - 1));
                stringBuilder.append(ServerConstants.EOL);
                n4 += n - 1;
            }
            if (n4 < n3) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        LinkedList<LDAPAttribute> linkedList = searchResultEntryProtocolOp.getAttributes();
        for (LDAPAttribute lDAPAttribute : linkedList) {
            String string2 = lDAPAttribute.getAttributeType();
            int n5 = string2.length();
            if (bl) {
                stringBuilder.append(string2);
                stringBuilder.append(ServerConstants.EOL);
                continue;
            }
            for (ASN1OctetString aSN1OctetString : lDAPAttribute.getValues()) {
                String string3;
                if (StaticUtils.needsBase64Encoding(aSN1OctetString.value())) {
                    string3 = Base64.encode(aSN1OctetString.value());
                    stringBuilder.append(string2);
                    stringBuilder.append(":: ");
                    n2 = n - n5 - 3;
                } else {
                    string3 = aSN1OctetString.stringValue();
                    stringBuilder.append(string2);
                    stringBuilder.append(": ");
                    n2 = n - n5 - 2;
                }
                int n6 = string3.length();
                if (n6 <= n2 || n2 <= 0) {
                    stringBuilder.append(string3);
                    stringBuilder.append(ServerConstants.EOL);
                    continue;
                }
                stringBuilder.append(string3.substring(0, n2));
                stringBuilder.append(ServerConstants.EOL);
                int n7 = n2;
                while (n6 - n7 > n - 1) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string3.substring(n7, n7 + n - 1));
                    stringBuilder.append(ServerConstants.EOL);
                    n7 += n - 1;
                }
                if (n7 >= n6) continue;
                stringBuilder.append(" ");
                stringBuilder.append(string3.substring(n7));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append(ServerConstants.EOL);
    }

    public static void main(String[] stringArray) {
        int n = LDAPSearch.mainSearch(stringArray, true, System.out, System.err);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainSearch(String[] stringArray) {
        return LDAPSearch.mainSearch(stringArray, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainSearch(String[] stringArray, boolean bl, OutputStream outputStream, OutputStream outputStream2) {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        PrintStream printStream = outputStream == null ? NullOutputStream.printStream() : new PrintStream(outputStream);
        PrintStream printStream2 = outputStream2 == null ? NullOutputStream.printStream() : new PrintStream(outputStream2);
        LDAPConnectionOptions lDAPConnectionOptions = new LDAPConnectionOptions();
        LDAPSearchOptions lDAPSearchOptions = new LDAPSearchOptions();
        LDAPConnection lDAPConnection = null;
        ArrayList<LDAPFilter> arrayList = new ArrayList<LDAPFilter>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        FileBasedArgument fileBasedArgument = null;
        StringArgument stringArgument5 = null;
        BooleanArgument booleanArgument3 = null;
        BooleanArgument booleanArgument4 = null;
        StringArgument stringArgument6 = null;
        StringArgument stringArgument7 = null;
        StringArgument stringArgument8 = null;
        StringArgument stringArgument9 = null;
        Object var25_25 = null;
        StringArgument stringArgument10 = null;
        IntegerArgument integerArgument = null;
        IntegerArgument integerArgument2 = null;
        BooleanArgument booleanArgument5 = null;
        StringArgument stringArgument11 = null;
        BooleanArgument booleanArgument6 = null;
        BooleanArgument booleanArgument7 = null;
        BooleanArgument booleanArgument8 = null;
        BooleanArgument booleanArgument9 = null;
        BooleanArgument booleanArgument10 = null;
        StringArgument stringArgument12 = null;
        IntegerArgument integerArgument3 = null;
        IntegerArgument integerArgument4 = null;
        StringArgument stringArgument13 = null;
        StringArgument stringArgument14 = null;
        StringArgument stringArgument15 = null;
        BooleanArgument booleanArgument11 = null;
        BooleanArgument booleanArgument12 = null;
        StringArgument stringArgument16 = null;
        StringArgument stringArgument17 = null;
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            booleanArgument = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            stringArgument2 = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, "{baseDN}", null, null, 10485891, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument3 = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            stringArgument4 = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            fileBasedArgument = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFilename}", null, null, 10485874, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            stringArgument5 = new StringArgument("proxy_authzid", Character.valueOf('Y'), "proxyAs", false, false, true, "{authzID}", null, null, 10486114, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            booleanArgument3 = new BooleanArgument("reportauthzid", Character.valueOf('E'), "reportAuthzID", 10486121, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            booleanArgument4 = new BooleanArgument("usepwpolicycontrol", null, "usePasswordPolicyControl", 10486171, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            stringArgument6 = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            stringArgument7 = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argumentParser.addArgument(stringArgument7);
            stringArgument9 = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argumentParser.addArgument(stringArgument9);
            stringArgument8 = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argumentParser.addArgument(stringArgument8);
            stringArgument10 = new StringArgument("host", Character.valueOf('h'), "host", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argumentParser.addArgument(stringArgument10);
            integerArgument = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argumentParser.addArgument(integerArgument);
            integerArgument2 = new IntegerArgument("version", Character.valueOf('V'), "version", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argumentParser.addArgument(integerArgument2);
            stringArgument12 = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 10486123, new Object[0]);
            argumentParser.addArgument(stringArgument12);
            booleanArgument5 = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            argumentParser.setUsageArgument(booleanArgument5, printStream);
            stringArgument11 = new StringArgument("controls", Character.valueOf('J'), "controls", false, false, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argumentParser.addArgument(stringArgument11);
            booleanArgument6 = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argumentParser.addArgument(booleanArgument6);
            booleanArgument7 = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argumentParser.addArgument(booleanArgument7);
            booleanArgument8 = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argumentParser.addArgument(booleanArgument8);
            booleanArgument9 = new BooleanArgument("startTLS", Character.valueOf('q'), "startTLS", 10485886, new Object[0]);
            argumentParser.addArgument(booleanArgument9);
            booleanArgument10 = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argumentParser.addArgument(booleanArgument10);
            integerArgument3 = new IntegerArgument("sizeLimit", Character.valueOf('z'), "sizeLimit", false, false, true, "{sizeLimit}", 0, null, 10485892, new Object[0]);
            argumentParser.addArgument(integerArgument3);
            integerArgument4 = new IntegerArgument("timeLimit", Character.valueOf('l'), "timeLimit", false, false, true, "{timeLimit}", 0, null, 10485893, new Object[0]);
            argumentParser.addArgument(integerArgument4);
            stringArgument13 = new StringArgument("searchScope", Character.valueOf('s'), "searchScope", false, false, true, "{searchScope}", null, null, 10485894, new Object[0]);
            argumentParser.addArgument(stringArgument13);
            stringArgument14 = new StringArgument("dereferencePolicy", Character.valueOf('a'), "dereferencePolicy", false, false, true, "{dereferencePolicy}", null, null, 10485895, new Object[0]);
            argumentParser.addArgument(stringArgument14);
            stringArgument15 = new StringArgument("saslOptions", Character.valueOf('o'), "saslOptions", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argumentParser.addArgument(stringArgument15);
            stringArgument16 = new StringArgument("psearchinfo", Character.valueOf('C'), "persistentSearch", false, false, true, "ps[:changetype[:changesonly[:entrychgcontrols]]]", null, null, 10486115, new Object[0]);
            argumentParser.addArgument(stringArgument16);
            booleanArgument11 = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", 10485975, new Object[0]);
            argumentParser.addArgument(booleanArgument11);
            booleanArgument2 = new BooleanArgument("no-op", Character.valueOf('n'), "noop", 10486087, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            booleanArgument12 = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", 10486098, new Object[0]);
            argumentParser.addArgument(booleanArgument12);
            stringArgument = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, "{filter}", null, null, 10486104, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument17 = new StringArgument("matchedvalues", null, "matchedValuesFilter", false, true, true, "{filter}", null, null, 10486124, new Object[0]);
            argumentParser.addArgument(stringArgument17);
        }
        catch (ArgumentException argumentException) {
            int n2 = 10747920;
            String string2 = MessageHandler.getMessage(n2, argumentException.getMessage());
            printStream2.println(string2);
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n3 = 10747921;
            String string3 = MessageHandler.getMessage(n3, argumentException.getMessage());
            printStream2.println(string3);
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument5.isPresent()) {
            return 0;
        }
        ArrayList<String> arrayList2 = argumentParser.getTrailingArguments();
        if (arrayList2.size() > 0) {
            string = arrayList2.remove(0);
            try {
                arrayList.add(LDAPFilter.decode(string));
            }
            catch (LDAPException lDAPException) {
                assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
                printStream2.println(lDAPException.getMessage());
                return 1;
            }
            for (String string4 : arrayList2) {
                linkedHashSet.add(string4);
            }
        }
        if (stringArgument4.isPresent() && fileBasedArgument.isPresent()) {
            printStream2.println("ERROR: Both -w and -j flags specified. Please specify one.");
            return 1;
        }
        string = stringArgument10.getValue();
        int n4 = 389;
        try {
            n4 = integerArgument.getIntValue();
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(argumentException.getMessage());
            return 1;
        }
        try {
            int n5 = integerArgument2.getIntValue();
            if (n5 != 2 && n5 != 3) {
                int n6 = 10682569;
                printStream2.println(MessageHandler.getMessage(n6, n5));
                return 1;
            }
            lDAPConnectionOptions.setVersionNumber(n5);
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(argumentException.getMessage());
            return 1;
        }
        lDAPConnectionOptions.setReportAuthzID(booleanArgument3.isPresent());
        lDAPConnectionOptions.setUsePasswordPolicyControl(booleanArgument4.isPresent());
        String string5 = stringArgument2.getValue();
        String string6 = stringArgument3.getValue();
        String string7 = stringArgument12.getValue();
        String string8 = stringArgument4.getValue();
        if (string8 != null && string8.equals("-")) {
            try {
                printStream.print(MessageHandler.getMessage(10485959, string6));
                object5 = PasswordReader.readPassword();
                string8 = new String((char[])object5);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(exception.getMessage());
                return 1;
            }
        } else if (string8 == null) {
            string8 = fileBasedArgument.getValue();
        }
        object5 = stringArgument7.getValue();
        String string9 = stringArgument8.getValue();
        String string10 = stringArgument9.getValue();
        String string11 = null;
        lDAPSearchOptions.setTypesOnly(booleanArgument12.isPresent());
        lDAPSearchOptions.setShowOperations(booleanArgument2.isPresent());
        lDAPSearchOptions.setVerbose(booleanArgument6.isPresent());
        lDAPSearchOptions.setContinueOnError(booleanArgument7.isPresent());
        lDAPSearchOptions.setEncoding(stringArgument6.getValue());
        try {
            lDAPSearchOptions.setTimeLimit(integerArgument4.getIntValue());
            lDAPSearchOptions.setSizeLimit(integerArgument3.getIntValue());
        }
        catch (ArgumentException argumentException) {
            printStream2.println(argumentException.getMessage());
            return 1;
        }
        boolean bl2 = lDAPSearchOptions.setSearchScope(stringArgument13.getValue());
        if (!bl2) {
            return 1;
        }
        bl2 = lDAPSearchOptions.setDereferencePolicy(stringArgument14.getValue());
        if (!bl2) {
            return 1;
        }
        if (stringArgument11.hasValue()) {
            object4 = stringArgument11.getValue();
            object3 = LDAPToolUtils.getControl((String)object4);
            if (object3 == null) {
                printStream2.println("Invalid control specified:" + object4);
                printStream2.println(argumentParser.getUsage());
                return 1;
            }
            lDAPSearchOptions.getControls().add((LDAPControl)object3);
        }
        if (stringArgument5.isPresent()) {
            object4 = new ASN1OctetString(stringArgument5.getValue());
            object3 = new ASN1OctetString(((ASN1Element)object4).encode());
            object2 = new LDAPControl("2.16.840.1.113730.3.4.18", true, (ASN1OctetString)object3);
            lDAPSearchOptions.getControls().add((LDAPControl)object2);
        }
        if (stringArgument16.isPresent()) {
            object4 = StaticUtils.toLowerCase(stringArgument16.getValue().trim());
            object3 = new HashSet();
            boolean bl3 = true;
            n = 1;
            object = new StringTokenizer((String)object4, ":");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                int n7 = 10682724;
                String string12 = MessageHandler.getMessage(n7);
                printStream2.println(string12);
                return 1;
            }
            Object object6 = ((StringTokenizer)object).nextToken();
            if (!((String)object6).equals("ps")) {
                int n8 = 10682725;
                String string13 = MessageHandler.getMessage(n8, String.valueOf(object4));
                printStream2.println(string13);
                return 1;
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                object6 = new StringTokenizer(((StringTokenizer)object).nextToken(), ", ");
                while (((StringTokenizer)object6).hasMoreTokens()) {
                    String string14 = ((StringTokenizer)object6).nextToken();
                    if (string14.equals("add")) {
                        ((HashSet)object3).add(PersistentSearchChangeType.ADD);
                        continue;
                    }
                    if (string14.equals("delete") || string14.equals("del")) {
                        ((HashSet)object3).add(PersistentSearchChangeType.DELETE);
                        continue;
                    }
                    if (string14.equals("modify") || string14.equals("mod")) {
                        ((HashSet)object3).add(PersistentSearchChangeType.MODIFY);
                        continue;
                    }
                    if (string14.equals("modifydn") || string14.equals("moddn") || string14.equals("modrdn")) {
                        ((HashSet)object3).add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    if (string14.equals("any") || string14.equals("all")) {
                        ((HashSet)object3).add(PersistentSearchChangeType.ADD);
                        ((HashSet)object3).add(PersistentSearchChangeType.DELETE);
                        ((HashSet)object3).add(PersistentSearchChangeType.MODIFY);
                        ((HashSet)object3).add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    int n9 = 10682726;
                    String string15 = MessageHandler.getMessage(n9, String.valueOf(string14));
                    printStream2.println(string15);
                    return 1;
                }
            }
            if (((HashSet)object3).isEmpty()) {
                ((HashSet)object3).add(PersistentSearchChangeType.ADD);
                ((HashSet)object3).add(PersistentSearchChangeType.DELETE);
                ((HashSet)object3).add(PersistentSearchChangeType.MODIFY);
                ((HashSet)object3).add(PersistentSearchChangeType.MODIFY_DN);
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                object6 = ((StringTokenizer)object).nextToken();
                if (((String)object6).equals("1") || ((String)object6).equals("true") || ((String)object6).equals("yes")) {
                    bl3 = true;
                } else if (((String)object6).equals("0") || ((String)object6).equals("false") || ((String)object6).equals("no")) {
                    bl3 = false;
                } else {
                    int n10 = 10682727;
                    String string16 = MessageHandler.getMessage(n10, String.valueOf(object6));
                    printStream2.println(string16);
                    return 1;
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                object6 = ((StringTokenizer)object).nextToken();
                if (((String)object6).equals("1") || ((String)object6).equals("true") || ((String)object6).equals("yes")) {
                    n = 1;
                } else if (((String)object6).equals("0") || ((String)object6).equals("false") || ((String)object6).equals("no")) {
                    n = 0;
                } else {
                    int n11 = 10682728;
                    String string17 = MessageHandler.getMessage(n11, String.valueOf(object6));
                    printStream2.println(string17);
                    return 1;
                }
            }
            object6 = new PersistentSearchControl((Set<PersistentSearchChangeType>)object3, bl3, n != 0);
            lDAPSearchOptions.getControls().add(new LDAPControl((Control)object6));
        }
        if (stringArgument.isPresent()) {
            object4 = stringArgument.getValue();
            try {
                object3 = LDAPFilter.decode((String)object4);
                object2 = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(((LDAPFilter)object3).encode().encode()));
                lDAPSearchOptions.getControls().add((LDAPControl)object2);
            }
            catch (LDAPException lDAPException) {
                printStream2.println(MessageHandler.getMessage(10682711, lDAPException.getMessage()));
                return 1;
            }
        }
        if (stringArgument17.isPresent()) {
            object4 = stringArgument17.getValues();
            object3 = new ArrayList();
            object2 = ((AbstractSequentialList)object4).iterator();
            while (object2.hasNext()) {
                String string18 = (String)object2.next();
                try {
                    object = LDAPFilter.decode(string18);
                    ((ArrayList)object3).add(MatchedValuesFilter.createFromLDAPFilter((LDAPFilter)object));
                }
                catch (LDAPException lDAPException) {
                    printStream2.println(MessageHandler.getMessage(10682733, lDAPException.getMessage()));
                    return 1;
                }
            }
            object2 = new MatchedValuesControl(true, (ArrayList<MatchedValuesFilter>)object3);
            lDAPSearchOptions.getControls().add(new LDAPControl((Control)object2));
        }
        lDAPConnectionOptions.setSASLExternal(booleanArgument10.isPresent());
        if (stringArgument15.isPresent()) {
            object4 = stringArgument15.getValues();
            object3 = ((AbstractSequentialList)object4).iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!(((String)object2).startsWith("mech=") ? (n = lDAPConnectionOptions.setSASLMechanism((String)object2)) == 0 : (n = lDAPConnectionOptions.addSASLProperty((String)object2)) == 0)) continue;
                return 1;
            }
        }
        lDAPConnectionOptions.setUseSSL(booleanArgument8.isPresent());
        lDAPConnectionOptions.setStartTLS(booleanArgument9.isPresent());
        if (lDAPConnectionOptions.useSASLExternal()) {
            if (!lDAPConnectionOptions.useSSL() && !lDAPConnectionOptions.useStartTLS()) {
                printStream2.println("SASL External requires either SSL or StartTLS options to be requested.");
                return 1;
            }
            if (object5 == null) {
                printStream2.println("SASL External requires a path to the SSL client certificate keystore.");
                return 1;
            }
        }
        if (string7 != null) {
            object4 = null;
            try {
                object4 = new BufferedReader(new FileReader(string7));
                object3 = null;
                while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                    if (((String)object3).trim().equals("")) continue;
                    object2 = LDAPFilter.decode((String)object3);
                    arrayList.add((LDAPFilter)object2);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(exception.getMessage());
                int n12 = 1;
                return n12;
            }
            finally {
                if (object4 != null) {
                    try {
                        ((BufferedReader)object4).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (arrayList.isEmpty()) {
            int n13 = 10748110;
            printStream2.println(MessageHandler.getMessage(n13));
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        int n14 = 80;
        if (booleanArgument11.isPresent()) {
            n14 = 0;
        }
        try {
            if (bl) {
                DirectoryServer.bootstrapClient();
            }
            object3 = null;
            if (lDAPConnectionOptions.useSSL() || lDAPConnectionOptions.useStartTLS()) {
                object3 = new SSLConnectionFactory();
                ((SSLConnectionFactory)object3).init(booleanArgument.isPresent(), (String)object5, string9, string10, string11);
                lDAPConnectionOptions.setSSLConnectionFactory((SSLConnectionFactory)object3);
            }
            object2 = new AtomicInteger(1);
            lDAPConnection = new LDAPConnection(string, n4, lDAPConnectionOptions, printStream, printStream2);
            lDAPConnection.connectToHost(string6, string8, (AtomicInteger)object2);
            LDAPSearch lDAPSearch = new LDAPSearch((AtomicInteger)object2, printStream, printStream2);
            lDAPSearch.executeSearch(lDAPConnection, string5, arrayList, linkedHashSet, lDAPSearchOptions, n14);
        }
        catch (LDAPException lDAPException) {
            int n15;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
            printStream2.println(lDAPException.getMessage());
            n = n15 = lDAPException.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lDAPConnectionException) {
            int n16;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPConnectionException));
            printStream2.println(lDAPConnectionException.getMessage());
            n = n16 = lDAPConnectionException.getErrorCode();
            return n;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "main", exception));
            printStream2.println(exception.getMessage());
            int n17 = 1;
            return n17;
        }
        finally {
            if (lDAPConnection != null) {
                lDAPConnection.close();
            }
        }
        return 0;
    }
}

