/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.server.config.ConfigFileHandler;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFModify {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFModify";

    public static boolean modifyLDIF(LDIFReader lDIFReader, LDIFReader lDIFReader2, LDIFWriter lDIFWriter, List<String> list) throws IOException, LDIFException {
        Object object;
        Object object2;
        Object object32;
        Iterator<Object> iterator;
        HashMap<DN, AddChangeRecordEntry> hashMap = new HashMap<DN, AddChangeRecordEntry>();
        HashMap<DN, DeleteChangeRecordEntry> hashMap2 = new HashMap<DN, DeleteChangeRecordEntry>();
        HashMap hashMap3 = new HashMap();
        block14: while (true) {
            try {
                iterator = lDIFReader2.readChangeRecord(false);
            }
            catch (LDIFException lDIFException) {
                if (lDIFException.canContinueReading()) {
                    list.add(lDIFException.getMessage());
                    continue;
                }
                throw lDIFException;
            }
            if (iterator == null) break;
            object32 = ((ChangeRecordEntry)((Object)iterator)).getDN();
            switch (((ChangeRecordEntry)((Object)iterator)).getChangeOperationType()) {
                case ADD: {
                    if (hashMap.containsKey(object32)) {
                        int n = 10682978;
                        list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
                        continue block14;
                    }
                    hashMap.put((DN)object32, (AddChangeRecordEntry)((Object)iterator));
                    break;
                }
                case DELETE: {
                    if (hashMap.containsKey(object32)) {
                        int n = 10682979;
                        list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
                        continue block14;
                    }
                    hashMap3.remove(object32);
                    hashMap2.put((DN)object32, (DeleteChangeRecordEntry)((Object)iterator));
                    break;
                }
                case MODIFY: {
                    if (hashMap.containsKey(object32) || hashMap2.containsKey(object32)) {
                        int n = 10682980;
                        list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
                        continue block14;
                    }
                    LinkedList<Modification> linkedList = (LinkedList<Modification>)hashMap3.get(object32);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Modification>();
                        hashMap3.put(object32, linkedList);
                    }
                    object2 = ((ModifyChangeRecordEntry)((Object)iterator)).getModifications().iterator();
                    while (true) {
                        if (!object2.hasNext()) continue block14;
                        object = (LDAPModification)object2.next();
                        try {
                            linkedList.add(((LDAPModification)object).toModification());
                        }
                        catch (LDAPException lDAPException) {
                            list.add(lDAPException.getMessage());
                        }
                    }
                }
                case MODIFY_DN: {
                    int n = 10682981;
                    list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
                    continue block14;
                }
                default: {
                    int n = 10682982;
                    list.add(MessageHandler.getMessage(n, String.valueOf(object32), String.valueOf((Object)((ChangeRecordEntry)((Object)iterator)).getChangeOperationType())));
                    continue block14;
                }
            }
        }
        while (true) {
            try {
                iterator = lDIFReader.readEntry();
            }
            catch (LDIFException lDIFException) {
                if (lDIFException.canContinueReading()) {
                    list.add(lDIFException.getMessage());
                    continue;
                }
                throw lDIFException;
            }
            if (iterator == null) break;
            object32 = ((Entry)((Object)iterator)).getDN();
            if (hashMap2.remove(object32) != null) continue;
            if (hashMap.remove(object32) != null) {
                int n = 10682983;
                list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
                continue;
            }
            LinkedList linkedList = (LinkedList)hashMap3.remove(object32);
            if (linkedList != null && !linkedList.isEmpty()) {
                try {
                    ((Entry)((Object)iterator)).applyModifications(linkedList);
                }
                catch (DirectoryException directoryException) {
                    list.add(directoryException.getErrorMessage());
                    continue;
                }
            }
            lDIFWriter.writeEntry((Entry)((Object)iterator));
        }
        for (Object object32 : hashMap.values()) {
            LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>();
            object2 = new LinkedHashMap();
            object = new LinkedHashMap();
            for (Attribute attribute : ((AddChangeRecordEntry)object32).getAttributes()) {
                List<Attribute> list2;
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType.isObjectClassType()) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        String string = attributeValue.getStringValue();
                        String string2 = StaticUtils.toLowerCase(string);
                        ObjectClass objectClass = DirectoryServer.getObjectClass(string2, true);
                        linkedHashMap.put(objectClass, string);
                    }
                    continue;
                }
                if (attributeType.isOperational()) {
                    list2 = (List)object.get(attributeType);
                    if (list2 == null) {
                        list2 = new LinkedList<Attribute>();
                        object.put(attributeType, list2);
                    }
                    list2.add(attribute);
                    continue;
                }
                list2 = (List)object2.get(attributeType);
                if (list2 == null) {
                    list2 = new LinkedList();
                    object2.put(attributeType, list2);
                }
                list2.add(attribute);
            }
            Entry entry = new Entry(((ChangeRecordEntry)object32).getDN(), linkedHashMap, (Map<AttributeType, List<Attribute>>)object2, (Map<AttributeType, List<Attribute>>)object);
            lDIFWriter.writeEntry(entry);
        }
        if (!hashMap2.isEmpty()) {
            for (Object object32 : hashMap2.keySet()) {
                int n = 10682984;
                list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
            }
        }
        if (!hashMap3.isEmpty()) {
            for (Object object32 : hashMap3.keySet()) {
                int n = 10682985;
                list.add(MessageHandler.getMessage(n, String.valueOf(object32)));
            }
        }
        return list.isEmpty();
    }

    public static void main(String[] stringArray) {
        int n = LDIFModify.ldifModifyMain(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int ldifModifyMain(String[] stringArray) {
        boolean bl;
        LDIFWriter lDIFWriter;
        LDIFReader lDIFReader;
        LDIFReader lDIFReader2;
        File file;
        BooleanArgument booleanArgument;
        StringArgument stringArgument;
        StringArgument stringArgument2;
        StringArgument stringArgument3;
        StringArgument stringArgument4;
        StringArgument stringArgument5;
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, false);
        try {
            stringArgument5 = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, "{configFile}", null, null, 10486378, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            stringArgument4 = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10486379, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            stringArgument3 = new StringArgument("sourceldif", Character.valueOf('s'), "sourceLDIF", true, false, true, "{file}", null, null, 10486380, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            stringArgument2 = new StringArgument("changesldif", Character.valueOf('m'), "changesLDIF", true, false, true, "{file}", null, null, 10486381, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument = new StringArgument("targetldif", Character.valueOf('t'), "targetLDIF", true, false, true, "{file}", null, null, 10486382, new Object[0]);
            argumentParser.addArgument(stringArgument);
            booleanArgument = new BooleanArgument("help", Character.valueOf('H'), "help", 10486383, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argumentParser.setUsageArgument(booleanArgument);
        }
        catch (ArgumentException argumentException) {
            int n = 10748528;
            String string = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(string);
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10748529;
            String string = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(string);
            System.err.println(argumentParser.getUsage());
            return 89;
        }
        if (booleanArgument.isPresent()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        boolean bl2 = stringArgument5.isPresent();
        if (bl2) {
            try {
                directoryServer.initializeJMX();
            }
            catch (Exception exception) {
                int n = 10748530;
                String string = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
                System.err.println(string);
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(stringArgument4.getValue(), stringArgument5.getValue());
            }
            catch (Exception exception) {
                int n = 10748531;
                String string = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
                System.err.println(string);
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (Exception exception) {
                int n = 10748532;
                String string = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
                System.err.println(string);
                return 1;
            }
        }
        if (!(file = new File(stringArgument3.getValue())).exists()) {
            int n = 10748533;
            String string = MessageHandler.getMessage(n, stringArgument3.getValue());
            System.err.println(string);
            return 89;
        }
        LDIFImportConfig lDIFImportConfig = new LDIFImportConfig(stringArgument3.getValue());
        try {
            lDIFReader2 = new LDIFReader(lDIFImportConfig);
        }
        catch (IOException iOException) {
            int n = 10748534;
            String string = MessageHandler.getMessage(n, stringArgument3.getValue(), String.valueOf(iOException));
            System.err.println(string);
            return 82;
        }
        File file2 = new File(stringArgument2.getValue());
        if (!file2.exists()) {
            int n = 10748535;
            String string = MessageHandler.getMessage(n, stringArgument2.getValue());
            System.err.println(string);
            return 89;
        }
        lDIFImportConfig = new LDIFImportConfig(stringArgument2.getValue());
        try {
            lDIFReader = new LDIFReader(lDIFImportConfig);
        }
        catch (IOException iOException) {
            int n = 10748536;
            String string = MessageHandler.getMessage(n, stringArgument3.getValue());
            System.err.println(string);
            return 82;
        }
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(stringArgument.getValue(), ExistingFileBehavior.OVERWRITE);
        try {
            lDIFWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (IOException iOException) {
            int n = 10748537;
            String string = MessageHandler.getMessage(n, stringArgument3.getValue());
            System.err.println(string);
            return 82;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            bl = LDIFModify.modifyLDIF(lDIFReader2, lDIFReader, lDIFWriter, linkedList);
        }
        catch (Exception exception) {
            int n = 10748538;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            System.err.println(string);
            bl = false;
        }
        try {
            lDIFReader2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lDIFReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lDIFWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : linkedList) {
            System.err.println(string);
        }
        return bl ? 0 : 1;
    }
}

