/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.StaticTextTag;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Branch {
    private DN branchDN;
    private int[] numEntriesPerTemplate;
    private String[] subordinateTemplateNames;
    private Template[] subordinateTemplates;
    private TemplateFile templateFile;
    private TemplateLine[] rdnLines;
    private TemplateLine[] extraLines;

    public Branch(TemplateFile templateFile, DN dN) {
        this(templateFile, dN, new String[0], new int[0], new TemplateLine[0]);
    }

    public Branch(TemplateFile templateFile, DN dN, String[] stringArray, int[] nArray, TemplateLine[] templateLineArray) {
        Tag[] tagArray;
        String[] stringArray2;
        this.templateFile = templateFile;
        this.branchDN = dN;
        this.subordinateTemplateNames = stringArray;
        this.numEntriesPerTemplate = nArray;
        this.extraLines = templateLineArray;
        this.subordinateTemplates = null;
        Entry entry = StaticUtils.createEntry(dN);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (String object3 : entry.getObjectClasses().values()) {
            try {
                String[] stringArray3 = new String[]{object3};
                Object object = new Tag[]{new StaticTextTag()};
                object[0].initializeForBranch(templateFile, this, stringArray3, 0, arrayList);
                TemplateLine templateLine = new TemplateLine(DirectoryServer.getObjectClassAttributeType(), 0, (Tag[])object);
                arrayList2.add(templateLine);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (List list : entry.getUserAttributes().values()) {
            for (Object object : list) {
                for (AttributeValue attributeValue : ((Attribute)object).getValues()) {
                    try {
                        stringArray2 = new String[]{attributeValue.getStringValue()};
                        tagArray = new Tag[]{new StaticTextTag()};
                        tagArray[0].initializeForBranch(templateFile, this, stringArray2, 0, arrayList);
                        arrayList2.add(new TemplateLine(((Attribute)object).getAttributeType(), 0, tagArray));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        for (List list : entry.getOperationalAttributes().values()) {
            for (Object object : list) {
                for (AttributeValue attributeValue : ((Attribute)object).getValues()) {
                    try {
                        stringArray2 = new String[]{attributeValue.getStringValue()};
                        tagArray = new Tag[]{new StaticTextTag()};
                        tagArray[0].initializeForBranch(templateFile, this, stringArray2, 0, arrayList);
                        arrayList2.add(new TemplateLine(((Attribute)object).getAttributeType(), 0, tagArray));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        this.rdnLines = new TemplateLine[arrayList2.size()];
        arrayList2.toArray(this.rdnLines);
    }

    public void completeBranchInitialization(Map<String, Template> map) throws MakeLDIFException {
        if (this.subordinateTemplateNames == null) {
            this.subordinateTemplateNames = new String[0];
            this.subordinateTemplates = new Template[0];
        } else {
            this.subordinateTemplates = new Template[this.subordinateTemplateNames.length];
            for (int i = 0; i < this.subordinateTemplates.length; ++i) {
                this.subordinateTemplates[i] = map.get(StaticUtils.toLowerCase(this.subordinateTemplateNames[i]));
                if (this.subordinateTemplates[i] != null) continue;
                int n = 10682911;
                String string = MessageHandler.getMessage(n, this.subordinateTemplateNames[i], this.branchDN.toString());
                throw new MakeLDIFException(n, string);
            }
        }
    }

    public DN getBranchDN() {
        return this.branchDN;
    }

    public String[] getSubordinateTemplateNames() {
        return this.subordinateTemplateNames;
    }

    public Template[] getSubordinateTemplates() {
        return this.subordinateTemplates;
    }

    public int[] getNumEntriesPerTemplate() {
        return this.numEntriesPerTemplate;
    }

    public void addSubordinateTemplate(String string, int n) {
        String[] stringArray = new String[this.subordinateTemplateNames.length + 1];
        int[] nArray = new int[this.numEntriesPerTemplate.length + 1];
        System.arraycopy(this.subordinateTemplateNames, 0, stringArray, 0, this.subordinateTemplateNames.length);
        System.arraycopy(this.numEntriesPerTemplate, 0, nArray, 0, this.numEntriesPerTemplate.length);
        stringArray[this.subordinateTemplateNames.length] = string;
        nArray[this.numEntriesPerTemplate.length] = n;
        this.subordinateTemplateNames = stringArray;
        this.numEntriesPerTemplate = nArray;
    }

    public TemplateLine[] getExtraLines() {
        return this.extraLines;
    }

    public void addExtraLine(TemplateLine templateLine) {
        TemplateLine[] templateLineArray = new TemplateLine[this.extraLines.length + 1];
        System.arraycopy(this.extraLines, 0, templateLineArray, 0, this.extraLines.length);
        templateLineArray[this.extraLines.length] = templateLine;
        this.extraLines = templateLineArray;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        if (this.branchDN.getRDN().hasAttributeType(attributeType)) {
            return true;
        }
        for (TemplateLine templateLine : this.extraLines) {
            if (!templateLine.getAttributeType().equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public TagResult writeEntries(EntryWriter entryWriter) throws IOException, MakeLDIFException {
        TagResult tagResult;
        TemplateEntry templateEntry = new TemplateEntry(this);
        for (TemplateLine templateLine : this.rdnLines) {
            tagResult = templateLine.generateLine(templateEntry);
            if (tagResult.keepProcessingEntry() && tagResult.keepProcessingParent() && tagResult.keepProcessingTemplateFile()) continue;
            return tagResult;
        }
        for (TemplateLine templateLine : this.extraLines) {
            tagResult = templateLine.generateLine(templateEntry);
            if (tagResult.keepProcessingEntry() && tagResult.keepProcessingParent() && tagResult.keepProcessingTemplateFile()) continue;
            return tagResult;
        }
        if (!entryWriter.writeEntry(templateEntry.toEntry())) {
            return TagResult.STOP_PROCESSING;
        }
        for (int i = 0; i < this.subordinateTemplates.length; ++i) {
            TagResult tagResult2 = this.subordinateTemplates[i].writeEntries(entryWriter, this.branchDN, this.numEntriesPerTemplate[i]);
            if (tagResult2.keepProcessingParent() && tagResult2.keepProcessingTemplateFile()) continue;
            if (tagResult2.keepProcessingTemplateFile()) {
                return TagResult.SUCCESS_RESULT;
            }
            return tagResult2;
        }
        return TagResult.SUCCESS_RESULT;
    }
}

